/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/codenavigation/FileLineNavigable;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lookUp", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "arch", "", "codenavigation"})
public final class FileLineNavigable
implements NavSource {
    @NotNull
    private final Project project;

    public FileLineNavigable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location, @Nullable String arch) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CharSequence charSequence = location.getFileName();
        if (charSequence == null || charSequence.length() == 0 || location.getLineNumber() == -1) {
            return null;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String string = location.getFileName();
        Intrinsics.checkNotNull((Object)string);
        VirtualFile virtualFile = localFileSystem.findFileByPath(string);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFile = virtualFile;
        return (Navigatable)new OpenFileDescriptor(this.project, sourceFile, location.getLineNumber(), 0);
    }
}

