/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.codenavigation.NavSource;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010R\"\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator;", "", "source", "Lcom/android/tools/idea/codenavigation/NavSource;", "executor", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "(Lcom/android/tools/idea/codenavigation/NavSource;Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;)V", "cpuArchSource", "Ljava/util/function/Supplier;", "", "getCpuArchSource", "()Ljava/util/function/Supplier;", "setCpuArchSource", "(Ljava/util/function/Supplier;)V", "myListeners", "", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Listener;", "mySource", "getMySource$annotations", "()V", "getMySource", "()Lcom/android/tools/idea/codenavigation/NavSource;", "addListener", "", "listener", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "getNavigatableAsync", "Ljava/util/concurrent/CompletableFuture;", "isNavigatable", "", "navigate", "removeListener", "Companion", "Executor", "Listener", "codenavigation"})
@SourceDebugExtension(value={"SMAP\nCodeNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeNavigator.kt\ncom/android/tools/idea/codenavigation/CodeNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1851#2,2:129\n*S KotlinDebug\n*F\n+ 1 CodeNavigator.kt\ncom/android/tools/idea/codenavigation/CodeNavigator\n*L\n88#1:129,2\n*E\n"})
public final class CodeNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor executor;
    @NotNull
    private final NavSource mySource;
    @NotNull
    private final List<Listener> myListeners;
    @NotNull
    private Supplier<String> cpuArchSource;
    @NotNull
    private static final Executor applicationExecutor = new Executor(){

        public void onForeground(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            ApplicationManager.getApplication().invokeLater(runnable2);
        }

        @NotNull
        public Future<?> onBackground(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"getApplication().executeOnPooledThread(runnable)");
            return future2;
        }
    };
    @NotNull
    private static final Executor testExecutor = new Executor(){

        public void onForeground(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            runnable2.run();
        }

        @NotNull
        public Future<?> onBackground(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable2);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(runnable)");
            return completableFuture;
        }
    };

    public CodeNavigator(@NotNull NavSource source, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        this.executor = executor2;
        this.mySource = source;
        this.myListeners = new ArrayList();
        this.cpuArchSource = cpuArchSource.1.INSTANCE;
    }

    @NotNull
    public final NavSource getMySource() {
        return this.mySource;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMySource$annotations() {
    }

    @NotNull
    public final Supplier<String> getCpuArchSource() {
        return this.cpuArchSource;
    }

    public final void setCpuArchSource(@NotNull Supplier<String> supplier2) {
        Intrinsics.checkNotNullParameter(supplier2, (String)"<set-?>");
        this.cpuArchSource = supplier2;
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.remove(listener2);
    }

    @Nullable
    public final CompletableFuture<Boolean> navigate(@NotNull CodeLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Iterable $this$forEach$iv = this.myListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onNavigated(location);
        }
        return this.getNavigatableAsync(location).thenApplyAsync((Function)navigate.2.INSTANCE, new java.util.concurrent.Executor(this){
            final /* synthetic */ CodeNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@Nullable Runnable runnable2) {
                Executor executor2 = CodeNavigator.access$getExecutor$p(this.this$0);
                Runnable runnable3 = runnable2;
                Intrinsics.checkNotNull((Object)runnable3);
                executor2.onForeground(runnable3);
            }
        });
    }

    @Nullable
    public final CompletableFuture<Boolean> isNavigatable(@NotNull CodeLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getNavigatableAsync(location).thenApply((Function)isNavigatable.1.INSTANCE);
    }

    private final CompletableFuture<Navigatable> getNavigatableAsync(CodeLocation location) {
        CompletableFuture<Navigatable> completableFuture = CompletableFuture.supplyAsync(new Supplier(this, location){
            final /* synthetic */ CodeNavigator this$0;
            final /* synthetic */ CodeLocation $location;
            {
                this.this$0 = $receiver;
                this.$location = $location;
            }

            @Nullable
            public final Navigatable get() {
                return (Navigatable)ReadAction.compute((ThrowableComputable)new ThrowableComputable(this.this$0, this.$location){
                    final /* synthetic */ CodeNavigator this$0;
                    final /* synthetic */ CodeLocation $location;
                    {
                        this.this$0 = $receiver;
                        this.$location = $location;
                    }

                    public final Navigatable compute() {
                        return CodeNavigator.access$getNavigatable(this.this$0, this.$location);
                    }
                });
            }
        }, new java.util.concurrent.Executor(this){
            final /* synthetic */ CodeNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@Nullable Runnable runnable2) {
                Executor executor2 = CodeNavigator.access$getExecutor$p(this.this$0);
                Runnable runnable3 = runnable2;
                Intrinsics.checkNotNull((Object)runnable3);
                executor2.onBackground(runnable3);
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"private fun getNavigatab\u2026kground(runnable!!) }\n  }");
        return completableFuture;
    }

    private final Navigatable getNavigatable(CodeLocation location) {
        return this.mySource.lookUp(location, this.cpuArchSource.get());
    }

    public static final /* synthetic */ Executor access$getExecutor$p(CodeNavigator $this) {
        return $this.executor;
    }

    public static final /* synthetic */ Navigatable access$getNavigatable(CodeNavigator $this, CodeLocation location) {
        return $this.getNavigatable(location);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Companion;", "", "()V", "applicationExecutor", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "getApplicationExecutor", "()Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "testExecutor", "getTestExecutor", "codenavigation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Executor getApplicationExecutor() {
            return applicationExecutor;
        }

        @NotNull
        public final Executor getTestExecutor() {
            return testExecutor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "", "onBackground", "Ljava/util/concurrent/Future;", "runnable", "Ljava/lang/Runnable;", "onForeground", "", "codenavigation"})
    public static interface Executor {
        public void onForeground(@NotNull Runnable var1);

        @NotNull
        public Future<?> onBackground(@NotNull Runnable var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Listener;", "", "onNavigated", "", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "codenavigation"})
    public static interface Listener {
        public void onNavigated(@NotNull CodeLocation var1);
    }
}

