/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.codenavigation.ApkMappingNavigable;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/codenavigation/ApkMappingNavigable;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "libraryMappings", "", "Lcom/android/tools/idea/codenavigation/ApkMappingNavigable$LibraryMapping;", "getLibraryMappings", "lookUp", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "arch", "", "LibraryMapping", "codenavigation"})
@SourceDebugExtension(value={"SMAP\nApkMappingNavigable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApkMappingNavigable.kt\ncom/android/tools/idea/codenavigation/ApkMappingNavigable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n11653#2,9:74\n13543#2:83\n13544#2:85\n11662#2:86\n1#3:84\n513#4:87\n498#4,6:88\n513#4:94\n498#4,6:95\n125#5:101\n152#5,3:102\n*S KotlinDebug\n*F\n+ 1 ApkMappingNavigable.kt\ncom/android/tools/idea/codenavigation/ApkMappingNavigable\n*L\n62#1:74,9\n62#1:83\n62#1:85\n62#1:86\n62#1:84\n66#1:87\n66#1:88,6\n67#1:94\n67#1:95,6\n68#1:101\n68#1:102,3\n*E\n"})
public final class ApkMappingNavigable
implements NavSource {
    @NotNull
    private final Project project;
    @NotNull
    private final List<LibraryMapping> libraryMappings;

    public ApkMappingNavigable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.libraryMappings = this.getLibraryMappings(this.project);
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location, @Nullable String arch) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CharSequence charSequence = location.getFileName();
        if (charSequence == null || charSequence.length() == 0 || location.getLineNumber() == -1) {
            return null;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        return (Navigatable)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.libraryMappings), (Function1)((Function1)new Function1<LibraryMapping, Boolean>(location){
            final /* synthetic */ CodeLocation $location;
            {
                this.$location = $location;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LibraryMapping it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$location.getFileName();
                Intrinsics.checkNotNull((Object)string);
                return StringsKt.startsWith$default((String)string, (String)it.getOriginalPath(), (boolean)false, (int)2, null);
            }
        })), (Function1)((Function1)new Function1<LibraryMapping, VirtualFile>(location, fileSystem){
            final /* synthetic */ CodeLocation $location;
            final /* synthetic */ LocalFileSystem $fileSystem;
            {
                this.$location = $location;
                this.$fileSystem = $fileSystem;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull LibraryMapping it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$location.getFileName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(it.getOriginalPath().length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String pathTailAfterPrefix = string2;
                String[] stringArray = new String[]{pathTailAfterPrefix};
                String newFileName2 = ((Object)Paths.get(it.getLocalPath(), stringArray)).toString();
                return this.$fileSystem.findFileByPath(newFileName2);
            }
        })), (Function1)lookUp.3.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, OpenFileDescriptor>(this, location){
            final /* synthetic */ ApkMappingNavigable this$0;
            final /* synthetic */ CodeLocation $location;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                super(1);
            }

            @NotNull
            public final OpenFileDescriptor invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new OpenFileDescriptor(ApkMappingNavigable.access$getProject$p(this.this$0), it, this.$location.getLineNumber(), 0);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryMapping> getLibraryMappings(Project project) {
        void $this$mapNotNullTo$iv$iv;
        List sourceMap = new ArrayList();
        Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ApkFacet it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (ApkFacet.getInstance((Module)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (ApkFacet apkFacet : (List)destination$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Intrinsics.checkNotNullExpressionValue(((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings(), (String)"apkFacet.configuration.symbolFolderPathMappings");
            List list2 = sourceMap;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                boolean bl4 = ((CharSequence)v).length() > 0;
                if (!bl4) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv2;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getValue(), it.getKey()))) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry it = item$iv$iv = iterator2.next();
                Object object = destination$iv$iv2;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                String string = (String)k;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                object.add(new LibraryMapping(string, (String)v));
            }
            list2.addAll((List)destination$iv$iv2);
        }
        return sourceMap;
    }

    public static final /* synthetic */ Project access$getProject$p(ApkMappingNavigable $this) {
        return $this.project;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/codenavigation/ApkMappingNavigable$LibraryMapping;", "", "originalPath", "", "localPath", "(Ljava/lang/String;Ljava/lang/String;)V", "getLocalPath", "()Ljava/lang/String;", "getOriginalPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "codenavigation"})
    private static final class LibraryMapping {
        @NotNull
        private final String originalPath;
        @NotNull
        private final String localPath;

        public LibraryMapping(@NotNull String originalPath, @NotNull String localPath) {
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            this.originalPath = originalPath;
            this.localPath = localPath;
        }

        @NotNull
        public final String getOriginalPath() {
            return this.originalPath;
        }

        @NotNull
        public final String getLocalPath() {
            return this.localPath;
        }

        @NotNull
        public final String component1() {
            return this.originalPath;
        }

        @NotNull
        public final String component2() {
            return this.localPath;
        }

        @NotNull
        public final LibraryMapping copy(@NotNull String originalPath, @NotNull String localPath) {
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            return new LibraryMapping(originalPath, localPath);
        }

        public static /* synthetic */ LibraryMapping copy$default(LibraryMapping libraryMapping, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = libraryMapping.originalPath;
            }
            if ((n & 2) != 0) {
                string2 = libraryMapping.localPath;
            }
            return libraryMapping.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "LibraryMapping(originalPath=" + this.originalPath + ", localPath=" + this.localPath + ")";
        }

        public int hashCode() {
            int result2 = this.originalPath.hashCode();
            result2 = result2 * 31 + this.localPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LibraryMapping)) {
                return false;
            }
            LibraryMapping libraryMapping = (LibraryMapping)other;
            if (!Intrinsics.areEqual((Object)this.originalPath, (Object)libraryMapping.originalPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.localPath, (Object)libraryMapping.localPath);
        }
    }
}

