/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.emulatorcommand;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.base.Strings;
import com.intellij.execution.configurations.GeneralCommandLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorCommandBuilder {
    @NotNull
    private final Path myEmulator;
    @NotNull
    final AvdInfo myAvd;
    @Nullable
    private Path myAvdHome;
    private boolean myEmulatorSupportsSnapshots;
    @Nullable
    private Path myStudioParams;
    private boolean myLaunchInToolWindow;
    @NotNull
    private final List<String> myStudioEmuParams;

    public EmulatorCommandBuilder(@NotNull Path emulator, @NotNull AvdInfo avd) {
        this.myEmulator = emulator;
        this.myAvd = avd;
        this.myStudioEmuParams = new ArrayList<String>();
    }

    @NotNull
    public final EmulatorCommandBuilder setAvdHome(@Nullable Path avdHome) {
        this.myAvdHome = avdHome;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setEmulatorSupportsSnapshots(boolean emulatorSupportsSnapshots) {
        this.myEmulatorSupportsSnapshots = emulatorSupportsSnapshots;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setStudioParams(@Nullable Path studioParams) {
        this.myStudioParams = studioParams;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder setLaunchInToolWindow(boolean launchInToolWindow) {
        this.myLaunchInToolWindow = launchInToolWindow;
        return this;
    }

    @NotNull
    public final EmulatorCommandBuilder addAllStudioEmuParams(@NotNull Collection<String> studioEmuParams) {
        this.myStudioEmuParams.addAll(studioEmuParams);
        return this;
    }

    @NotNull
    public final GeneralCommandLine build() {
        GeneralCommandLine command = new GeneralCommandLine();
        command.setExePath(this.myEmulator.toString());
        if (this.myAvdHome != null) {
            command.getEnvironment().put("ANDROID_AVD_HOME", this.myAvdHome.toString());
        }
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command, "-netdelay", this.myAvd.getProperty("runtime.network.latency"));
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command, "-netspeed", this.myAvd.getProperty("runtime.network.speed"));
        if (this.myEmulatorSupportsSnapshots) {
            this.addSnapshotParameters(command);
        }
        EmulatorCommandBuilder.addParametersIfParameter2IsntNull(command, "-studio-params", this.myStudioParams);
        command.addParameters(new String[]{"-avd", this.myAvd.getName()});
        if (this.myLaunchInToolWindow) {
            command.addParameter("-qt-hide-window");
            command.addParameter("-grpc-use-token");
            command.addParameters(new String[]{"-idle-grpc-timeout", "300"});
        }
        command.addParameters(this.myStudioEmuParams);
        if (((Boolean)StudioFlags.AVD_COMMAND_LINE_OPTIONS_ENABLED.get()).booleanValue()) {
            String avdCommandLineOptions = this.myAvd.getProperty("commandLineOptions");
            command.addParameters(this.sanitizeCommandLineOptions(avdCommandLineOptions));
        }
        return command;
    }

    private static void addParametersIfParameter2IsntNull(@NotNull GeneralCommandLine command, @NotNull String parameter1, @Nullable Object parameter2) {
        if (parameter2 == null) {
            return;
        }
        command.addParameters(new String[]{parameter1, parameter2.toString()});
    }

    void addSnapshotParameters(@NotNull GeneralCommandLine command) {
    }

    private List<String> sanitizeCommandLineOptions(@Nullable String raw) {
        String trimmed = Strings.nullToEmpty((String)raw).trim();
        if (Strings.isNullOrEmpty((String)trimmed)) {
            return Collections.emptyList();
        }
        String withoutReturnLines = trimmed.replaceAll("\\n", " ");
        return Arrays.asList(withoutReturnLines.split("\\s+"));
    }
}

