/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.emulatorcommand;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.emulatorcommand.BootWithSnapshotEmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.ColdBootEmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilderFactory;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class DefaultEmulatorCommandBuilderFactory
implements EmulatorCommandBuilderFactory {
    @Override
    @NotNull
    public EmulatorCommandBuilder newEmulatorCommandBuilder(@NotNull Path emulator, @NotNull AvdInfo avd) {
        if (Objects.equals(avd.getProperty("fastboot.forceColdBoot"), "yes")) {
            return new ColdBootEmulatorCommandBuilder(emulator, avd);
        }
        if (Objects.equals(avd.getProperty("fastboot.forceChosenSnapshotBoot"), "yes")) {
            String snapshot = Optional.ofNullable(avd.getProperty("fastboot.chosenSnapshotFile")).orElse("");
            return new BootWithSnapshotEmulatorCommandBuilder(emulator, avd, snapshot);
        }
        return new EmulatorCommandBuilder(emulator, avd);
    }
}

