/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.SystemImageListModel;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageList
extends JPanel
implements ListSelectionListener {
    private final TableView<SystemImageDescription> myTable = new TableView();
    private final Set<SystemImageSelectionListener> myListeners = Sets.newHashSet();
    private SystemImageListModel myModel;
    private SystemImageDescription myLastSelectedImage;
    private static final Map<Abi, Integer> DEFAULT_ABI_SORT_ORDER = new ContainerUtil.ImmutableMapBuilder().put((Object)Abi.MIPS64, (Object)0).put((Object)Abi.MIPS, (Object)1).put((Object)Abi.ARM64_V8A, (Object)2).put((Object)Abi.ARMEABI, (Object)3).put((Object)Abi.ARMEABI_V7A, (Object)4).put((Object)Abi.X86_64, (Object)5).put((Object)Abi.X86, (Object)6).build();
    private final MouseAdapter editorListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }
    };

    public SystemImageList() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                TableCellEditor editor = SystemImageList.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                SystemImageList.this.myTable.repaint();
                SystemImageList.this.possiblySwitchEditors(index0, 0);
            }
        };
        selectionModel.setSelectionMode(0);
        this.myTable.setSelectionModel((ListSelectionModel)selectionModel);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.addMouseListener((MouseListener)this.editorListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.editorListener);
        this.setLayout(new BorderLayout());
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JButton installLatestVersionButton = new JButton("Install Latest Version...");
        installLatestVersionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.installForDevice();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myTable.getEmptyText().setText("No System Images available. Are you connected to the internet?");
    }

    public void setModel(@NotNull SystemImageListModel model2) {
        this.myModel = model2;
        this.myTable.setModelAndUpdateColumns((ListTableModel)model2);
    }

    public void setRowFilter(@NotNull RowFilter<ListTableModel<SystemImageDescription>, Integer> filter2) {
        TableRowSorter sorter = (TableRowSorter)this.myTable.getRowSorter();
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.DESCENDING)));
        sorter.setRowFilter(filter2);
        this.myTable.setRowSorter((RowSorter)sorter);
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row2 = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        this.possiblySwitchEditors(row2, col);
    }

    private void possiblySwitchEditors(int row2, int col) {
        if ((row2 != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row2 != -1 && col != -1 && this.myTable.isCellEditable(row2, col)) {
            this.myTable.editCellAt(row2, col);
        }
    }

    public void addSelectionListener(SystemImageSelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    private static boolean isBetter(@NotNull SystemImageDescription image, @Nullable SystemImageDescription bestSoFar) {
        return bestSoFar == null || 0 < ComparisonChain.start().compareTrueFirst(image.isRemote(), bestSoFar.isRemote()).compare(SystemImageList.abiRank(image), SystemImageList.abiRank(bestSoFar)).compare((Comparable)image.getVersion(), (Comparable)bestSoFar.getVersion()).compareFalseFirst(image.getTag().equals((Object)SystemImage.GOOGLE_APIS_TAG), bestSoFar.getTag().equals((Object)SystemImage.GOOGLE_APIS_TAG)).result();
    }

    private static int abiRank(@NotNull SystemImageDescription image) {
        Abi abi = Abi.getEnum((String)image.getAbiType());
        if (abi != null && DEFAULT_ABI_SORT_ORDER.containsKey(abi)) {
            return DEFAULT_ABI_SORT_ORDER.get(abi);
        }
        return -1;
    }

    public void setSelectedImage(@Nullable SystemImageDescription selectedImage) {
        this.myLastSelectedImage = selectedImage;
        this.updateSelection(selectedImage);
    }

    private void updateSelection(@Nullable SystemImageDescription selectedImage) {
        if (selectedImage != null) {
            this.myTable.setSelection((Collection)ImmutableSet.of((Object)selectedImage));
        } else {
            this.myTable.clearSelection();
        }
    }

    public void makeListCurrent() {
        this.notifySelectionChange();
    }

    public void restoreSelection(boolean partlyDownloaded, @Nullable SystemImageDescription defaultSystemImage) {
        SystemImageDescription best = null;
        SystemImageDescription toFind = this.myLastSelectedImage != null ? this.myLastSelectedImage : defaultSystemImage;
        for (int index2 = 0; index2 < this.myTable.getRowCount(); ++index2) {
            SystemImageDescription desc = (SystemImageDescription)this.myModel.getRowValue(this.myTable.convertRowIndexToModel(index2));
            if (desc.equals(toFind) || toFind != null && desc.downloadedFrom(toFind)) {
                best = desc;
                break;
            }
            if (partlyDownloaded || !SystemImageList.isBetter(desc, best)) continue;
            best = desc;
        }
        this.updateSelection(best);
        this.myLastSelectedImage = partlyDownloaded ? toFind : best;
    }

    private void installForDevice() {
        int apiLevel = 33;
        ArrayList requestedPackages = Lists.newArrayListWithCapacity((int)3);
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.DEFAULT_TAG, (String)Abi.X86.toString()));
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.WEAR_TAG, (String)Abi.X86.toString()));
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(32, null), (IdDisplay)SystemImage.DESKTOP_TAG, (String)Abi.X86.toString()));
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.ANDROID_TV_TAG, (String)Abi.X86.toString()));
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.GOOGLE_TV_TAG, (String)Abi.X86.toString()));
        requestedPackages.add(DetailsTypes.getSysImgPath(null, (AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.AUTOMOTIVE_TAG, (String)Abi.X86.toString()));
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(this, (Collection<String>)requestedPackages, false);
        if (dialog2 != null) {
            dialog2.show();
            this.myModel.refreshImages(true);
        }
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event2) {
        if (event2 == null || event2.getValueIsAdjusting() || this.myModel.isUpdating()) {
            return;
        }
        this.myLastSelectedImage = (SystemImageDescription)this.myTable.getSelectedObject();
        this.notifySelectionChange();
    }

    private void notifySelectionChange() {
        for (SystemImageSelectionListener listener2 : this.myListeners) {
            listener2.onSystemImageSelected(this.myLastSelectedImage);
        }
    }

    public static interface SystemImageSelectionListener {
        public void onSystemImageSelected(@Nullable SystemImageDescription var1);
    }
}

