/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemImageDescription {
    private ISystemImage mySystemImage;
    private RemotePackage myRemotePackage;
    public static final Set<IdDisplay> TAGS_WITH_GOOGLE_API = ImmutableSet.of((Object)SystemImage.GOOGLE_APIS_TAG, (Object)SystemImage.GOOGLE_APIS_X86_TAG, (Object)SystemImage.PLAY_STORE_TAG, (Object)SystemImage.ANDROID_TV_TAG, (Object)SystemImage.GOOGLE_TV_TAG, (Object)SystemImage.WEAR_TAG, (Object[])new IdDisplay[]{SystemImage.DESKTOP_TAG, SystemImage.CHROMEOS_TAG, SystemImage.AUTOMOTIVE_TAG, SystemImage.AUTOMOTIVE_PLAY_STORE_TAG});

    public SystemImageDescription(@NotNull ISystemImage systemImage) {
        this.mySystemImage = systemImage;
    }

    public SystemImageDescription(@NotNull RemotePackage remotePackage) {
        this.myRemotePackage = remotePackage;
        assert (SystemImageDescription.hasSystemImage((RepoPackage)remotePackage));
        this.mySystemImage = new RemoteSystemImage(remotePackage);
    }

    public static boolean hasSystemImage(RepoPackage p) {
        TypeDetails details = p.getTypeDetails();
        if (!(details instanceof DetailsTypes.ApiDetailsType)) {
            return false;
        }
        int apiLevel = ((DetailsTypes.ApiDetailsType)details).getApiLevel();
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            return true;
        }
        if (details instanceof DetailsTypes.PlatformDetailsType && apiLevel <= 13) {
            return true;
        }
        return details instanceof DetailsTypes.AddonDetailsType && ((DetailsTypes.AddonDetailsType)details).getVendor().getId().equals("google") && TAGS_WITH_GOOGLE_API.contains(((DetailsTypes.AddonDetailsType)details).getTag()) && apiLevel <= 19;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mySystemImage, this.myRemotePackage});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemImageDescription)) {
            return false;
        }
        SystemImageDescription other = (SystemImageDescription)obj;
        return Objects.equal((Object)this.mySystemImage, (Object)other.mySystemImage) && Objects.equal((Object)this.myRemotePackage, (Object)other.myRemotePackage);
    }

    public boolean downloadedFrom(@NotNull SystemImageDescription other) {
        if (other.getRemotePackage() == null || this.myRemotePackage != null) {
            return false;
        }
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getVendor(), (Object)other.getVendor()) && Objects.equal((Object)this.getAbiType(), (Object)other.getAbiType()) && Objects.equal((Object)this.getTag(), (Object)other.getTag());
    }

    @NotNull
    public AndroidVersion getVersion() {
        return this.mySystemImage.getAndroidVersion();
    }

    @Nullable
    public RepoPackage getRemotePackage() {
        return this.myRemotePackage;
    }

    public boolean isRemote() {
        return this.myRemotePackage != null;
    }

    public boolean obsolete() {
        return this.mySystemImage.obsolete();
    }

    @NotNull
    public String getAbiType() {
        return this.mySystemImage.getAbiType();
    }

    @NotNull
    public IdDisplay getTag() {
        return this.mySystemImage.getTag();
    }

    public String getName() {
        String versionString = SdkVersionInfo.getVersionString((int)this.getVersion().getFeatureLevel());
        return String.format("Android %s", versionString == null ? "API " + this.getVersion().getApiString() : versionString);
    }

    public String getVendor() {
        if (this.mySystemImage.getAddonVendor() != null) {
            return this.mySystemImage.getAddonVendor().getDisplay();
        }
        return "Android Open Source Project";
    }

    public String getVersionName() {
        return SdkVersionInfo.getVersionString((int)this.mySystemImage.getAndroidVersion().getApiLevel());
    }

    @Nullable
    Revision getRevision() {
        return this.mySystemImage.getRevision();
    }

    public Path[] getSkins() {
        return this.mySystemImage.getSkins();
    }

    public ISystemImage getSystemImage() {
        return this.mySystemImage;
    }

    private static class RemoteSystemImage
    implements ISystemImage {
        private final RemotePackage myRemotePackage;
        private final IdDisplay myTag;
        private final IdDisplay myVendor;
        private final String myAbi;
        private final AndroidVersion myAndroidVersion;

        public RemoteSystemImage(RemotePackage p) {
            this.myRemotePackage = p;
            TypeDetails details = this.myRemotePackage.getTypeDetails();
            assert (details instanceof DetailsTypes.ApiDetailsType);
            this.myAndroidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
            IdDisplay tag = null;
            IdDisplay vendor = null;
            String abi = "armeabi";
            if (details instanceof DetailsTypes.AddonDetailsType) {
                tag = ((DetailsTypes.AddonDetailsType)details).getTag();
                vendor = ((DetailsTypes.AddonDetailsType)details).getVendor();
                if (SystemImage.GOOGLE_APIS_X86_TAG.equals((Object)tag)) {
                    abi = "x86";
                }
            }
            if (details instanceof DetailsTypes.SysImgDetailsType) {
                tag = (IdDisplay)((DetailsTypes.SysImgDetailsType)details).getTags().get(0);
                vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
                abi = ((DetailsTypes.SysImgDetailsType)details).getAbi();
            }
            this.myTag = tag != null ? tag : SystemImage.DEFAULT_TAG;
            this.myVendor = vendor;
            this.myAbi = abi;
        }

        public Path getLocation() {
            assert (false) : "Can't get location for remote image";
            return Paths.get("", new String[0]);
        }

        public IdDisplay getTag() {
            return this.myTag;
        }

        public IdDisplay getAddonVendor() {
            return this.myVendor;
        }

        public String getAbiType() {
            return this.myAbi;
        }

        public Path[] getSkins() {
            return new Path[0];
        }

        public Revision getRevision() {
            return this.myRemotePackage.getVersion();
        }

        public AndroidVersion getAndroidVersion() {
            return this.myAndroidVersion;
        }

        public boolean hasPlayStore() {
            if (SystemImage.PLAY_STORE_TAG.equals((Object)this.myTag)) {
                return true;
            }
            return SystemImage.WEAR_TAG.equals((Object)this.getTag()) && this.myAndroidVersion.getApiLevel() >= 25 && !this.myRemotePackage.getPath().contains("android-wear-cn");
        }

        @NotNull
        public RepoPackage getPackage() {
            return this.myRemotePackage;
        }

        public boolean obsolete() {
            return this.myRemotePackage.obsolete();
        }

        public int compareTo(ISystemImage o) {
            if (o instanceof RemoteSystemImage) {
                return this.myRemotePackage.compareTo((Object)((RemoteSystemImage)o).myRemotePackage);
            }
            return 1;
        }

        public int hashCode() {
            return this.myRemotePackage.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteSystemImage)) {
                return false;
            }
            RemoteSystemImage other = (RemoteSystemImage)o;
            return this.myRemotePackage.equals(other.myRemotePackage);
        }
    }
}

