/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceSkinUpdaterService;
import com.android.tools.idea.avdmanager.LoadSkinsFutureCallback;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinChooser
extends ComboboxWithBrowseButton
implements ItemListener,
ItemSelectable {
    static final File LOADING_SKINS = new File("_loading_skins");
    static final File FAILED_TO_LOAD_SKINS = new File("_failed_to_load_skins");
    @NotNull
    private final Supplier<ListenableFuture<Collection<Path>>> myUpdateSkins;
    @NotNull
    private final Executor myDeviceSkinUpdaterServiceExecutor;
    @NotNull
    private final Executor myEdtExecutor;
    private List<ItemListener> myListeners = new ArrayList<ItemListener>();

    SkinChooser(@Nullable Project project, boolean includeSdkHandlerSkins) {
        this(project, SkinChooser.updateSkins(includeSdkHandlerSkins), DeviceSkinUpdaterService.getInstance().getExecutor(), (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private static Supplier<ListenableFuture<Collection<Path>>> updateSkins(boolean includeSdkHandlerSkins) {
        if (includeSdkHandlerSkins) {
            return DeviceSkinUpdaterService.getInstance()::updateSkinsIncludingSdkHandlerOnes;
        }
        return DeviceSkinUpdaterService.getInstance()::updateSkinsExcludingSdkHandlerOnes;
    }

    @VisibleForTesting
    SkinChooser(@Nullable Project project, @NotNull Supplier<ListenableFuture<Collection<Path>>> updateSkins, @NotNull Executor deviceSkinUpdaterServiceExecutor, @NotNull Executor edtExecutor) {
        this.myUpdateSkins = updateSkins;
        this.myDeviceSkinUpdaterServiceExecutor = deviceSkinUpdaterServiceExecutor;
        this.myEdtExecutor = edtExecutor;
        this.getComboBox().setRenderer((ListCellRenderer<File>)new ColoredListCellRenderer<File>(){

            protected void customizeCellRenderer(@NotNull JList<? extends File> list2, @Nullable File skin, int index2, boolean selected, boolean focused) {
                if (FileUtil.filesEqual((File)skin, (File)LOADING_SKINS)) {
                    this.append("Loading skins...");
                    return;
                }
                if (FileUtil.filesEqual((File)skin, (File)FAILED_TO_LOAD_SKINS)) {
                    this.append("Failed to load skins");
                    return;
                }
                if (skin == null) {
                    skin = AvdWizardUtils.NO_SKIN;
                }
                String skinPath = skin.getPath();
                if (FileUtil.filesEqual((File)skin, (File)AvdWizardUtils.NO_SKIN)) {
                    this.append("No Skin");
                } else if (skinPath.contains("/sdk/platforms/")) {
                    this.append(skinPath.replaceAll(".*/sdk/platforms/(.*)/skins/(.*)", "$2 ($1)"));
                } else if (skinPath.contains("/sdk/system-images/")) {
                    this.append(skinPath.replaceAll(".*/sdk/system-images/(.*)/(.*)/(.*)/skins/(.*)", "$4 ($1 $3)"));
                } else {
                    this.append(skin.getName());
                }
            }
        });
        FileChooserDescriptor skinChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.addBrowseFolderListener("Select Custom Skin", "Select the directory containing your custom skin definition", project, skinChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component2) {
                return ((File)component2.getSelectedItem()).getPath();
            }

            public void setText(JComboBox component2, @NotNull String text2) {
                final File skin = new File(text2);
                LoadSkinsFutureCallback callback2 = new LoadSkinsFutureCallback(SkinChooser.this, skin){

                    @Override
                    public void onSuccess(@NotNull List<File> skins) {
                        if (!skins.contains(skin)) {
                            skins.add(skin);
                        }
                        super.onSuccess(skins);
                        SkinChooser.this.setEnabled(true);
                    }
                };
                Futures.addCallback(SkinChooser.this.loadSkins(), (FutureCallback)callback2, (Executor)EdtExecutorService.getInstance());
            }
        });
        this.getComboBox().addItemListener(this);
        this.setTextFieldPreferredWidth(20);
    }

    @NotNull
    ListenableFuture<List<File>> loadSkins() {
        this.setEnabled(false);
        this.setItems(Collections.singletonList(LOADING_SKINS));
        return Futures.transform(this.myUpdateSkins.get(), SkinChooser::transform, (Executor)this.myDeviceSkinUpdaterServiceExecutor);
    }

    @NotNull
    private static List<File> transform(@NotNull Collection<Path> paths) {
        ArrayList<File> transformed = new ArrayList<File>(1 + paths.size());
        transformed.add(Paths.get("_no_skin", new String[0]).toFile());
        paths.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).distinct().sorted().map(Path::toFile).forEach(transformed::add);
        return transformed;
    }

    @VisibleForTesting
    final Object getItems() {
        JComboBox<File> comboBox2 = this.getComboBox();
        return IntStream.range(0, comboBox2.getItemCount()).mapToObj(comboBox2::getItemAt).collect(Collectors.toList());
    }

    private void setItems(List<File> items2) {
        this.getComboBox().setModel((ComboBoxModel<File>)new CollectionComboBoxModel(items2));
    }

    public final JComboBox<File> getComboBox() {
        return super.getComboBox();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemEvent newEvent = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
        for (ItemListener listener2 : this.myListeners) {
            listener2.itemStateChanged(newEvent);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getComboBox().getSelectedObjects();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.getComboBox().addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.getComboBox().removeItemListener(l);
    }
}

