/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

final class NameComparator
implements Comparator<Device> {
    @NotNull
    private static final Comparator<String> COMPARATOR = Comparator.comparing(SortKey::valueOfDeviceName).thenComparing(Comparator.naturalOrder());

    NameComparator() {
    }

    @Override
    public int compare(@NotNull Device device1, @NotNull Device device2) {
        String name1 = device1.getDisplayName();
        assert (!name1.isEmpty());
        String name2 = device2.getDisplayName();
        assert (!name2.isEmpty());
        return COMPARATOR.compare(name1, name2);
    }

    private static enum SortKey {
        FIRST_CHAR_ISNT_LETTER,
        FIRST_CHAR_IS_LETTER,
        MEDIUM_TABLET,
        MEDIUM_PHONE,
        SMALL_PHONE;


        @NotNull
        private static SortKey valueOfDeviceName(@NotNull String deviceName) {
            return switch (deviceName) {
                case "Medium Tablet" -> MEDIUM_TABLET;
                case "Medium Phone" -> MEDIUM_PHONE;
                case "Small Phone" -> SMALL_PHONE;
                default -> Character.isLetter(deviceName.charAt(0)) ? FIRST_CHAR_IS_LETTER : FIRST_CHAR_ISNT_LETTER;
            };
        }
    }
}

