/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler;", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "", "avdInfo", "Lcom/android/sdklib/internal/avd/AvdInfo;", "(Ljava/lang/Process;Ljava/lang/String;Lcom/android/sdklib/internal/avd/AvdInfo;)V", "defaultMessagePattern", "Lkotlin/text/Regex;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "verboseMessagePattern", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "ConsoleListener", "intellij.android.core"})
public final class EmulatorProcessHandler
extends BaseOSProcessHandler {
    @NotNull
    private final Logger log;
    @NotNull
    private final Regex defaultMessagePattern;
    @NotNull
    private final Regex verboseMessagePattern;

    public EmulatorProcessHandler(@NotNull Process process2, @NotNull String commandLine, @NotNull AvdInfo avdInfo) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        super(process2, commandLine, null);
        Logger logger2 = Logger.getInstance((String)("Emulator: " + avdInfo.getDisplayName()));
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"Emulator: \" + avdInfo.displayName)");
        this.log = logger2;
        this.defaultMessagePattern = new Regex("^(?<severity>VERBOSE|DEBUG|INFO|WARNING|ERROR|FATAL|UNKNOWN)\\s+\\| (?<message>.*)");
        this.verboseMessagePattern = new Regex("^(?<timestamp>\\d+:\\d+:\\d+\\.\\d+) (?<thread>\\d+)\\s+(?<severity>VERBOSE|DEBUG|INFO|WARNING|ERROR|FATAL|UNKNOWN)\\s+(?<location>[\\w-]+\\.[A-Za-z]+:\\d+)\\s+\\| (?<message>.*)");
        this.addProcessListener((ProcessListener)new ConsoleListener());
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)this));
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options2 = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"forMostlySilentProcess()");
        return options2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler$ConsoleListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "(Lcom/android/tools/idea/avdmanager/EmulatorProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "parseAndLogMessage", "text", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nEmulatorProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorProcessHandler.kt\ncom/android/tools/idea/avdmanager/EmulatorProcessHandler$ConsoleListener\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,125:1\n107#2:126\n79#2,22:127\n*S KotlinDebug\n*F\n+ 1 EmulatorProcessHandler.kt\ncom/android/tools/idea/avdmanager/EmulatorProcessHandler$ConsoleListener\n*L\n81#1:126\n81#1:127,22\n*E\n"})
    private final class ConsoleListener
    extends ProcessAdapter {
        public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key<?> outputType) {
            Integer exitCode2;
            String text2;
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String string = event2.getText();
            if (string != null) {
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                v2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else {
                v2 = text2 = null;
            }
            if (text2 != null) {
                this.parseAndLogMessage(text2);
            }
            if (Intrinsics.areEqual((Object)ProcessOutputType.SYSTEM, outputType) && EmulatorProcessHandler.this.isProcessTerminated() && (exitCode2 = EmulatorProcessHandler.this.getExitCode()) != null && exitCode2 != 0) {
                EmulatorProcessHandler.this.log.error("Emulator terminated with exit code " + exitCode2);
            }
        }

        private final void parseAndLogMessage(String text2) {
            String severity = null;
            Object message2 = null;
            MatchResult matchResult = EmulatorProcessHandler.this.defaultMessagePattern.matchEntire((CharSequence)text2);
            MatchNamedGroupCollection groups = (MatchNamedGroupCollection)(matchResult != null ? matchResult.getGroups() : null);
            if (groups != null) {
                MatchGroup matchGroup = groups.get("severity");
                Intrinsics.checkNotNull((Object)matchGroup);
                severity = matchGroup.getValue();
                MatchGroup matchGroup2 = groups.get("message");
                Intrinsics.checkNotNull((Object)matchGroup2);
                message2 = matchGroup2.getValue();
            } else {
                MatchResult matchResult2 = EmulatorProcessHandler.this.verboseMessagePattern.matchEntire((CharSequence)text2);
                groups = (MatchNamedGroupCollection)(matchResult2 != null ? matchResult2.getGroups() : null);
                if (groups != null) {
                    MatchGroup matchGroup = groups.get("severity");
                    Intrinsics.checkNotNull((Object)matchGroup);
                    severity = matchGroup.getValue();
                    MatchGroup matchGroup3 = groups.get("timestamp");
                    Intrinsics.checkNotNull((Object)matchGroup3);
                    String string = matchGroup3.getValue();
                    MatchGroup matchGroup4 = groups.get("thread");
                    Intrinsics.checkNotNull((Object)matchGroup4);
                    String string2 = matchGroup4.getValue();
                    MatchGroup matchGroup5 = groups.get("location");
                    Intrinsics.checkNotNull((Object)matchGroup5);
                    String string3 = matchGroup5.getValue();
                    MatchGroup matchGroup6 = groups.get("message");
                    Intrinsics.checkNotNull((Object)matchGroup6);
                    message2 = string + " " + string2 + " " + string3 + " " + matchGroup6.getValue();
                } else {
                    severity = "INFO";
                    message2 = text2;
                }
            }
            switch (severity) {
                case "VERBOSE": {
                    EmulatorProcessHandler.this.log.trace((String)message2);
                    break;
                }
                case "DEBUG": {
                    EmulatorProcessHandler.this.log.debug((String)message2);
                    break;
                }
                case "WARNING": {
                    EmulatorProcessHandler.this.log.warn((String)message2);
                    break;
                }
                case "ERROR": 
                case "FATAL": {
                    EmulatorProcessHandler.this.log.error((String)message2, null);
                    break;
                }
                default: {
                    EmulatorProcessHandler.this.log.info((String)message2);
                }
            }
        }
    }
}

