/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ElevatedCommandLine
extends GeneralCommandLine {
    private static final int SEE_MASK_NO_CLOSE_PROCESS = 64;
    private static final int INFINITE = -1;
    private String myTempFilePrefix = "temp";

    public ElevatedCommandLine(String ... command) {
        super(command);
    }

    public ElevatedCommandLine withTempFilePrefix(@NotNull String tempFilePrefix) {
        this.myTempFilePrefix = tempFilePrefix;
        return this;
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (SystemInfo.isWindows) {
            return this.executeAsShellCommand();
        }
        return super.startProcess(commands);
    }

    private Process executeAsShellCommand() throws IOException {
        String exeName = new File(this.getExePath()).getName();
        File wrapper = FileUtil.createTempFile((String)(FileUtil.getNameWithoutExtension((String)exeName) + "_wrapper"), (String)".bat", (boolean)true);
        String exePath = new File(this.getExePath()).getParent();
        FileUtil.writeToFile((File)wrapper, (String)String.format("@echo off\nsetlocal enableextensions\n\ncd /d \"%1$s\"\n\n%2$s %%*", exePath, exeName));
        this.setExePath(wrapper.getPath());
        File outFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_out"), (String)".txt", (boolean)true);
        File errFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_err"), (String)".txt", (boolean)true);
        this.addParameters(new String[]{">", outFile.getPath(), "2>", errFile.getPath()});
        ShellAPI.SHELLEXECUTEINFO info2 = new ShellAPI.SHELLEXECUTEINFO();
        info2.cbSize = info2.size();
        info2.lpFile = this.getExePath();
        info2.lpVerb = "runas";
        info2.lpParameters = this.getParametersList().getParametersString();
        info2.lpDirectory = this.getWorkDirectory().getPath();
        info2.nShow = 0;
        info2.fMask = 64;
        boolean returnValue = Shell32.INSTANCE.ShellExecuteEx(info2);
        int errorCode = returnValue ? 0 : Kernel32.INSTANCE.GetLastError();
        return new ProcessWrapper(info2.hProcess, errorCode, outFile, errFile);
    }

    private static class ProcessWrapper
    extends Process {
        private WinNT.HANDLE myProcess;
        private final IntByReference myExitCode;
        private final File myOutFile;
        private final File myErrFile;

        private ProcessWrapper(@NotNull WinNT.HANDLE hProcess, int errorCode, @NotNull File outFile, @NotNull File errFile) {
            this.myProcess = hProcess;
            this.myExitCode = new IntByReference(errorCode);
            this.myOutFile = outFile;
            this.myErrFile = errFile;
        }

        @Override
        public OutputStream getOutputStream() {
            throw new RuntimeException("Unexpected behaviour");
        }

        @Override
        public InputStream getInputStream() {
            return this.toInputStream(this.myOutFile);
        }

        @Override
        public InputStream getErrorStream() {
            return this.toInputStream(this.myErrFile);
        }

        @Override
        public int waitFor() {
            if (this.myProcess != null) {
                Kernel32.INSTANCE.WaitForSingleObject(this.myProcess, -1);
                Kernel32.INSTANCE.GetExitCodeProcess(this.myProcess, this.myExitCode);
                Kernel32.INSTANCE.CloseHandle(this.myProcess);
                this.myProcess = null;
            }
            return this.myExitCode.getValue();
        }

        @Override
        public int exitValue() {
            return this.waitFor();
        }

        @Override
        public void destroy() {
            this.waitFor();
        }

        private InputStream toInputStream(@NotNull File file2) {
            try {
                this.waitFor();
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

