/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Service
public final class DeviceSkinUpdaterService {
    @NotNull
    private final ListeningExecutorService myExecutorService;

    private DeviceSkinUpdaterService() {
        ExecutorService delegate2 = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"DeviceSkinUpdaterService", (int)1);
        this.myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)delegate2);
    }

    @NotNull
    public static DeviceSkinUpdaterService getInstance() {
        return (DeviceSkinUpdaterService)ApplicationManager.getApplication().getService(DeviceSkinUpdaterService.class);
    }

    @NotNull
    Executor getExecutor() {
        return this.myExecutorService;
    }

    @AnyThread
    @NotNull
    ListenableFuture<Path> updateSkins(@NotNull Path device2) {
        return this.updateSkins(device2, null);
    }

    @AnyThread
    @NotNull
    public ListenableFuture<Path> updateSkins(@NotNull Path device2, SystemImageDescription image) {
        return this.myExecutorService.submit(() -> DeviceSkinUpdater.updateSkins(device2, image));
    }

    @AnyThread
    @NotNull
    ListenableFuture<Collection<Path>> updateSkinsIncludingSdkHandlerOnes() {
        return this.myExecutorService.submit(() -> DeviceSkinUpdaterService.updateSkins(DeviceSkinUpdater::updateSkins));
    }

    @AnyThread
    @NotNull
    ListenableFuture<Collection<Path>> updateSkinsExcludingSdkHandlerOnes() {
        return this.myExecutorService.submit(() -> DeviceSkinUpdaterService.updateSkins(Path::getFileName));
    }

    @WorkerThread
    @NotNull
    private static Collection<Path> updateSkins(@NotNull Function<Path, Path> updateSkins) {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator indicator = new StudioLoggerProgressIndicator(DeviceSkinUpdaterService.class);
        Stream stream = Streams.concat((Stream[])new Stream[]{DeviceSkinUpdaterService.deviceSkinStream(), DeviceSkinUpdaterService.targetSkinStream(handler2, (ProgressIndicator)indicator, updateSkins), DeviceSkinUpdaterService.imageSkinStream(handler2, (ProgressIndicator)indicator, updateSkins)});
        return stream.collect(Collectors.toList());
    }

    @WorkerThread
    @NotNull
    private static Stream<Path> deviceSkinStream() {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices().stream().map(Device::getDefaultHardware).map(Hardware::getSkinFile).filter(Objects::nonNull).map(File::toPath).map(DeviceSkinUpdater::updateSkins);
    }

    @WorkerThread
    @NotNull
    private static Stream<Path> targetSkinStream(@NotNull AndroidSdkHandler handler2, @NotNull ProgressIndicator indicator, @NotNull Function<Path, Path> updateSkins) {
        return handler2.getAndroidTargetManager(indicator).getTargets(indicator).stream().map(IAndroidTarget::getSkins).flatMap(Arrays::stream).filter(Objects::nonNull).map(updateSkins);
    }

    @WorkerThread
    @NotNull
    private static Stream<Path> imageSkinStream(@NotNull AndroidSdkHandler handler2, @NotNull ProgressIndicator indicator, @NotNull Function<Path, Path> updateSkins) {
        return handler2.getSystemImageManager(indicator).getImages().stream().map(SystemImage::getSkins).flatMap(Arrays::stream).filter(Objects::nonNull).map(updateSkins);
    }
}

