/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.Slow;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.MoreFiles;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeviceSkinUpdater {
    @NotNull
    private final Path myStudioSkins;
    @NotNull
    private final Path mySdkSkins;
    private final boolean myEmulatorSupportsWebP;
    @NotNull
    private final Converter myConverter;

    @VisibleForTesting
    DeviceSkinUpdater(@NotNull Path studioSkins, @NotNull Path sdkSkins, boolean emulatorSupportsWebP, @NotNull Converter converter) {
        this.myStudioSkins = studioSkins;
        this.mySdkSkins = sdkSkins;
        this.myEmulatorSupportsWebP = emulatorSupportsWebP;
        this.myConverter = converter;
    }

    @Slow
    @NotNull
    static Path updateSkins(@NotNull Path device2) {
        return DeviceSkinUpdater.updateSkins(device2, null);
    }

    @Slow
    @NotNull
    static Path updateSkins(@NotNull Path device2, @Nullable SystemImageDescription image) {
        List<Path> imageSkins = image == null ? Collections.emptyList() : Arrays.asList(image.getSkins());
        File studioSkins = DeviceArtDescriptor.getBundledDescriptorsFolder();
        AndroidSdkHandler sdk = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return DeviceSkinUpdater.updateSkins(device2, imageSkins, studioSkins == null ? null : device2.resolve(studioSkins.getPath()), sdk.getLocation() == null ? null : sdk.getLocation().resolve("skins"), AvdWizardUtils.emulatorSupportsWebp(sdk));
    }

    @VisibleForTesting
    @NotNull
    static Path updateSkins(@NotNull Path device2, @NotNull Collection<Path> imageSkins, @Nullable Path studioSkins, @Nullable Path sdkSkins, boolean emulatorSupportsWebP) {
        if (device2.toString().isEmpty() || device2.isAbsolute() || device2.equals(device2.getFileSystem().getPath("_no_skin", new String[0]))) {
            return device2;
        }
        Optional<Path> optionalImageSkin = imageSkins.stream().filter(skin -> skin.endsWith(device2)).findFirst();
        if (optionalImageSkin.isPresent()) {
            return optionalImageSkin.get();
        }
        if (studioSkins == null && sdkSkins == null) {
            return device2;
        }
        if (studioSkins == null) {
            return sdkSkins.resolve(device2);
        }
        if (sdkSkins == null) {
            return studioSkins.resolve(device2);
        }
        return new DeviceSkinUpdater(studioSkins, sdkSkins, emulatorSupportsWebP, new Converter()).updateSkinsImpl(device2);
    }

    @VisibleForTesting
    @NotNull
    Path updateSkinsImpl(@NotNull Path device2) {
        assert (!(device2.toString().isEmpty() || device2.isAbsolute() || device2.equals(device2.getFileSystem().getPath("_no_skin", new String[0])))) : device2;
        Path sdkDeviceSkins = this.mySdkSkins.resolve(device2);
        Path studioDeviceSkins = this.getStudioDeviceSkins(device2);
        try {
            if (DeviceSkinUpdater.areSdkDeviceSkinsUpToDate(sdkDeviceSkins, studioDeviceSkins)) {
                return sdkDeviceSkins;
            }
            Files.createDirectories(sdkDeviceSkins, new FileAttribute[0]);
            if (this.myEmulatorSupportsWebP) {
                DeviceSkinUpdater.copyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
            } else {
                this.convertAndCopyStudioDeviceSkins(studioDeviceSkins, sdkDeviceSkins);
            }
            return sdkDeviceSkins;
        }
        catch (IOException exception) {
            Logger.getInstance(DeviceSkinUpdater.class).warn((Throwable)exception);
            return studioDeviceSkins;
        }
    }

    @NotNull
    private Path getStudioDeviceSkins(@NotNull Path device2) {
        if (device2.equals(device2.getFileSystem().getPath("WearLargeRound", new String[0]))) {
            return this.myStudioSkins.resolve("wearos_large_round");
        }
        if (device2.equals(device2.getFileSystem().getPath("WearSmallRound", new String[0]))) {
            return this.myStudioSkins.resolve("wearos_small_round");
        }
        if (device2.equals(device2.getFileSystem().getPath("WearSquare", new String[0]))) {
            return this.myStudioSkins.resolve("wearos_square");
        }
        if (device2.equals(device2.getFileSystem().getPath("WearRect", new String[0]))) {
            return this.myStudioSkins.resolve("wearos_rect");
        }
        return this.myStudioSkins.resolve(device2);
    }

    private static boolean areSdkDeviceSkinsUpToDate(@NotNull Path sdkDeviceSkins, @NotNull Path studioDeviceSkins) throws IOException {
        if (Files.notExists(sdkDeviceSkins, new LinkOption[0])) {
            return false;
        }
        Path studioLayout = studioDeviceSkins.resolve("layout");
        if (Files.notExists(studioLayout, new LinkOption[0])) {
            return true;
        }
        Path sdkLayout = sdkDeviceSkins.resolve("layout");
        if (Files.notExists(sdkLayout, new LinkOption[0])) {
            return false;
        }
        if (Files.getLastModifiedTime(studioLayout, new LinkOption[0]).compareTo(Files.getLastModifiedTime(sdkLayout, new LinkOption[0])) < 0) {
            return true;
        }
        PathUtils.deleteRecursivelyIfExists((Path)sdkDeviceSkins);
        return false;
    }

    private static void copyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        for (Path path2 : DeviceSkinUpdater.list(studioDeviceSkins)) {
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(path2.getFileName()));
        }
    }

    private void convertAndCopyStudioDeviceSkins(@NotNull Path studioDeviceSkins, @NotNull Path sdkDeviceSkins) throws IOException {
        Collection<Path> paths = DeviceSkinUpdater.list(studioDeviceSkins);
        Path layout = null;
        int size = paths.size();
        ArrayList<String> namesToReplace = new ArrayList<String>(size);
        ArrayList<String> namesToReplaceThemWith = new ArrayList<String>(size);
        for (Path path2 : paths) {
            Path pngImage;
            String name2 = path2.getFileName().toString();
            if (name2.equals("layout")) {
                layout = path2;
                continue;
            }
            if (name2.endsWith(".webp") && this.myConverter.convert(path2, pngImage = sdkDeviceSkins.resolve(MoreFiles.getNameWithoutExtension((Path)path2.getFileName()) + ".png"))) {
                namesToReplace.add(name2);
                namesToReplaceThemWith.add(pngImage.getFileName().toString());
                continue;
            }
            DeviceSkinUpdater.copy(path2, sdkDeviceSkins.resolve(name2));
        }
        if (layout == null) {
            return;
        }
        DeviceSkinUpdater.replaceAll(layout, namesToReplace, namesToReplaceThemWith, sdkDeviceSkins.resolve(layout.getFileName()));
    }

    private static void replaceAll(@NotNull Path source, @NotNull List<String> stringsToReplace, @NotNull List<String> stringsToReplaceThemWith, @NotNull Path target2) throws IOException {
        String sourceString = new String(Files.readAllBytes(source), StandardCharsets.UTF_8);
        String targetString = StringUtil.replace((String)sourceString, stringsToReplace, stringsToReplaceThemWith);
        Files.write(target2, targetString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    @NotNull
    static Collection<Path> list(@NotNull Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            Collection collection2 = stream.sorted().collect(Collectors.toList());
            return collection2;
        }
    }

    @VisibleForTesting
    static void copy(@NotNull Path source, @NotNull Path target2) throws IOException {
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            return;
        }
        if (Files.exists(target2, new LinkOption[0])) {
            return;
        }
        FileUtils.copyFile((Path)source, (Path)target2);
    }

    @VisibleForTesting
    static class Converter {
        Converter() {
        }

        @VisibleForTesting
        boolean convert(@NotNull Path webPImage, @NotNull Path pngImage) throws IOException {
            BufferedImage image;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(webPImage, new OpenOption[0]));){
                image = ImageIO.read(in);
            }
            if (image == null) {
                return false;
            }
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(pngImage, new OpenOption[0]));){
                ImageIO.write((RenderedImage)image, "PNG", out);
                boolean bl = true;
                return bl;
            }
        }
    }
}

