/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.DeviceParser;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.DeviceManagers;
import com.android.utils.ILogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG).alwaysLogAsDebug(true).allowVerbose(false);
    private static final DeviceManagerConnection NULL_CONNECTION = new DeviceManagerConnection(null);
    private static Map<Path, DeviceManagerConnection> ourCache = new WeakHashMap<Path, DeviceManagerConnection>();
    private DeviceManager ourDeviceManager;
    @Nullable
    private Path mySdkPath;

    public DeviceManagerConnection(@Nullable Path sdkPath) {
        this.mySdkPath = sdkPath;
    }

    @NotNull
    public static DeviceManagerConnection getDeviceManagerConnection(@NotNull Path sdkPath) {
        if (!ourCache.containsKey(sdkPath)) {
            ourCache.put(sdkPath, new DeviceManagerConnection(sdkPath));
        }
        return ourCache.get(sdkPath);
    }

    @NotNull
    public static DeviceManagerConnection getDefaultDeviceManagerConnection() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Path sdkPath = handler2.getLocation();
        if (sdkPath != null) {
            return DeviceManagerConnection.getDeviceManagerConnection(sdkPath);
        }
        return NULL_CONNECTION;
    }

    private boolean initIfNecessary() {
        if (this.ourDeviceManager == null) {
            if (this.mySdkPath == null) {
                IJ_LOG.error("No installed SDK found!");
                return false;
            }
            this.ourDeviceManager = DeviceManagers.getDeviceManager(AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)this.mySdkPath));
        }
        return true;
    }

    @NotNull
    public List<Device> getDevices() {
        if (!this.initIfNecessary()) {
            return ImmutableList.of();
        }
        return Lists.newArrayList((Iterable)this.ourDeviceManager.getDevices(DeviceManager.ALL_DEVICES));
    }

    @Nullable
    public Device getDevice(@NotNull String id2, @NotNull String manufacturer) {
        if (!this.initIfNecessary()) {
            return null;
        }
        return this.ourDeviceManager.getDevice(id2, manufacturer);
    }

    @NotNull
    public String getUniqueId(@Nullable String id2) {
        String baseId;
        String string = baseId = id2 == null ? "New Device" : id2;
        if (!this.initIfNecessary()) {
            return baseId;
        }
        Collection devices2 = this.ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER);
        String candidate = baseId;
        int i = 0;
        while (DeviceManagerConnection.anyIdMatches(candidate, devices2)) {
            candidate = String.format(Locale.getDefault(), "%s %d", baseId, ++i);
        }
        return candidate;
    }

    private static boolean anyIdMatches(@NotNull String id2, @NotNull Collection<Device> devices2) {
        for (Device d : devices2) {
            if (!id2.equalsIgnoreCase(d.getId())) continue;
            return true;
        }
        return false;
    }

    public void deleteDevice(@Nullable Device info2) {
        if (info2 != null) {
            if (!this.initIfNecessary()) {
                return;
            }
            this.ourDeviceManager.removeUserDevice(info2);
            this.ourDeviceManager.saveUserDevices();
        }
    }

    public void createOrEditDevice(@NotNull Device device2) {
        if (!this.initIfNecessary()) {
            return;
        }
        this.ourDeviceManager.replaceUserDevice(device2);
        this.ourDeviceManager.saveUserDevices();
    }

    public void createDevices(@NotNull List<Device> devices2) {
        if (!this.initIfNecessary()) {
            return;
        }
        for (Device device2 : devices2) {
            String deviceIdBase = device2.getId();
            String deviceNameBase = device2.getDisplayName();
            int i = 2;
            while (this.isUserDevice(device2)) {
                String id2 = String.format(Locale.getDefault(), "%1$s_%2$d", deviceIdBase, i);
                String name2 = String.format(Locale.getDefault(), "%1$s_%2$d", deviceNameBase, i);
                device2 = DeviceManagerConnection.cloneDeviceWithNewIdAndName(device2, id2, name2);
            }
            this.ourDeviceManager.addUserDevice(device2);
        }
        this.ourDeviceManager.saveUserDevices();
    }

    private static Device cloneDeviceWithNewIdAndName(@NotNull Device device2, @NotNull String id2, @NotNull String name2) {
        Device.Builder builder2 = new Device.Builder(device2);
        builder2.setId(id2);
        builder2.setName(name2);
        return builder2.build();
    }

    public boolean isUserDevice(final @NotNull Device device2) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return Iterables.any((Iterable)this.ourDeviceManager.getDevices(DeviceManager.DeviceFilter.USER), (Predicate)new Predicate<Device>(){

            public boolean apply(Device input2) {
                return device2.getId().equalsIgnoreCase(input2.getId());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Device> getDevicesFromFile(@NotNull File xmlFile) {
        FileInputStream stream = null;
        ArrayList<Device> list2 = new ArrayList<Device>();
        try {
            stream = new FileInputStream(xmlFile);
            list2.addAll(DeviceParser.parse((InputStream)stream).values());
        }
        catch (IllegalStateException e) {
            IJ_LOG.error((Throwable)e);
        }
        catch (Exception e) {
            IJ_LOG.error("Error reading devices", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return list2;
    }

    /*
     * Exception decompiling
     */
    public static void writeDevicesToFile(@NotNull List<Device> devices, @NotNull File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

