/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CustomSkinDefinitionResolver {
    @Nullable
    private final Path myCustomSkinDefinition;
    @Nullable
    private final Path myCustomSkinDefinitionBackup;

    CustomSkinDefinitionResolver(@NotNull FileSystem fileSystem, boolean deviceFrameEnabled, @Nullable Path customSkinDefinition, @Nullable Path customSkinDefinitionBackup) {
        if (deviceFrameEnabled) {
            if (customSkinDefinitionBackup == null) {
                this.myCustomSkinDefinition = customSkinDefinition;
                this.myCustomSkinDefinitionBackup = null;
                return;
            }
            this.myCustomSkinDefinition = customSkinDefinitionBackup;
            this.myCustomSkinDefinitionBackup = null;
            return;
        }
        if (customSkinDefinitionBackup == null) {
            this.myCustomSkinDefinition = fileSystem.getPath("_no_skin", new String[0]);
            this.myCustomSkinDefinitionBackup = customSkinDefinition;
            return;
        }
        this.myCustomSkinDefinition = customSkinDefinition;
        this.myCustomSkinDefinitionBackup = customSkinDefinitionBackup;
    }

    @NotNull
    Optional<Path> getCustomSkinDefinition() {
        return Optional.ofNullable(this.myCustomSkinDefinition);
    }

    @NotNull
    Optional<Path> getCustomSkinDefinitionBackup() {
        return Optional.ofNullable(this.myCustomSkinDefinitionBackup);
    }
}

