/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtils {
    private static final Color SUCCESS_COLOR = new JBColor(32768, 6981465);
    private static final Color FAILURE_COLOR = new JBColor(0x660000, 13187912);
    private static final Color CODE_COLOR = new JBColor(35195, 8440772);
    private static final Color SECONDARY_COLOR = new JBColor(0x757575, 0xBDBDBD);
    private static final Color OFFSITE_LINK_COLOR = JBUI.CurrentTheme.Link.Foreground.ENABLED;
    private static final Color BACKGROUND_COLOR = JBUI.CurrentTheme.ToolWindow.background();
    private static final Color BACKGROUND_HOVER_COLOR = new JBColor(-1513240, 0);
    private static final Color CURRENT_BG_COLOR = new JPanel().getBackground();
    private static final Color AS_STANDARD_BACKGROUND_COLOR = new JBColor(UIUtil.isUnderDarcula() ? -1513240 : CURRENT_BG_COLOR.getRGB(), -12763327);

    public static Color getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    public static Color getBackgroundHoverColor() {
        return BACKGROUND_HOVER_COLOR;
    }

    public static Color getSeparatorColor() {
        return UIUtil.CONTRAST_BORDER_COLOR;
    }

    public static Color getSuccessColor() {
        return SUCCESS_COLOR;
    }

    public static Color getFailureColor() {
        return FAILURE_COLOR;
    }

    public static Color getSecondaryColor() {
        return SECONDARY_COLOR;
    }

    public static Color getAsStandardBackgroundColor() {
        return AS_STANDARD_BACKGROUND_COLOR;
    }

    public static String getCssColor(Color color) {
        return "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public static GridBagConstraints getVerticalGlueConstraints(int gridy) {
        return UIUtils.getVerticalGlueConstraints(gridy, 1);
    }

    public static GridBagConstraints getVerticalGlueConstraints(int gridy, int gridwidth) {
        GridBagConstraints glueConstraints = new GridBagConstraints();
        glueConstraints.gridx = 0;
        glueConstraints.gridy = gridy;
        glueConstraints.gridwidth = gridwidth;
        glueConstraints.gridheight = 1;
        glueConstraints.weightx = 0.0;
        glueConstraints.weighty = 1.0;
        glueConstraints.anchor = 11;
        glueConstraints.fill = 1;
        glueConstraints.insets = new Insets(0, 0, 0, 0);
        glueConstraints.ipadx = 0;
        glueConstraints.ipady = 0;
        return glueConstraints;
    }

    public static void setHtml(JEditorPane pane, String content2) {
        UIUtils.setHtml(pane, content2, null, null);
    }

    public static void setHtml(JEditorPane pane, String content2, String css) {
        UIUtils.setHtml(pane, content2, css, null);
    }

    public static void setHtml(JEditorPane pane, String content2, String css, String headContent) {
        pane.setEditorKit(HTMLEditorKitBuilder.simple());
        pane.setEditable(false);
        pane.setMargin(new Insets(0, 0, 0, 0));
        pane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        pane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        pane.setText(UIUtils.getHtml(content2, "a, a:visited, a:active { color: " + UIUtils.getCssColor(OFFSITE_LINK_COLOR) + "; }" + css, headContent));
    }

    public static String getHtml(@NotNull String content2) {
        return UIUtils.getHtml(content2, null, null);
    }

    public static String getHtml(@NotNull String content2, @Nullable String css) {
        return UIUtils.getHtml(content2, css, null);
    }

    public static String getHtml(@NotNull String content2, @Nullable String css, @Nullable String headContent) {
        Font defaultFont = new JBLabel().getFont();
        String text2 = "<html><head><style>body { font-family: " + defaultFont.getFamily() + "; margin: 0px; } ol {margin: 0 0 0 20px; } ul {list-style-type: circle; margin: 0 0 0 20px; } li {margin: 0 0 10px 10px; } code { font-family: 'Roboto Mono', 'Courier New', monospace; color: " + UIUtils.getCssColor(CODE_COLOR) + "; font-size: 1em; }.as-shim { margin: 0 0 0 0; }";
        if (css != null) {
            text2 = text2 + "\n" + css;
        }
        text2 = text2 + "</style>";
        if (headContent != null) {
            text2 = text2 + "\n" + headContent;
        }
        text2 = text2 + "</head><body><div class=\"as-shim\">" + content2 + "</div></body></html>";
        return text2;
    }

    @Nullable
    public static String addLocalHTMLPaths(@NotNull Class<?> resourceClass, @Nullable String html) {
        URL url;
        String localImage;
        if (html != null && (localImage = UIUtils.findLocalImage(html)) != null && (url = resourceClass.getResource("/" + localImage)) != null) {
            return UIUtils.addLocalHTMLPaths(html, url, localImage);
        }
        return html;
    }

    @VisibleForTesting
    @Nullable
    static String findLocalImage(@NotNull String html) {
        String image;
        String pattern = "<img src=\"/";
        int index2 = html.indexOf(pattern);
        if (index2 >= 0 && !(image = html.substring(index2 += pattern.length(), html.indexOf(34, index2))).isEmpty()) {
            return image;
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    static String addLocalHTMLPaths(@NotNull String html, @NotNull URL url, @NotNull String localImage) {
        String baseUrl = url.toExternalForm().replace(localImage, "");
        String replacementPattern = "<img src=\"" + baseUrl;
        return html.replaceAll("<img src=\"/", replacementPattern);
    }
}

