/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.details;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.ResponseHeader;
import com.android.tools.idea.appinspection.inspectors.network.view.ConnectionsStateChart;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkState;
import com.android.tools.idea.appinspection.inspectors.network.view.details.HttpDataComponentFactory;
import com.android.tools.idea.appinspection.inspectors.network.view.details.NoWrapBoldLabel;
import com.android.tools.idea.appinspection.inspectors.network.view.details.OverviewTabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabUiUtilsKt;
import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.android.tools.inspectors.common.ui.dataviewer.ImageDataViewer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.function.LongFunction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0007J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/TabContent;", "()V", "contentPanel", "Ljavax/swing/JPanel;", "title", "", "getTitle", "()Ljava/lang/String;", "createComponent", "Ljavax/swing/JComponent;", "findContentTypeValue", "Ljavax/swing/JLabel;", "findInitiatingThreadValue", "findOtherThreadsValue", "findResponsePayloadViewer", "findSizeValue", "findTimingBar", "findUrlValue", "Ljavax/swing/JTextArea;", "populateFor", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "httpDataComponentFactory", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/HttpDataComponentFactory;", "Companion", "WrappedHyperlink", "app-inspection.inspectors.network.view"})
public final class OverviewTabContent
extends TabContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JPanel contentPanel;
    @NotNull
    private final String title;
    @NotNull
    private static final LongFunction<String> TIME_FORMATTER = Companion.TIME_FORMATTER.1.INSTANCE;
    @NotNull
    private static final String ID_CONTENT_TYPE = "CONTENT_TYPE";
    @NotNull
    private static final String ID_SIZE = "SIZE";
    @NotNull
    private static final String ID_URL = "URL";
    @NotNull
    private static final String ID_TIMING = "TIMING";
    @NotNull
    private static final String ID_INITIATING_THREAD = "INITIATING_THREAD";
    @NotNull
    private static final String ID_OTHER_THREADS = "OTHER_THREADS";
    @NotNull
    private static final String ID_RESPONSE_PAYLOAD_VIEWER = "RESPONSE_PAYLOAD_VIEWER";

    public OverviewTabContent() {
        this.title = "Overview";
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        TabularLayout layout = new TabularLayout("*").setVGap(TabUiUtilsKt.getPAGE_VGAP());
        this.contentPanel = new JPanel((LayoutManager)layout);
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        jPanel.setBorder((Border)JBUI.Borders.empty((int)TabUiUtilsKt.getPAGE_VGAP(), (int)15, (int)0, (int)15));
        JPanel jPanel2 = this.contentPanel;
        if (jPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel2 = null;
        }
        JBScrollPane overviewScroll = TabUiUtilsKt.createVerticalScrollPane(jPanel2);
        overviewScroll.getVerticalScrollBar().setUnitIncrement(TabUiUtilsKt.getSCROLL_UNIT());
        overviewScroll.addComponentListener((ComponentListener)new ComponentAdapter(layout, overviewScroll, this){
            final /* synthetic */ TabularLayout $layout;
            final /* synthetic */ JBScrollPane $overviewScroll;
            final /* synthetic */ OverviewTabContent this$0;
            {
                this.$layout = $layout;
                this.$overviewScroll = $overviewScroll;
                this.this$0 = $receiver;
            }

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$layout.setRowSizing(0, new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.FIXED, (int)((float)this.$overviewScroll.getViewport().getHeight() * 0.4f)));
                JPanel jPanel = OverviewTabContent.access$getContentPanel$p(this.this$0);
                if (jPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
                    jPanel = null;
                }
                this.$layout.layoutContainer((Container)jPanel);
            }
        });
        return (JComponent)overviewScroll;
    }

    @Override
    public void populateFor(@Nullable HttpData data, @NotNull HttpDataComponentFactory httpDataComponentFactory) {
        Intrinsics.checkNotNullParameter((Object)httpDataComponentFactory, (String)"httpDataComponentFactory");
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        jPanel.removeAll();
        if (data == null) {
            return;
        }
        DataViewer payloadViewer = httpDataComponentFactory.createDataViewer(HttpDataComponentFactory.ConnectionType.RESPONSE, false);
        JComponent jComponent = payloadViewer.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"payloadViewer.component");
        JComponent responsePayloadComponent = jComponent;
        responsePayloadComponent.setName(ID_RESPONSE_PAYLOAD_VIEWER);
        JPanel jPanel2 = this.contentPanel;
        if (jPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel2 = null;
        }
        jPanel2.add((Component)responsePayloadComponent, new TabularLayout.Constraint(0, 0, 0, 4, null));
        BufferedImage image = payloadViewer instanceof ImageDataViewer ? ((ImageDataViewer)payloadViewer).getImage() : null;
        JPanel jPanel3 = this.contentPanel;
        if (jPanel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel3 = null;
        }
        jPanel3.add((Component)OverviewTabContent.Companion.createFields(data, image), new TabularLayout.Constraint(1, 0, 0, 4, null));
    }

    @VisibleForTesting
    @Nullable
    public final JComponent findResponsePayloadViewer() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_RESPONSE_PAYLOAD_VIEWER);
    }

    @VisibleForTesting
    @Nullable
    public final JLabel findContentTypeValue() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return (JLabel)TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_CONTENT_TYPE);
    }

    @VisibleForTesting
    @Nullable
    public final JLabel findSizeValue() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return (JLabel)TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_SIZE);
    }

    @VisibleForTesting
    @Nullable
    public final JTextArea findUrlValue() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return (JTextArea)TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_URL);
    }

    @VisibleForTesting
    @Nullable
    public final JComponent findTimingBar() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_TIMING);
    }

    @VisibleForTesting
    @Nullable
    public final JLabel findInitiatingThreadValue() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return (JLabel)TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_INITIATING_THREAD);
    }

    @VisibleForTesting
    @Nullable
    public final JLabel findOtherThreadsValue() {
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentPanel");
            jPanel = null;
        }
        return (JLabel)TabUiUtilsKt.findComponentWithUniqueName(jPanel, ID_OTHER_THREADS);
    }

    public static final /* synthetic */ JPanel access$getContentPanel$p(OverviewTabContent $this) {
        return $this.contentPanel;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent$Companion;", "", "()V", "ID_CONTENT_TYPE", "", "ID_INITIATING_THREAD", "ID_OTHER_THREADS", "ID_RESPONSE_PAYLOAD_VIEWER", "ID_SIZE", "ID_TIMING", "ID_URL", "TIME_FORMATTER", "Ljava/util/function/LongFunction;", "createFields", "Ljavax/swing/JComponent;", "httpData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "image", "Ljava/awt/image/BufferedImage;", "createTimingBar", "app-inspection.inspectors.network.view"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent createFields(HttpData httpData, BufferedImage image) {
            int contentLength;
            JPanel myFieldsPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,40px,*").setVGap(TabUiUtilsKt.getSECTION_VGAP()));
            int row2 = 0;
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request")), new TabularLayout.Constraint(row2, 0, 0, 4, null));
            myFieldsPanel.add((Component)new JLabel(HttpData.Companion.getUrlName(httpData.getUrl())), new TabularLayout.Constraint(row2, 2, 0, 4, null));
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Method")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
            myFieldsPanel.add((Component)new JLabel(httpData.getMethod()), new TabularLayout.Constraint(row2, 2, 0, 4, null));
            ResponseHeader responseHeader = httpData.getResponseHeader();
            if (responseHeader.getStatusCode() != -1) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Status")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
                JLabel statusCode = new JLabel(String.valueOf(responseHeader.getStatusCode()));
                myFieldsPanel.add((Component)statusCode, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            }
            if (image != null) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Dimension")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
                String string = "%d x %d";
                Object[] objectArray = new Object[]{image.getWidth(), image.getHeight()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                JLabel dimension2 = new JLabel(string2);
                myFieldsPanel.add((Component)dimension2, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            }
            if (!responseHeader.getContentType().isEmpty()) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Content type")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
                JLabel contentTypeLabel = new JLabel(responseHeader.getContentType().getMimeType());
                contentTypeLabel.setName(OverviewTabContent.ID_CONTENT_TYPE);
                myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            }
            if ((contentLength = responseHeader.getContentLength()) != -1) {
                try {
                    myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Size")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
                    JLabel contentLengthLabel = new JLabel(StringUtil.formatFileSize((long)contentLength));
                    contentLengthLabel.setName(OverviewTabContent.ID_SIZE);
                    myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row2, 2, 0, 4, null));
                }
                catch (NumberFormatException contentLengthLabel) {
                    // empty catch block
                }
            }
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Initiating thread")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
            JLabel initiatingThreadLabel = new JLabel(httpData.getJavaThreads().get(0).getName());
            initiatingThreadLabel.setName(OverviewTabContent.ID_INITIATING_THREAD);
            myFieldsPanel.add((Component)initiatingThreadLabel, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            if (httpData.getJavaThreads().size() > 1) {
                StringBuilder otherThreadsBuilder = new StringBuilder();
                int n = httpData.getJavaThreads().size();
                for (int i = 1; i < n; ++i) {
                    if (((CharSequence)otherThreadsBuilder).length() > 0) {
                        otherThreadsBuilder.append(", ");
                    }
                    otherThreadsBuilder.append(httpData.getJavaThreads().get(i).getName());
                }
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Other threads")), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
                JLabel otherThreadsLabel = new JLabel(otherThreadsBuilder.toString());
                otherThreadsLabel.setName(OverviewTabContent.ID_OTHER_THREADS);
                myFieldsPanel.add((Component)otherThreadsLabel, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            }
            NoWrapBoldLabel urlLabel = new NoWrapBoldLabel(OverviewTabContent.ID_URL);
            urlLabel.setVerticalAlignment(1);
            myFieldsPanel.add((Component)((Object)urlLabel), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
            WrappedHyperlink hyperlink2 = new WrappedHyperlink(httpData.getUrl());
            hyperlink2.setName(OverviewTabContent.ID_URL);
            myFieldsPanel.add((Component)hyperlink2, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            ++row2;
            JSeparator separator = new JSeparator();
            separator.setMinimumSize(separator.getPreferredSize());
            int gap = TabUiUtilsKt.getPAGE_VGAP() - TabUiUtilsKt.getSECTION_VGAP() - (int)separator.getPreferredSize().getHeight() / 2;
            JPanel separatorContainer = new JPanel((LayoutManager)new VerticalFlowLayout(0, gap));
            separatorContainer.add(separator);
            myFieldsPanel.add((Component)separatorContainer, new TabularLayout.Constraint(row2, 0, 1, 3));
            NoWrapBoldLabel timingLabel = new NoWrapBoldLabel("Timing");
            timingLabel.setVerticalAlignment(1);
            myFieldsPanel.add((Component)((Object)timingLabel), new TabularLayout.Constraint(++row2, 0, 0, 4, null));
            JComponent timingBar = this.createTimingBar(httpData);
            timingBar.setName(OverviewTabContent.ID_TIMING);
            myFieldsPanel.add((Component)timingBar, new TabularLayout.Constraint(row2, 2, 0, 4, null));
            return myFieldsPanel;
        }

        private final JComponent createTimingBar(HttpData httpData) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            Range range = new Range((double)httpData.getRequestStartTimeUs(), (double)(httpData.getConnectionEndTimeUs() > 0L ? httpData.getConnectionEndTimeUs() : httpData.getRequestStartTimeUs() + 1L));
            ConnectionsStateChart connectionsChart = new ConnectionsStateChart(httpData, range);
            connectionsChart.getComponent().setMinimumSize(new Dimension(0, JBUI.scale((int)28)));
            connectionsChart.setHeightGap(0.0f);
            panel2.add((Component)connectionsChart.getComponent());
            long sentTime = -1L;
            long receivedTime = -1L;
            if (httpData.getResponseStartTimeUs() > 0L) {
                sentTime = httpData.getResponseStartTimeUs() - httpData.getRequestStartTimeUs();
                receivedTime = httpData.getResponseCompleteTimeUs() - httpData.getResponseStartTimeUs();
            } else if (httpData.getConnectionEndTimeUs() > 0L) {
                sentTime = httpData.getConnectionEndTimeUs() - httpData.getRequestStartTimeUs();
                receivedTime = 0L;
            }
            FixedLegend sentLegend = new FixedLegend("Sent", (String)TIME_FORMATTER.apply(sentTime));
            FixedLegend receivedLegend = new FixedLegend("Received", (String)TIME_FORMATTER.apply(receivedTime));
            LegendComponentModel legendModel = new LegendComponentModel();
            legendModel.add((Legend)sentLegend);
            legendModel.add((Legend)receivedLegend);
            LegendComponent legendComponent = new LegendComponent.Builder(legendModel).setLeftPadding(0).setVerticalPadding(JBUI.scale((int)8)).build();
            Intrinsics.checkNotNullExpressionValue((Object)legendComponent, (String)"Builder(legendModel)\n   \u2026le(8))\n          .build()");
            LegendComponent legend = legendComponent;
            legend.configure((Legend)sentLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.SENDING)));
            legend.configure((Legend)receivedLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.RECEIVING)));
            panel2.add((Component)legend);
            return panel2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent$WrappedHyperlink;", "Ljavax/swing/JTextArea;", "url", "", "(Ljava/lang/String;)V", "getMouseAdapter", "Ljava/awt/event/MouseAdapter;", "setBackground", "", "ignored", "Ljava/awt/Color;", "setFont", "Ljava/awt/Font;", "app-inspection.inspectors.network.view"})
    private static final class WrappedHyperlink
    extends JTextArea {
        public WrappedHyperlink(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBackground(UIUtil.getLabelBackground());
            this.setForeground(PlatformColors.BLUE);
            this.setFont((Font)JBFont.label().asPlain());
            MouseAdapter mouseAdapter = this.getMouseAdapter(url);
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        @Override
        public void setBackground(@Nullable Color ignored) {
            super.setBackground(UIUtil.getLabelBackground());
        }

        @Override
        public void setFont(@Nullable Font ignored) {
            super.setFont((Font)JBFont.label().asPlain());
        }

        private final MouseAdapter getMouseAdapter(String url) {
            return new MouseAdapter(this, url){
                final /* synthetic */ WrappedHyperlink this$0;
                final /* synthetic */ String $url;
                {
                    this.this$0 = $receiver;
                    this.$url = $url;
                }

                public void mouseEntered(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.mouseMoved(e);
                }

                public void mouseExited(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }

                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.isMouseOverText(e)) {
                        BrowserUtil.browse((String)this.$url);
                    }
                }

                public void mouseMoved(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.setCursor(this.isMouseOverText(e) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }

                private final boolean isMouseOverText(MouseEvent e) {
                    return this.this$0.viewToModel2D(e.getPoint()) < this.this$0.getDocument().getLength();
                }
            };
        }
    }
}

