/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.details;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.stdui.CloseButton;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.analytics.NetworkInspectorTracker;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.model.rules.RuleData;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkInspectorView;
import com.android.tools.idea.appinspection.inspectors.network.view.details.ConnectionDetailsView;
import com.android.tools.idea.appinspection.inspectors.network.view.details.RuleDetailsView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/NetworkInspectorDetailsPanel;", "Ljavax/swing/JPanel;", "inspectorView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;", "usageTracker", "Lcom/android/tools/idea/appinspection/inspectors/network/model/analytics/NetworkInspectorTracker;", "(Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;Lcom/android/tools/idea/appinspection/inspectors/network/model/analytics/NetworkInspectorTracker;)V", "aspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "cardLayout", "Ljava/awt/CardLayout;", "cardLayoutView", "connectionDetailsView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/ConnectionDetailsView;", "getConnectionDetailsView$annotations", "()V", "getConnectionDetailsView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/details/ConnectionDetailsView;", "ruleDetailsView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/RuleDetailsView;", "getRuleDetailsView", "()Lcom/android/tools/idea/appinspection/inspectors/network/view/details/RuleDetailsView;", "setHttpData", "", "httpData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "setRule", "rule", "Lcom/android/tools/idea/appinspection/inspectors/network/model/rules/RuleData;", "app-inspection.inspectors.network.view"})
public final class NetworkInspectorDetailsPanel
extends JPanel {
    @NotNull
    private final ConnectionDetailsView connectionDetailsView;
    @NotNull
    private final RuleDetailsView ruleDetailsView;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel cardLayoutView;
    @NotNull
    private final AspectObserver aspectObserver;

    public NetworkInspectorDetailsPanel(@NotNull NetworkInspectorView inspectorView, final @NotNull NetworkInspectorTracker usageTracker) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectorView), (String)"inspectorView");
        Intrinsics.checkNotNullParameter((Object)usageTracker, (String)"usageTracker");
        super(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.aspectObserver = new AspectObserver();
        JPanel rootPanel2 = new JPanel((LayoutManager)new TabularLayout("*,Fit-", "Fit-,*"));
        this.cardLayoutView = new JPanel(this.cardLayout);
        this.connectionDetailsView = new ConnectionDetailsView(inspectorView, usageTracker);
        this.ruleDetailsView = new RuleDetailsView(usageTracker);
        this.cardLayoutView.add((Component)((Object)this.connectionDetailsView), NetworkInspectorModel.DetailContent.CONNECTION.name());
        this.cardLayoutView.add((Component)this.ruleDetailsView, NetworkInspectorModel.DetailContent.RULE.name());
        final NetworkInspectorModel model2 = inspectorView.getModel();
        model2.getAspect().addDependency(this.aspectObserver).onChange((Enum)NetworkInspectorAspect.DETAILS, new Runnable(){

            @Override
            public final void run() {
                this.setVisible(model2.getDetailContent() != NetworkInspectorModel.DetailContent.EMPTY);
                cardLayout.show(cardLayoutView, model2.getDetailContent().name());
            }
        });
        model2.getAspect().addDependency(this.aspectObserver).onChange((Enum)NetworkInspectorAspect.SELECTED_CONNECTION, new Runnable(){

            @Override
            public final void run() {
                usageTracker.trackConnectionDetailsSelected();
                HttpData httpData = model2.getSelectedConnection();
                if (httpData != null) {
                    HttpData httpData2 = httpData;
                    NetworkInspectorDetailsPanel networkInspectorDetailsPanel = this;
                    HttpData it = httpData2;
                    boolean bl = false;
                    networkInspectorDetailsPanel.setHttpData(it);
                }
                this.repaint();
            }
        });
        model2.getAspect().addDependency(this.aspectObserver).onChange((Enum)NetworkInspectorAspect.SELECTED_RULE, new Runnable(){

            @Override
            public final void run() {
                block0: {
                    RuleData ruleData = model2.getSelectedRule();
                    if (ruleData == null) break block0;
                    RuleData ruleData2 = ruleData;
                    NetworkInspectorDetailsPanel networkInspectorDetailsPanel = this;
                    RuleData it = ruleData2;
                    boolean bl = false;
                    networkInspectorDetailsPanel.setRule(it);
                }
            }
        });
        CloseButton closeButton2 = new CloseButton(new ActionListener(model2){
            final /* synthetic */ NetworkInspectorModel $model;
            {
                this.$model = $model;
            }

            public final void actionPerformed(ActionEvent it) {
                this.$model.setDetailContent(NetworkInspectorModel.DetailContent.EMPTY);
            }
        });
        JPanel closeButtonWrapper = new JPanel(new BorderLayout());
        closeButtonWrapper.add((Component)closeButton2, "Center");
        closeButtonWrapper.setBorder((Border)JBUI.Borders.empty((int)3, (int)0, (int)0, (int)0));
        rootPanel2.add((Component)closeButtonWrapper, new TabularLayout.Constraint(0, 1, 0, 4, null));
        rootPanel2.add((Component)this.cardLayoutView, new TabularLayout.Constraint(0, 0, 2, 2));
        this.add(rootPanel2);
    }

    @NotNull
    public final ConnectionDetailsView getConnectionDetailsView() {
        return this.connectionDetailsView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getConnectionDetailsView$annotations() {
    }

    @NotNull
    public final RuleDetailsView getRuleDetailsView() {
        return this.ruleDetailsView;
    }

    private final void setHttpData(HttpData httpData) {
        this.setBackground(JBColor.background());
        this.connectionDetailsView.setHttpData(httpData);
    }

    private final void setRule(RuleData rule) {
        this.setBackground(JBColor.background());
        this.ruleDetailsView.setSelectedRule(rule);
    }
}

