/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.details;

import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.idea.appinspection.inspectors.network.model.analytics.NetworkInspectorTracker;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkInspectorView;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.FontsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.details.CallStackTabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.HttpDataComponentFactory;
import com.android.tools.idea.appinspection.inspectors.network.view.details.OverviewTabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.RequestTabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.ResponseTabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabContent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/ConnectionDetailsView;", "Lcom/android/tools/adtui/stdui/CommonTabbedPane;", "inspectorView", "Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;", "usageTracker", "Lcom/android/tools/idea/appinspection/inspectors/network/model/analytics/NetworkInspectorTracker;", "(Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkInspectorView;Lcom/android/tools/idea/appinspection/inspectors/network/model/analytics/NetworkInspectorTracker;)V", "tabs", "", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/TabContent;", "getTabs", "()Ljava/util/List;", "populateTabs", "", "setHttpData", "httpData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
@SourceDebugExtension(value={"SMAP\nConnectionDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/details/ConnectionDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1851#2,2:66\n1851#2,2:68\n*S KotlinDebug\n*F\n+ 1 ConnectionDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/details/ConnectionDetailsView\n*L\n55#1:66,2\n62#1:68,2\n*E\n"})
public final class ConnectionDetailsView
extends CommonTabbedPane {
    @NotNull
    private final NetworkInspectorView inspectorView;
    @NotNull
    private final NetworkInspectorTracker usageTracker;
    @VisibleForTesting
    @NotNull
    private final List<TabContent> tabs;

    public ConnectionDetailsView(@NotNull NetworkInspectorView inspectorView, @NotNull NetworkInspectorTracker usageTracker) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectorView), (String)"inspectorView");
        Intrinsics.checkNotNullParameter((Object)usageTracker, (String)"usageTracker");
        this.inspectorView = inspectorView;
        this.usageTracker = usageTracker;
        this.tabs = new ArrayList();
        this.setFont(FontsKt.getSTANDARD_FONT());
        this.populateTabs();
        this.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                switch (this.getSelectedIndex()) {
                    case 1: {
                        usageTracker.trackResponseTabSelected();
                        break;
                    }
                    case 2: {
                        usageTracker.trackRequestTabSelected();
                        break;
                    }
                    case 3: {
                        usageTracker.trackCallstackTabSelected();
                    }
                }
                this.repaint();
            }
        });
    }

    @NotNull
    public final List<TabContent> getTabs() {
        return this.tabs;
    }

    private final void populateTabs() {
        this.tabs.add(new OverviewTabContent());
        this.tabs.add(new ResponseTabContent());
        this.tabs.add(new RequestTabContent());
        this.tabs.add(new CallStackTabContent(this.inspectorView.getComponentsProvider().createStackView(this.inspectorView.getModel().getStackTraceModel())));
        Iterable $this$forEach$iv = this.tabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabContent tab = (TabContent)element$iv;
            boolean bl = false;
            this.addTab(tab.getTitle(), null, tab.getComponent());
        }
    }

    public final void setHttpData(@NotNull HttpData httpData) {
        Intrinsics.checkNotNullParameter((Object)httpData, (String)"httpData");
        HttpDataComponentFactory httpDataComponentFactory = new HttpDataComponentFactory(httpData, this.inspectorView.getComponentsProvider());
        Iterable $this$forEach$iv = this.tabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabContent it = (TabContent)element$iv;
            boolean bl = false;
            it.populateFor(httpData, httpDataComponentFactory);
        }
    }
}

