/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.adtui.stdui.BorderlessTableCellRenderer;
import com.android.tools.adtui.stdui.TimelineTable;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.SelectionRangeDataFetcher;
import com.android.tools.idea.appinspection.inspectors.network.view.ConnectionsStateChart;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.android.tools.idea.appinspection.inspectors.network.view.rules.TableDecoraterUtilKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView;", "Lcom/android/tools/adtui/model/AspectObserver;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;)V", "columnWidthsInitialized", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "connectionsTable", "Ljavax/swing/JTable;", "tableModel", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$ConnectionsTableModel;", "createTooltip", "", "customizeConnectionsTable", "getColumnForIndex", "Ljavax/swing/table/TableColumn;", "kotlin.jvm.PlatformType", "index", "", "updateTableSelection", "Column", "ConnectionsTableModel", "SizeRenderer", "StatusRenderer", "TimeRenderer", "TimelineRenderer", "app-inspection.inspectors.network.view"})
public final class ConnectionsView
extends AspectObserver {
    @NotNull
    private final NetworkInspectorModel model;
    @NotNull
    private final TooltipLayeredPane parentPane;
    @NotNull
    private final ConnectionsTableModel tableModel;
    @NotNull
    private final JTable connectionsTable;
    private boolean columnWidthsInitialized;

    public ConnectionsView(@NotNull NetworkInspectorModel model2, @NotNull TooltipLayeredPane parentPane) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
        this.model = model2;
        this.parentPane = parentPane;
        this.tableModel = new ConnectionsTableModel(this.model.getSelectionRangeDataFetcher());
        JBTable jBTable = TimelineTable.create((TableModel)this.tableModel, (Timeline)((Timeline)this.model.getTimeline()), (String)Column.TIMELINE.toDisplayString(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"create(tableModel, model\u2026.toDisplayString(), true)");
        this.connectionsTable = (JTable)jBTable;
        this.customizeConnectionsTable();
        this.createTooltip();
        this.model.getAspect().addDependency((AspectObserver)this).onChange((Enum)NetworkInspectorAspect.SELECTED_CONNECTION, new Runnable(){

            @Override
            public final void run() {
                this.updateTableSelection();
            }
        });
    }

    @NotNull
    public final JComponent getComponent() {
        return this.connectionsTable;
    }

    private final void customizeConnectionsTable() {
        this.connectionsTable.setAutoCreateRowSorter(true);
        this.connectionsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer((TableCellRenderer)new BorderlessTableCellRenderer());
        this.connectionsTable.getColumnModel().getColumn(Column.SIZE.ordinal()).setCellRenderer((TableCellRenderer)((Object)new SizeRenderer()));
        this.connectionsTable.getColumnModel().getColumn(Column.TYPE.ordinal()).setCellRenderer((TableCellRenderer)new BorderlessTableCellRenderer());
        this.connectionsTable.getColumnModel().getColumn(Column.STATUS.ordinal()).setCellRenderer((TableCellRenderer)((Object)new StatusRenderer()));
        this.connectionsTable.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer((TableCellRenderer)((Object)new TimeRenderer()));
        this.connectionsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer((TableCellRenderer)((Object)new TimelineRenderer(this.connectionsTable, this.model.getTimeline())));
        this.connectionsTable.setSelectionMode(0);
        this.connectionsTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row2 = ConnectionsView.access$getConnectionsTable$p(this.this$0).rowAtPoint(e.getPoint());
                if (row2 != -1) {
                    ConnectionsView.access$getModel$p(this.this$0).setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
                }
            }
        });
        TableDecoraterUtilKt.registerEnterKeyAction(this.connectionsTable, (Function1<? super ActionEvent, Unit>)((Function1)new Function1<ActionEvent, Unit>(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ConnectionsView.access$getConnectionsTable$p(this.this$0).getSelectedRow() != -1) {
                    ConnectionsView.access$getModel$p(this.this$0).setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
                }
            }
        }));
        this.connectionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(@NotNull ListSelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedRow = ConnectionsView.access$getConnectionsTable$p(this.this$0).getSelectedRow();
                if (0 <= selectedRow && selectedRow < ConnectionsView.access$getTableModel$p(this.this$0).getRowCount()) {
                    int modelRow = ConnectionsView.access$getConnectionsTable$p(this.this$0).convertRowIndexToModel(selectedRow);
                    ConnectionsView.access$getModel$p(this.this$0).setSelectedConnection(ConnectionsView.access$getTableModel$p(this.this$0).getHttpData(modelRow));
                }
            }
        });
        this.connectionsTable.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        this.connectionsTable.setShowVerticalLines(true);
        this.connectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.connectionsTable.getFontMetrics(this.connectionsTable.getFont()).getHeight();
        this.connectionsTable.setRowMargin(0);
        this.connectionsTable.setRowHeight(defaultFontHeight + LayoutKt.getROW_HEIGHT_PADDING());
        this.connectionsTable.setFocusTraversalKeys(0, null);
        this.connectionsTable.setFocusTraversalKeys(1, null);
        this.connectionsTable.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void componentResized(@NotNull ComponentEvent e) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Column[] columnArray = Column.values();
                ConnectionsView connectionsView = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void column2;
                    int n = index$iv++;
                    void var9_9 = item$iv;
                    int i = n;
                    boolean bl = false;
                    ConnectionsView.access$getColumnForIndex(connectionsView, i).setPreferredWidth((int)((double)ConnectionsView.access$getConnectionsTable$p(connectionsView).getWidth() * column2.getWidthPercentage()));
                }
                ConnectionsView.access$setColumnWidthsInitialized$p(this.this$0, true);
            }
        });
        this.model.getSelectionRangeDataFetcher().addOnChangedListener((Function1<? super List<HttpData>, Unit>)((Function1)new Function1<List<? extends HttpData>, Unit>(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<HttpData> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ConnectionsView.access$updateTableSelection(this.this$0);
            }
        }));
        this.connectionsTable.getTableHeader().setReorderingAllowed(false);
        this.connectionsTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
            }

            public void columnAdded(@NotNull TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void columnRemoved(@NotNull TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void columnMoved(@NotNull TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void columnSelectionChanged(@Nullable ListSelectionEvent e) {
            }

            /*
             * WARNING - void declaration
             */
            public void columnMarginChanged(@NotNull ChangeEvent e) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!ConnectionsView.access$getColumnWidthsInitialized$p(this.this$0)) {
                    return;
                }
                Column[] columnArray = Column.values();
                ConnectionsView connectionsView = this.this$0;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void column2;
                    int n = index$iv++;
                    void var9_9 = item$iv;
                    int index2 = n;
                    boolean bl = false;
                    column2.setWidthPercentage((double)ConnectionsView.access$getColumnForIndex(connectionsView, index2).getWidth() / (double)ConnectionsView.access$getConnectionsTable$p(connectionsView).getWidth());
                }
            }
        });
    }

    private final TableColumn getColumnForIndex(int index2) {
        return this.connectionsTable.getColumnModel().getColumn(this.connectionsTable.convertColumnIndexToView(index2));
    }

    private final void createTooltip() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(LayoutKt.getTOOLTIP_BORDER());
        textPane.setBackground(ColorsKt.getTOOLTIP_BACKGROUND());
        textPane.setForeground(ColorsKt.getTOOLTIP_TEXT());
        textPane.setFont(TooltipView.TOOLTIP_BODY_FONT);
        TooltipComponent tooltipComponent = new TooltipComponent.Builder((JComponent)textPane, (JComponent)this.connectionsTable, (JComponent)this.parentPane).build();
        Intrinsics.checkNotNullExpressionValue((Object)tooltipComponent, (String)"Builder(textPane, connec\u2026able, parentPane).build()");
        TooltipComponent tooltip2 = tooltipComponent;
        tooltip2.registerListenersOn((Component)this.connectionsTable);
        this.connectionsTable.addMouseMotionListener(new MouseAdapter(this, tooltip2, textPane){
            final /* synthetic */ ConnectionsView this$0;
            final /* synthetic */ TooltipComponent $tooltip;
            final /* synthetic */ JTextPane $textPane;
            {
                this.this$0 = $receiver;
                this.$tooltip = $tooltip;
                this.$textPane = $textPane;
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row2 = ConnectionsView.access$getConnectionsTable$p(this.this$0).rowAtPoint(e.getPoint());
                if (row2 >= 0) {
                    this.$tooltip.setVisible(true);
                    String url = ConnectionsView.access$getTableModel$p(this.this$0).getHttpData(ConnectionsView.access$getConnectionsTable$p(this.this$0).convertRowIndexToModel(row2)).getUrl();
                    this.$textPane.setText(url);
                } else {
                    this.$tooltip.setVisible(false);
                }
            }
        });
    }

    private final void updateTableSelection() {
        HttpData selectedData = this.model.getSelectedConnection();
        if (selectedData != null) {
            int n = this.tableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (this.tableModel.getHttpData(i).getId() != selectedData.getId()) continue;
                int row2 = this.connectionsTable.convertRowIndexToView(i);
                this.connectionsTable.setRowSelectionInterval(row2, row2);
                return;
            }
        } else {
            this.connectionsTable.clearSelection();
        }
    }

    public static final /* synthetic */ JTable access$getConnectionsTable$p(ConnectionsView $this) {
        return $this.connectionsTable;
    }

    public static final /* synthetic */ NetworkInspectorModel access$getModel$p(ConnectionsView $this) {
        return $this.model;
    }

    public static final /* synthetic */ ConnectionsTableModel access$getTableModel$p(ConnectionsView $this) {
        return $this.tableModel;
    }

    public static final /* synthetic */ void access$setColumnWidthsInitialized$p(ConnectionsView $this, boolean bl) {
        $this.columnWidthsInitialized = bl;
    }

    public static final /* synthetic */ TableColumn access$getColumnForIndex(ConnectionsView $this, int index2) {
        return $this.getColumnForIndex(index2);
    }

    public static final /* synthetic */ boolean access$getColumnWidthsInitialized$p(ConnectionsView $this) {
        return $this.columnWidthsInitialized;
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0006\u0010\u0011\u001a\u00020\u0012R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fj\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "", "widthPercentage", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;IDLjava/lang/Class;)V", "getType", "()Ljava/lang/Class;", "getWidthPercentage", "()D", "setWidthPercentage", "(D)V", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "toDisplayString", "", "NAME", "SIZE", "TYPE", "STATUS", "TIME", "TIMELINE", "app-inspection.inspectors.network.view"})
    public static final abstract class Column
    extends Enum<Column> {
        private double widthPercentage;
        @NotNull
        private final Class<?> type;
        public static final /* enum */ Column NAME = new NAME("NAME", 0);
        public static final /* enum */ Column SIZE = new SIZE("SIZE", 1);
        public static final /* enum */ Column TYPE = new TYPE("TYPE", 2);
        public static final /* enum */ Column STATUS = new STATUS("STATUS", 3);
        public static final /* enum */ Column TIME = new TIME("TIME", 4);
        public static final /* enum */ Column TIMELINE = new TIMELINE("TIMELINE", 5);
        private static final /* synthetic */ Column[] $VALUES;

        private Column(double widthPercentage, Class<?> type) {
            this.widthPercentage = widthPercentage;
            this.type = type;
        }

        public final double getWidthPercentage() {
            return this.widthPercentage;
        }

        public final void setWidthPercentage(double d) {
            this.widthPercentage = d;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        @NotNull
        public final String toDisplayString() {
            String string = this.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            return StringsKt.capitalize((String)string2);
        }

        @NotNull
        public abstract Object getValueFrom(@NotNull HttpData var1);

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value2) {
            return Enum.valueOf(Column.class, value2);
        }

        public /* synthetic */ Column(String $enum$name, int $enum$ordinal, double widthPercentage, Class type, DefaultConstructorMarker $constructor_marker) {
            this(widthPercentage, type);
        }

        static {
            $VALUES = columnArray = new Column[]{Column.NAME, Column.SIZE, Column.TYPE, Column.STATUS, Column.TIME, Column.TIMELINE};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$NAME;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class NAME
        extends Column {
            /*
             * WARNING - void declaration
             */
            NAME() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return HttpData.Companion.getUrlName(data.getUrl());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$SIZE;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class SIZE
        extends Column {
            /*
             * WARNING - void declaration
             */
            SIZE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getResponsePayload().size();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$STATUS;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class STATUS
        extends Column {
            /*
             * WARNING - void declaration
             */
            STATUS() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getResponseHeader().getStatusCode();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$TIME;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class TIME
        extends Column {
            /*
             * WARNING - void declaration
             */
            TIME() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getConnectionEndTimeUs() - data.getRequestStartTimeUs();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$TIMELINE;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class TIMELINE
        extends Column {
            /*
             * WARNING - void declaration
             */
            TIMELINE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getRequestStartTimeUs();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column$TYPE;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$Column;", "getValueFrom", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "app-inspection.inspectors.network.view"})
        static final class TYPE
        extends Column {
            /*
             * WARNING - void declaration
             */
            TYPE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull HttpData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                HttpData.ContentType type = data.getResponseHeader().getContentType();
                String[] stringArray = new String[]{"/"};
                List mimeTypeParts = StringsKt.split$default((CharSequence)type.getMimeType(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                return mimeTypeParts.get(mimeTypeParts.size() - 1);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$ConnectionsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "selectionRangeDataFetcher", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/SelectionRangeDataFetcher;", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/SelectionRangeDataFetcher;)V", "dataList", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "", "column", "getHttpData", "rowIndex", "getRowCount", "getValueAt", "", "app-inspection.inspectors.network.view"})
    private static final class ConnectionsTableModel
    extends AbstractTableModel {
        private List<HttpData> dataList;

        public ConnectionsTableModel(@NotNull SelectionRangeDataFetcher selectionRangeDataFetcher) {
            Intrinsics.checkNotNullParameter((Object)selectionRangeDataFetcher, (String)"selectionRangeDataFetcher");
            selectionRangeDataFetcher.addOnChangedListener((Function1<? super List<HttpData>, Unit>)((Function1)new Function1<List<? extends HttpData>, Unit>(){

                public final void invoke(@NotNull List<HttpData> httpDataList) {
                    Intrinsics.checkNotNullParameter(httpDataList, (String)"httpDataList");
                    dataList = httpDataList;
                    this.fireTableDataChanged();
                }
            }));
        }

        @Override
        public int getRowCount() {
            List<HttpData> list2 = this.dataList;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataList");
                list2 = null;
            }
            return list2.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        @NotNull
        public String getColumnName(int column2) {
            return Column.values()[column2].toDisplayString();
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            List<HttpData> list2 = this.dataList;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataList");
                list2 = null;
            }
            HttpData data = list2.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(data);
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public final HttpData getHttpData(int rowIndex) {
            List<HttpData> list2 = this.dataList;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataList");
                list2 = null;
            }
            return list2.get(rowIndex);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$SizeRenderer;", "Lcom/android/tools/adtui/stdui/BorderlessTableCellRenderer;", "()V", "setValue", "", "value", "", "app-inspection.inspectors.network.view"})
    private static final class SizeRenderer
    extends BorderlessTableCellRenderer {
        public SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        protected void setValue(@NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            int bytes2 = (Integer)value2;
            this.setText(bytes2 >= 0 ? NumberFormatter.formatFileSize((long)bytes2) : "");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$StatusRenderer;", "Lcom/android/tools/adtui/stdui/BorderlessTableCellRenderer;", "()V", "setValue", "", "value", "", "app-inspection.inspectors.network.view"})
    private static final class StatusRenderer
    extends BorderlessTableCellRenderer {
        protected void setValue(@NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            int status2 = (Integer)value2;
            this.setText(status2 > -1 ? String.valueOf(status2) : "");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$TimeRenderer;", "Lcom/android/tools/adtui/stdui/BorderlessTableCellRenderer;", "()V", "setValue", "", "value", "", "app-inspection.inspectors.network.view"})
    private static final class TimeRenderer
    extends BorderlessTableCellRenderer {
        public TimeRenderer() {
            this.setHorizontalAlignment(4);
        }

        protected void setValue(@NotNull Object value2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            long durationUs = (Long)value2;
            if (durationUs >= 0L) {
                long durationMs = TimeUnit.MICROSECONDS.toMillis(durationUs);
                string = StringUtil.formatDuration((long)durationMs);
            } else {
                string = "";
            }
            this.setText(string);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsView$TimelineRenderer;", "Lcom/android/tools/adtui/stdui/TimelineTable$CellRenderer;", "Ljavax/swing/event/TableModelListener;", "table", "Ljavax/swing/JTable;", "timeline", "Lcom/android/tools/adtui/model/StreamingTimeline;", "(Ljavax/swing/JTable;Lcom/android/tools/adtui/model/StreamingTimeline;)V", "connectionsCharts", "", "Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsStateChart;", "getTableCellRendererComponent", "Ljava/awt/Component;", "isSelected", "", "row", "", "tableChanged", "", "e", "Ljavax/swing/event/TableModelEvent;", "app-inspection.inspectors.network.view"})
    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final JTable table;
        @NotNull
        private final List<ConnectionsStateChart> connectionsCharts;

        public TimelineRenderer(@NotNull JTable table2, @NotNull StreamingTimeline timeline) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
            super((Timeline)timeline, true);
            this.table = table2;
            this.connectionsCharts = new ArrayList();
            this.table.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.table.getModel()));
        }

        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row2) {
            ConnectionsStateChart chart = this.connectionsCharts.get(this.table.convertRowIndexToModel(row2));
            chart.getColors().setColorIndex(isSelected ? 1 : 0);
            chart.getComponent().setBorder((Border)new TimelineTable.GridBorder(this.table));
            return (Component)chart.getComponent();
        }

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.connectionsCharts.clear();
            TableModel tableModel2 = this.table.getModel();
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.appinspection.inspectors.network.view.ConnectionsView.ConnectionsTableModel");
            ConnectionsTableModel model2 = (ConnectionsTableModel)tableModel2;
            int n = model2.getRowCount();
            for (int i = 0; i < n; ++i) {
                HttpData httpData = model2.getHttpData(i);
                Range range = this.getActiveRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"activeRange");
                ConnectionsStateChart chart = new ConnectionsStateChart(httpData, range);
                chart.setHeightGap(0.3f);
                this.connectionsCharts.add(chart);
            }
        }
    }
}

