/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.idea.appinspection.inspectors.network.model.httpdata.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkState;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsStateChart;", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;", "range", "Lcom/android/tools/adtui/model/Range;", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/httpdata/HttpData;Lcom/android/tools/adtui/model/Range;)V", "dataList", "", "(Ljava/util/List;Lcom/android/tools/adtui/model/Range;)V", "colors", "Lcom/android/tools/adtui/common/EnumColors;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkState;", "kotlin.jvm.PlatformType", "getColors", "()Lcom/android/tools/adtui/common/EnumColors;", "component", "Lcom/android/tools/adtui/chart/statechart/StateChart;", "getComponent", "()Lcom/android/tools/adtui/chart/statechart/StateChart;", "createChart", "", "setHeightGap", "", "gap", "", "app-inspection.inspectors.network.view"})
public final class ConnectionsStateChart {
    @NotNull
    private final EnumColors<NetworkState> colors;
    @NotNull
    private final StateChart<NetworkState> component;

    public ConnectionsStateChart(@NotNull List<HttpData> dataList, @NotNull Range range) {
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Color[] colorArray = new Color[]{ColorsKt.getNETWORK_SENDING_COLOR(), ColorsKt.getNETWORK_SENDING_COLOR()};
        EnumColors.Builder builder2 = new EnumColors.Builder(2).add((Enum)NetworkState.SENDING, colorArray);
        colorArray = new Color[]{ColorsKt.getNETWORK_RECEIVING_COLOR(), ColorsKt.getNETWORK_RECEIVING_SELECTED_COLOR()};
        EnumColors.Builder builder3 = builder2.add((Enum)NetworkState.RECEIVING, colorArray);
        colorArray = new Color[]{ColorsKt.getNETWORK_WAITING_COLOR(), ColorsKt.getNETWORK_WAITING_COLOR()};
        EnumColors.Builder builder4 = builder3.add((Enum)NetworkState.WAITING, colorArray);
        colorArray = new Color[]{ColorsKt.getTRANSPARENT_COLOR(), ColorsKt.getTRANSPARENT_COLOR()};
        EnumColors enumColors = builder4.add((Enum)NetworkState.NONE, colorArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)enumColors, (String)"Builder<NetworkState>(2)\u2026ENT_COLOR)\n      .build()");
        this.colors = enumColors;
        this.component = this.createChart((Collection<HttpData>)dataList, range);
    }

    public ConnectionsStateChart(@NotNull HttpData data, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(CollectionsKt.listOf((Object)data), range);
    }

    @NotNull
    public final EnumColors<NetworkState> getColors() {
        return this.colors;
    }

    @NotNull
    public final StateChart<NetworkState> getComponent() {
        return this.component;
    }

    public final void setHeightGap(float gap) {
        this.component.setHeightGap(gap);
    }

    private final StateChart<NetworkState> createChart(Collection<HttpData> dataList, Range range) {
        DefaultDataSeries series = new DefaultDataSeries();
        series.add(0L, (Object)NetworkState.NONE);
        for (HttpData data : dataList) {
            if (data.getConnectionEndTimeUs() == 0L) continue;
            series.add(data.getRequestStartTimeUs(), (Object)NetworkState.SENDING);
            if (data.getResponseStartTimeUs() > 0L) {
                series.add(data.getResponseStartTimeUs(), (Object)NetworkState.RECEIVING);
            }
            series.add(data.getConnectionEndTimeUs(), (Object)NetworkState.NONE);
        }
        StateChartModel stateModel = new StateChartModel();
        StateChart stateChart2 = new StateChart(stateModel, (StateChartColorProvider)new StateChartColorProvider<NetworkState>(this){
            final /* synthetic */ ConnectionsStateChart this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull NetworkState value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                Color color = this.this$0.getColors().getColor((Enum)value2);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"colors.getColor(value)");
                return color;
            }
        }, null, 4, null);
        stateModel.addSeries(new RangedSeries(range, (DataSeries)series, null, 4, null));
        return stateChart2;
    }
}

