/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntrySelectionModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntryUpdateEventType;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskEntriesViewKt;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorColors;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorTab;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryFormatUtilKt;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/WorkDependencyGraphView;", "Ljavax/swing/JPanel;", "tab", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "selectionModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "labelMap", "", "", "Ljavax/swing/JLabel;", "works", "", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo;", "createLabel", "work", "estimateWidth", "", "paint", "", "g", "Ljava/awt/Graphics;", "registerDirectionKeyStroke", "keyCode", "name", "deltaRow", "deltaCol", "updateWorks", "app-inspection.inspectors.backgroundtask.view"})
@SourceDebugExtension(value={"SMAP\nWorkEntryGraphView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkEntryGraphView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/WorkDependencyGraphView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1179#2,2:237\n1253#2,4:239\n1603#2,9:243\n1851#2:252\n1852#2:254\n1612#2:255\n766#2:256\n857#2,2:257\n766#2:259\n857#2,2:260\n1603#2,9:263\n1851#2:272\n1852#2:274\n1612#2:275\n1#3:253\n1#3:262\n1#3:273\n*S KotlinDebug\n*F\n+ 1 WorkEntryGraphView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/WorkDependencyGraphView\n*L\n123#1:237,2\n123#1:239,4\n127#1:243,9\n127#1:252\n127#1:254\n127#1:255\n134#1:256\n134#1:257,2\n141#1:259\n141#1:260,2\n228#1:263,9\n228#1:272\n228#1:274\n228#1:275\n127#1:253\n228#1:273\n*E\n"})
public final class WorkDependencyGraphView
extends JPanel {
    @NotNull
    private final BackgroundTaskInspectorTab tab;
    @NotNull
    private final BackgroundTaskInspectorClient client;
    @NotNull
    private final EntrySelectionModel selectionModel;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher uiDispatcher;
    @NotNull
    private List<WorkManagerInspectorProtocol.WorkInfo> works;
    @NotNull
    private Map<String, ? extends JLabel> labelMap;

    public WorkDependencyGraphView(@NotNull BackgroundTaskInspectorTab tab, @NotNull BackgroundTaskInspectorClient client2, @NotNull EntrySelectionModel selectionModel, @NotNull CoroutineScope scope2, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.tab = tab;
        this.client = client2;
        this.selectionModel = selectionModel;
        this.scope = scope2;
        this.uiDispatcher = uiDispatcher;
        this.works = CollectionsKt.emptyList();
        this.labelMap = MapsKt.emptyMap();
        this.setBorder(new EmptyBorder(JBUI.scale((int)50), JBUI.scale((int)100), JBUI.scale((int)50), 0));
        this.client.addEntryUpdateEventListener((Function2<? super EntryUpdateEventType, ? super BackgroundTaskEntry, Unit>)((Function2)new Function2<EntryUpdateEventType, BackgroundTaskEntry, Unit>(){

            public final void invoke(@NotNull EntryUpdateEventType entryUpdateEventType, @NotNull BackgroundTaskEntry backgroundTaskEntry) {
                Intrinsics.checkNotNullParameter((Object)((Object)entryUpdateEventType), (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)backgroundTaskEntry, (String)"<anonymous parameter 1>");
                BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)uiDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ WorkDependencyGraphView this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.updateWorks();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
        this.selectionModel.registerEntrySelectionListener((Function1<? super BackgroundTaskEntry, Unit>)((Function1)new Function1<BackgroundTaskEntry, Unit>(){

            public final void invoke(@Nullable BackgroundTaskEntry it) {
                this.updateWorks();
            }
        }));
        this.registerDirectionKeyStroke(38, "Up", -1, 0);
        this.registerDirectionKeyStroke(40, "Down", 1, 0);
        this.registerDirectionKeyStroke(37, "Left", 0, -1);
        this.registerDirectionKeyStroke(39, "Right", 0, 1);
    }

    private final void registerDirectionKeyStroke(int keyCode, String name2, int deltaRow, int deltaCol) {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(keyCode, 0), name2);
        this.getActionMap().put(name2, new AbstractAction(this, deltaRow, deltaCol){
            final /* synthetic */ WorkDependencyGraphView this$0;
            final /* synthetic */ int $deltaRow;
            final /* synthetic */ int $deltaCol;
            {
                this.this$0 = $receiver;
                this.$deltaRow = $deltaRow;
                this.$deltaCol = $deltaCol;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                int row2;
                int col;
                block11: {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    WorkManagerInspectorProtocol.WorkInfo workInfo = WorkDependencyGraphView.access$getSelectionModel$p(this.this$0).getSelectedWork();
                    if (workInfo == null) {
                        return;
                    }
                    WorkManagerInspectorProtocol.WorkInfo selectedWork = workInfo;
                    JLabel jLabel = (JLabel)WorkDependencyGraphView.access$getLabelMap$p(this.this$0).get(selectedWork.getId());
                    if (jLabel == null) {
                        return;
                    }
                    JLabel selectedLabel = jLabel;
                    col = 0;
                    col = -1;
                    Component[] componentArray = this.this$0.getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
                    Object[] $this$indexOfFirst$iv = componentArray;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length;
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        block10: {
                            int n3;
                            Component rowPanel = (Component)$this$indexOfFirst$iv[index$iv];
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)rowPanel, (String)"null cannot be cast to non-null type javax.swing.JPanel");
                            Component[] componentArray2 = ((JPanel)rowPanel).getComponents();
                            Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"rowPanel as JPanel).components");
                            Object[] $this$indexOfFirst$iv2 = componentArray2;
                            boolean $i$f$indexOfFirst2 = false;
                            int n4 = $this$indexOfFirst$iv2.length;
                            for (int index$iv2 = 0; index$iv2 < n4; ++index$iv2) {
                                Component it = (Component)$this$indexOfFirst$iv2[index$iv2];
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)selectedLabel)) continue;
                                n3 = index$iv2;
                                break block10;
                            }
                            n3 = col = -1;
                        }
                        if (!(col != -1)) continue;
                        n = index$iv;
                        break block11;
                    }
                    n = row2 = -1;
                }
                if (row2 == -1) {
                    return;
                }
                col += this.$deltaCol;
                boolean bl = 0 <= (row2 += this.$deltaRow) ? row2 < this.this$0.getComponentCount() : false;
                if (bl) {
                    Component component2 = this.this$0.getComponent(row2);
                    Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JPanel");
                    JPanel rowPanel = (JPanel)component2;
                    boolean bl3 = 0 <= col ? col < rowPanel.getComponentCount() : false;
                    if (bl3) {
                        Object object;
                        Object v9;
                        block12: {
                            Component label = rowPanel.getComponent(col);
                            Iterable $this$firstOrNull$iv = WorkDependencyGraphView.access$getLabelMap$p(this.this$0).entrySet();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                Map.Entry it = (Map.Entry)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(it.getValue(), (Object)label)) continue;
                                v9 = element$iv;
                                break block12;
                            }
                            v9 = null;
                        }
                        if ((object = (Map.Entry)v9) == null || (object = (String)object.getKey()) == null) {
                            return;
                        }
                        Object id2 = object;
                        BackgroundTaskEntry backgroundTaskEntry = WorkDependencyGraphView.access$getClient$p(this.this$0).getEntry((String)id2);
                        WorkEntry workEntry = backgroundTaskEntry instanceof WorkEntry ? (WorkEntry)backgroundTaskEntry : null;
                        if (workEntry == null) {
                            return;
                        }
                        WorkEntry workEntry2 = workEntry;
                        WorkDependencyGraphView.access$getSelectionModel$p(this.this$0).setSelectedEntry(workEntry2);
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWorks() {
        Iterable $this$filter$iv;
        Object it;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        WorkManagerInspectorProtocol.WorkInfo workInfo = this.selectionModel.getSelectedWork();
        if (workInfo == null) {
            return;
        }
        WorkManagerInspectorProtocol.WorkInfo selectedWork = workInfo;
        this.removeAll();
        String string = selectedWork.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedWork.id");
        this.works = this.client.getOrderedWorkChain(string);
        if (this.works.isEmpty()) {
            return;
        }
        Iterable iterable = this.works;
        WorkDependencyGraphView workDependencyGraphView = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_10 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            it = (WorkManagerInspectorProtocol.WorkInfo)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getId(), (Object)this.createLabel((WorkManagerInspectorProtocol.WorkInfo)it));
            map2.put(it.getFirst(), it.getSecond());
        }
        workDependencyGraphView.labelMap = destination$iv$iv;
        JLabel selectedLabel = this.labelMap.get(selectedWork.getId());
        Map depthMap = new LinkedHashMap();
        for (WorkManagerInspectorProtocol.WorkInfo work : this.works) {
            void $this$mapNotNullTo$iv$iv;
            destination$iv$iv = depthMap;
            Intrinsics.checkNotNullExpressionValue((Object)work.getId(), (String)"work.id");
            ProtocolStringList protocolStringList = work.getPrerequisitesList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"work.prerequisitesList");
            Iterable $this$mapNotNull$iv = (Iterable)protocolStringList;
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it2 = (String)element$iv$iv;
                boolean bl2 = false;
                if ((Integer)depthMap.get(it2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
            Integer n2 = (n != null ? n : -1) + 1;
            destination$iv$iv.put($i$f$associateTo, n2);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)depthMap.values());
        int maxDepth = n != null ? n : -1;
        int maxWidth = 0;
        int depth = 0;
        if (depth <= maxDepth) {
            while (true) {
                void $this$filterTo$iv$iv;
                $this$filter$iv = this.works;
                boolean $i$f$filter = false;
                Iterable $i$f$mapNotNull = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    WorkManagerInspectorProtocol.WorkInfo it3 = (WorkManagerInspectorProtocol.WorkInfo)element$iv$iv;
                    boolean bl = false;
                    Integer n3 = (Integer)depthMap.get(it3.getId());
                    int n4 = depth;
                    if (!(n3 != null && n3 == n4)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List worksWithDepth = (List)destination$iv$iv3;
                maxWidth = Math.max(maxWidth, this.estimateWidth(worksWithDepth));
                if (depth == maxDepth) break;
                ++depth;
            }
        }
        this.setLayout((LayoutManager)new VerticalLayout(JBUI.scale((int)50)));
        depth = 0;
        if (depth <= maxDepth) {
            while (true) {
                int n5;
                $this$filter$iv = this.works;
                boolean $i$f$filter22 = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    WorkManagerInspectorProtocol.WorkInfo it4 = (WorkManagerInspectorProtocol.WorkInfo)element$iv$iv;
                    boolean bl = false;
                    Integer n6 = (Integer)depthMap.get(it4.getId());
                    int n7 = depth;
                    if (!(n6 != null && n6 == n7)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                List worksWithDepth = (List)destination$iv$iv4;
                Iterable $i$f$filter22 = worksWithDepth;
                int n8 = maxWidth;
                int $this$filterTo$iv$iv2 = 0;
                for (Object t : $i$f$filter22) {
                    void it5;
                    WorkManagerInspectorProtocol.WorkInfo $i$f$mapNotNullTo = (WorkManagerInspectorProtocol.WorkInfo)t;
                    n5 = $this$filterTo$iv$iv2;
                    boolean bl = false;
                    JLabel jLabel = this.labelMap.get(it5.getId());
                    Intrinsics.checkNotNull((Object)jLabel);
                    int n9 = jLabel.getPreferredSize().width;
                    $this$filterTo$iv$iv2 = n5 + n9;
                }
                n5 = $this$filterTo$iv$iv2;
                int gap = (n8 - n5) / (worksWithDepth.size() + 1);
                JPanel panelWithDepth = new JPanel((LayoutManager)new TabularLayout(gap + "px" + StringsKt.repeat((CharSequence)(",Fit," + gap + "px"), (int)worksWithDepth.size())));
                int n10 = worksWithDepth.size();
                for (int index2 = 0; index2 < n10; ++index2) {
                    JLabel jLabel = this.labelMap.get(((WorkManagerInspectorProtocol.WorkInfo)worksWithDepth.get(index2)).getId());
                    Intrinsics.checkNotNull((Object)jLabel);
                    panelWithDepth.add((Component)jLabel, new TabularLayout.Constraint(0, 1 + index2 * 2, 0, 4, null));
                }
                this.add(panelWithDepth);
                if (depth == maxDepth) break;
                ++depth;
            }
        }
        this.validate();
        JLabel jLabel = selectedLabel;
        if (jLabel != null) {
            BackgroundTaskEntriesViewKt.scrollToCenter(jLabel);
        }
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final int estimateWidth(List<WorkManagerInspectorProtocol.WorkInfo> works) {
        int n;
        Iterable iterable = works;
        int n2 = 50 * (works.size() + 1);
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            WorkManagerInspectorProtocol.WorkInfo workInfo = (WorkManagerInspectorProtocol.WorkInfo)t;
            n = n3;
            boolean bl = false;
            JLabel jLabel = this.labelMap.get(it.getId());
            Intrinsics.checkNotNull((Object)jLabel);
            int n4 = jLabel.getPreferredSize().width;
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    private final JLabel createLabel(WorkManagerInspectorProtocol.WorkInfo work) {
        String string = work.getWorkerClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"work.workerClassName");
        JBLabel label = new JBLabel(StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null), 0);
        WorkManagerInspectorProtocol.WorkInfo.State state2 = work.getState();
        Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"work.state");
        label.setIcon(EntryFormatUtilKt.icon(state2));
        label.setBackground((Color)BackgroundTaskInspectorColors.INSTANCE.getGRAPH_LABEL_BACKGROUND_COLOR());
        label.setOpaque(true);
        EmptyBorder defaultBorder = new EmptyBorder(JBUI.scale((int)6), JBUI.scale((int)10), JBUI.scale((int)6), JBUI.scale((int)10));
        label.setBorder(Intrinsics.areEqual((Object)work, (Object)this.selectionModel.getSelectedWork()) ? (Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(JBUI.scale((int)2), JBUI.scale((int)2), JBUI.scale((int)2), JBUI.scale((int)2), (Color)BackgroundTaskInspectorColors.INSTANCE.getSELECTED_WORK_BORDER_COLOR()), defaultBorder) : (Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(JBUI.scale((int)1), JBUI.scale((int)1), JBUI.scale((int)1), JBUI.scale((int)1), (Color)BackgroundTaskInspectorColors.INSTANCE.getDEFAULT_WORK_BORDER_COLOR()), BorderFactory.createCompoundBorder(new EmptyBorder(JBUI.scale((int)1), JBUI.scale((int)1), JBUI.scale((int)1), JBUI.scale((int)1)), defaultBorder)));
        label.addMouseListener((MouseListener)new MouseAdapter(this, work){
            final /* synthetic */ WorkDependencyGraphView this$0;
            final /* synthetic */ WorkManagerInspectorProtocol.WorkInfo $work;
            {
                this.this$0 = $receiver;
                this.$work = $work;
            }

            public void mousePressed(@Nullable MouseEvent e) {
                block0: {
                    BackgroundTaskInspectorClient backgroundTaskInspectorClient = WorkDependencyGraphView.access$getClient$p(this.this$0);
                    String string = this.$work.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"work.id");
                    BackgroundTaskEntry backgroundTaskEntry = backgroundTaskInspectorClient.getEntry(string);
                    if (backgroundTaskEntry == null) break block0;
                    BackgroundTaskEntry backgroundTaskEntry2 = backgroundTaskEntry;
                    WorkDependencyGraphView workDependencyGraphView = this.this$0;
                    BackgroundTaskEntry nonNullEntry = backgroundTaskEntry2;
                    boolean bl = false;
                    WorkDependencyGraphView.access$getTab$p(workDependencyGraphView).setDetailsViewVisible(true);
                    WorkDependencyGraphView.access$getClient$p(workDependencyGraphView).getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.GRAPH_CONTEXT);
                    WorkDependencyGraphView.access$getSelectionModel$p(workDependencyGraphView).setSelectedEntry(nonNullEntry);
                }
            }
        });
        return (JLabel)label;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        for (WorkManagerInspectorProtocol.WorkInfo work : this.works) {
            void $this$mapNotNullTo$iv$iv;
            JLabel fromLabel;
            if (this.labelMap.get(work.getId()) == null) continue;
            WorkManagerInspectorProtocol.WorkInfo.State state2 = work.getState();
            Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"work.state");
            g2d.setColor(EntryFormatUtilKt.isFinished(state2) ? Color.LIGHT_GRAY : Color.WHITE);
            int fx = fromLabel.getParent().getX() + fromLabel.getBounds().x + fromLabel.getBounds().width / 2;
            int fy = fromLabel.getParent().getY() + fromLabel.getBounds().y + fromLabel.getBounds().height;
            ProtocolStringList protocolStringList = work.getDependentsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"work.dependentsList");
            Iterable $this$mapNotNull$iv = (Iterable)protocolStringList;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                JLabel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.labelMap.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (JLabel toLabel : (List)destination$iv$iv) {
                int tx = toLabel.getParent().getX() + toLabel.getBounds().x + toLabel.getBounds().width / 2;
                int ty = toLabel.getParent().getY() + toLabel.getBounds().y;
                g2d.drawLine(fx, fy, tx, ty);
            }
        }
    }

    public static final /* synthetic */ EntrySelectionModel access$getSelectionModel$p(WorkDependencyGraphView $this) {
        return $this.selectionModel;
    }

    public static final /* synthetic */ Map access$getLabelMap$p(WorkDependencyGraphView $this) {
        return $this.labelMap;
    }

    public static final /* synthetic */ BackgroundTaskInspectorClient access$getClient$p(WorkDependencyGraphView $this) {
        return $this.client;
    }

    public static final /* synthetic */ BackgroundTaskInspectorTab access$getTab$p(WorkDependencyGraphView $this) {
        return $this.tab;
    }
}

