/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.AlarmEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.JobEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WakeLockEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.intellij.icons.AllIcons;
import com.intellij.ui.AnimatedIcon;
import icons.StudioIcons;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"capitalizedName", "", "icon", "Ljavax/swing/Icon;", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo$State;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "isFinished", "", "toFormattedTimeString", "", "app-inspection.inspectors.backgroundtask.view"})
public final class EntryFormatUtilKt {
    @NotNull
    public static final String toFormattedTimeString(long $this$toFormattedTimeString) {
        String string;
        SimpleDateFormat formatter = new SimpleDateFormat("h:mm:ss a", Locale.getDefault());
        if ($this$toFormattedTimeString == -1L) {
            string = "-";
        } else {
            String string2 = formatter.format(new Date($this$toFormattedTimeString));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(Date(this))");
        }
        return string;
    }

    @NotNull
    public static final String capitalizedName(@NotNull String $this$capitalizedName) {
        Intrinsics.checkNotNullParameter((Object)$this$capitalizedName, (String)"<this>");
        String string = $this$capitalizedName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
        return StringsKt.capitalize((String)string2, (Locale)locale2);
    }

    public static final boolean isFinished(@NotNull WorkManagerInspectorProtocol.WorkInfo.State $this$isFinished) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinished, (String)"<this>");
        return $this$isFinished == WorkManagerInspectorProtocol.WorkInfo.State.SUCCEEDED || $this$isFinished == WorkManagerInspectorProtocol.WorkInfo.State.FAILED || $this$isFinished == WorkManagerInspectorProtocol.WorkInfo.State.CANCELLED;
    }

    @Nullable
    public static final Icon icon(@NotNull WorkManagerInspectorProtocol.WorkInfo.State $this$icon) {
        Intrinsics.checkNotNullParameter((Object)$this$icon, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$icon.ordinal()]) {
            case 1 -> StudioIcons.LayoutEditor.Palette.CHRONOMETER;
            case 2 -> (Icon)new AnimatedIcon.Default();
            case 3 -> AllIcons.RunConfigurations.TestPaused;
            case 4 -> AllIcons.RunConfigurations.TestIgnored;
            case 5 -> AllIcons.RunConfigurations.ToolbarError;
            case 6 -> AllIcons.RunConfigurations.TestPassed;
            default -> null;
        };
    }

    @Nullable
    public static final Icon icon(@NotNull BackgroundTaskEntry $this$icon) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)$this$icon, (String)"<this>");
        BackgroundTaskEntry backgroundTaskEntry = $this$icon;
        if (backgroundTaskEntry instanceof AlarmEntry) {
            String string = $this$icon.getStatus();
            icon2 = Intrinsics.areEqual((Object)string, (Object)AlarmEntry.State.SET.name()) ? StudioIcons.LayoutEditor.Palette.ANALOG_CLOCK : (Intrinsics.areEqual((Object)string, (Object)AlarmEntry.State.FIRED.name()) ? AllIcons.RunConfigurations.TestPassed : (Intrinsics.areEqual((Object)string, (Object)AlarmEntry.State.CANCELLED.name()) ? StudioIcons.Common.CLOSE : null));
        } else if (backgroundTaskEntry instanceof JobEntry) {
            String string = $this$icon.getStatus();
            icon2 = Intrinsics.areEqual((Object)string, (Object)JobEntry.State.SCHEDULED.name()) ? StudioIcons.LayoutEditor.Palette.ANALOG_CLOCK : (Intrinsics.areEqual((Object)string, (Object)JobEntry.State.STARTED.name()) ? (Icon)new AnimatedIcon.Default() : (Intrinsics.areEqual((Object)string, (Object)JobEntry.State.STOPPED.name()) ? AllIcons.RunConfigurations.TestIgnored : (Intrinsics.areEqual((Object)string, (Object)JobEntry.State.FINISHED.name()) ? AllIcons.RunConfigurations.TestPassed : null)));
        } else if (backgroundTaskEntry instanceof WakeLockEntry) {
            String string = $this$icon.getStatus();
            icon2 = Intrinsics.areEqual((Object)string, (Object)WakeLockEntry.State.ACQUIRED.name()) ? StudioIcons.LayoutEditor.Toolbar.LOCK : (Intrinsics.areEqual((Object)string, (Object)WakeLockEntry.State.RELEASED.name()) ? StudioIcons.LayoutEditor.Toolbar.UNLOCK : null);
        } else if (backgroundTaskEntry instanceof WorkEntry) {
            WorkManagerInspectorProtocol.WorkInfo.State state2 = ((WorkEntry)$this$icon).getWorkInfo().getState();
            Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"getWorkInfo().state");
            icon2 = EntryFormatUtilKt.icon(state2);
        } else {
            icon2 = null;
        }
        return icon2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkManagerInspectorProtocol.WorkInfo.State.values().length];
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.ENQUEUED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.BLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkInfo.State.SUCCEEDED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

