/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import backgroundtask.inspection.BackgroundTaskInspectorProtocol;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionIdeServices;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskTreeModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntrySelectionModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntryUpdateEventType;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.AlarmEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.JobEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WakeLockEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskEntriesView;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorTab;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ClassNameProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.CloseButton;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ComponentProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EnqueuedAtProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryDetailsStackTraceView;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryDetailsView;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryIdProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.IdListProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.JobConstraintProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.OutputDataProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.StateProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.StringListProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.TimeProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ToStringProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.UiComponentsProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.WorkConstraintProvider;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001eH\u0002J3\u0010'\u001a\u00020\u0001\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u0002H(2\u000e\b\u0002\u0010+\u001a\b\u0012\u0004\u0012\u0002H(0,H\u0002\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020/2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010>\u001a\u00020?H\u0002J(\u0010@\u001a\u00020/*\u0002012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u001e2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020$0\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView;", "Ljavax/swing/JPanel;", "tab", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "ideServices", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectionIdeServices;", "selectionModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "entriesView", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskEntriesView;", "uiComponentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/UiComponentsProvider;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Lcom/android/tools/idea/appinspection/inspector/api/AppInspectionIdeServices;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskEntriesView;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/UiComponentsProvider;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "entryIdProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryIdProvider;", "extraBottomPaddingMap", "", "Ljava/awt/Component;", "", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getSelectionModel", "()Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "stackTraceViews", "", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsStackTraceView;", "getStackTraceViews", "()Ljava/util/List;", "buildCategoryPanel", "name", "", "entryComponents", "Ljavax/swing/JComponent;", "buildKeyValuePair", "T", "key", "value", "componentProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ComponentProvider;", "(Ljava/lang/String;Ljava/lang/Object;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ComponentProvider;)Ljavax/swing/JPanel;", "updateSelectedAlarm", "", "detailsPanel", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "alarm", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry;", "updateSelectedJob", "jobEntry", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/JobEntry;", "updateSelectedTask", "isSelectionChanged", "", "updateSelectedWakeLock", "wakeLock", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WakeLockEntry;", "updateSelectedWork", "workEntry", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry;", "addStackTraceViews", "callStacks", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "labels", "app-inspection.inspectors.backgroundtask.view"})
@SourceDebugExtension(value={"SMAP\nEntryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntryDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,489:1\n1860#2,3:490\n1549#2:494\n1620#2,3:495\n766#2:498\n857#2,2:499\n1549#2:501\n1620#2,3:502\n1569#2,11:505\n1860#2,2:516\n1862#2:519\n1580#2:520\n1851#2,2:521\n1#3:493\n1#3:518\n*S KotlinDebug\n*F\n+ 1 EntryDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView\n*L\n200#1:490,3\n386#1:494\n386#1:495,3\n446#1:498\n446#1:499,2\n447#1:501\n447#1:502,3\n454#1:505,11\n454#1:516,2\n454#1:519\n454#1:520\n472#1:521,2\n454#1:518\n*E\n"})
public final class EntryDetailsView
extends JPanel {
    @NotNull
    private final BackgroundTaskInspectorTab tab;
    @NotNull
    private final BackgroundTaskInspectorClient client;
    @NotNull
    private final AppInspectionIdeServices ideServices;
    @NotNull
    private final EntrySelectionModel selectionModel;
    @NotNull
    private final BackgroundTaskEntriesView entriesView;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher uiDispatcher;
    @NotNull
    private final Map<Component, Integer> extraBottomPaddingMap;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final EntryIdProvider entryIdProvider;
    @VisibleForTesting
    @NotNull
    private final List<EntryDetailsStackTraceView> stackTraceViews;

    public EntryDetailsView(@NotNull BackgroundTaskInspectorTab tab, @NotNull BackgroundTaskInspectorClient client2, @NotNull AppInspectionIdeServices ideServices2, @NotNull EntrySelectionModel selectionModel, @NotNull BackgroundTaskEntriesView entriesView, @NotNull UiComponentsProvider uiComponentsProvider, @NotNull CoroutineScope scope2, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)ideServices2, (String)"ideServices");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)entriesView, (String)"entriesView");
        Intrinsics.checkNotNullParameter((Object)uiComponentsProvider, (String)"uiComponentsProvider");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.tab = tab;
        this.client = client2;
        this.ideServices = ideServices2;
        this.selectionModel = selectionModel;
        this.entriesView = entriesView;
        this.scope = scope2;
        this.uiDispatcher = uiDispatcher;
        this.extraBottomPaddingMap = new LinkedHashMap();
        this.scrollPane = new JBScrollPane();
        Object[] objectArray = new EntryDetailsStackTraceView[]{new EntryDetailsStackTraceView(uiComponentsProvider), new EntryDetailsStackTraceView(uiComponentsProvider)};
        this.stackTraceViews = CollectionsKt.listOf((Object[])objectArray);
        this.setLayout((LayoutManager)new TabularLayout("*", "28px,*"));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMinimumSize(new Dimension(400, this.getMinimumSize().height));
        JPanel headingPanel = new JPanel(new BorderLayout());
        JLabel instanceViewLabel = new JLabel("Task Details");
        instanceViewLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        headingPanel.add((Component)instanceViewLabel, "West");
        CloseButton closeButton2 = new CloseButton(new ActionListener(this){
            final /* synthetic */ EntryDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                EntryDetailsView.access$getTab$p(this.this$0).setDetailsViewVisible(false);
            }
        });
        headingPanel.add((Component)((Object)closeButton2), "East");
        this.add((Component)headingPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.scrollPane.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        this.add((Component)this.scrollPane, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.entryIdProvider = new EntryIdProvider((Function1<? super BackgroundTaskEntry, Unit>)((Function1)new Function1<BackgroundTaskEntry, Unit>(){

            public final void invoke(@NotNull BackgroundTaskEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                this.getSelectionModel().setSelectedEntry(entry);
                client.getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.DETAILS_CONTEXT);
            }
        }));
        this.selectionModel.registerEntrySelectionListener((Function1<? super BackgroundTaskEntry, Unit>)((Function1)new Function1<BackgroundTaskEntry, Unit>(){

            public final void invoke(@Nullable BackgroundTaskEntry entry) {
                if (entry == null) {
                    tab.setDetailsViewVisible(false);
                } else {
                    this.updateSelectedTask(true);
                }
            }
        }));
        this.client.addEntryUpdateEventListener((Function2<? super EntryUpdateEventType, ? super BackgroundTaskEntry, Unit>)((Function2)new Function2<EntryUpdateEventType, BackgroundTaskEntry, Unit>(){

            public final void invoke(@NotNull EntryUpdateEventType type, @NotNull BackgroundTaskEntry backgroundTaskEntry) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)backgroundTaskEntry, (String)"<anonymous parameter 1>");
                BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)uiDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(type, this, null){
                    int label;
                    final /* synthetic */ EntryUpdateEventType $type;
                    final /* synthetic */ EntryDetailsView this$0;
                    {
                        this.$type = $type;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (this.$type == EntryUpdateEventType.UPDATE || this.$type == EntryUpdateEventType.REMOVE) {
                                    this.this$0.updateSelectedTask(false);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
        this.entriesView.addContentModeChangedListener((Function1<? super BackgroundTaskEntriesView.Mode, Unit>)((Function1)new Function1<BackgroundTaskEntriesView.Mode, Unit>(){

            public final void invoke(@NotNull BackgroundTaskEntriesView.Mode it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                if (this.getSelectionModel().getSelectedEntry() instanceof WorkEntry) {
                    this.updateSelectedTask(false);
                }
            }
        }));
    }

    @NotNull
    public final EntrySelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @NotNull
    public final List<EntryDetailsStackTraceView> getStackTraceViews() {
        return this.stackTraceViews;
    }

    private final void updateSelectedTask(boolean isSelectionChanged) {
        VerticalLayout verticalLayout = new VerticalLayout(18);
        ScrollablePanel detailsPanel2 = new ScrollablePanel(verticalLayout){

            public boolean getScrollableTracksViewportWidth() {
                Container parent2 = SwingUtilities.getUnwrappedParent((Component)((Object)this));
                JViewport jViewport = parent2 instanceof JViewport ? (JViewport)parent2 : null;
                return (jViewport != null ? jViewport.getWidth() : 0) > this.getPreferredSize().width;
            }
        };
        detailsPanel2.setBorder(BorderFactory.createEmptyBorder(6, 16, 20, 30));
        BackgroundTaskEntry entry = this.selectionModel.getSelectedEntry();
        if (entry instanceof WorkEntry) {
            this.updateSelectedWork(detailsPanel2, (WorkEntry)entry);
        } else if (entry instanceof JobEntry) {
            this.updateSelectedJob(detailsPanel2, (JobEntry)entry);
        } else if (entry instanceof AlarmEntry) {
            this.updateSelectedAlarm(detailsPanel2, (AlarmEntry)entry);
        } else if (entry instanceof WakeLockEntry) {
            this.updateSelectedWakeLock(detailsPanel2, (WakeLockEntry)entry);
        }
        new TreeWalker((Component)detailsPanel2).descendantStream().forEach(updateSelectedTask.1.INSTANCE);
        detailsPanel2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        int scrollBarPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.setViewportView((Component)detailsPanel2);
        if (!isSelectionChanged) {
            this.scrollPane.getVerticalScrollBar().setValue(scrollBarPosition);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedAlarm(ScrollablePanel detailsPanel2, AlarmEntry alarm) {
        BackgroundTaskInspectorProtocol.AlarmSet alarmSet = alarm.getAlarmSet();
        if (alarmSet == null) {
            return;
        }
        BackgroundTaskInspectorProtocol.AlarmSet alarmSet2 = alarmSet;
        Object[] objectArray = new JPanel[]{EntryDetailsView.buildKeyValuePair$default(this, "Type", alarmSet2.getType(), null, 4, null)};
        List descriptions = CollectionsKt.mutableListOf((Object[])objectArray);
        if (alarmSet2.getIntervalMs() > 0L) {
            descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Interval time", StringUtil.formatDuration((long)alarmSet2.getIntervalMs()), null, 4, null));
        }
        if (alarmSet2.getTriggerMs() > 0L) {
            descriptions.add(this.buildKeyValuePair("Trigger time", alarmSet2.getTriggerMs(), TimeProvider.INSTANCE));
        }
        if (alarmSet2.getWindowMs() > 0L) {
            descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Window time", StringUtil.formatDuration((long)alarmSet2.getWindowMs()), null, 4, null));
        }
        if (alarmSet2.hasListener()) {
            descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Listener tag", alarmSet2.getListener().getTag(), null, 4, null));
        }
        if (alarmSet2.hasOperation()) {
            BackgroundTaskInspectorProtocol.PendingIntent operation = alarmSet2.getOperation();
            String string = operation.getCreatorPackage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operation.creatorPackage");
            if (((CharSequence)string).length() > 0) {
                descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Creator", operation.getCreatorPackage() + " (UID: " + operation.getCreatorUid() + ")", null, 4, null));
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", descriptions));
        Object[] objectArray2 = new JPanel[]{this.buildKeyValuePair("Time started", alarm.getStartTimeMs(), TimeProvider.INSTANCE)};
        List results2 = CollectionsKt.mutableListOf((Object[])objectArray2);
        BackgroundTaskInspectorProtocol.Event event2 = alarm.getLatestEvent();
        if (event2 != null) {
            BackgroundTaskInspectorProtocol.Event latestEvent = event2;
            boolean bl = false;
            if (latestEvent.getBackgroundTaskEvent().hasAlarmFired() || latestEvent.getBackgroundTaskEvent().hasAlarmCancelled()) {
                long completeTimeMs = latestEvent.getTimestamp();
                Iterable $this$forEachIndexed$iv = alarm.getAlarmFiredTimestamps();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void timestamp;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    long l = ((Number)item$iv).longValue();
                    int index2 = n;
                    boolean bl2 = false;
                    results2.add(alarmSet2.getIntervalMs() > 0L ? this.buildKeyValuePair("Time fired #" + (index2 + 1), (long)timestamp, TimeProvider.INSTANCE) : this.buildKeyValuePair("Time fired", (long)timestamp, TimeProvider.INSTANCE));
                }
                if (Intrinsics.areEqual((Object)alarm.getStatus(), (Object)AlarmEntry.State.CANCELLED.name())) {
                    results2.add(this.buildKeyValuePair("Time cancelled", completeTimeMs, TimeProvider.INSTANCE));
                }
                results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Elapsed time", StringUtil.formatDuration((long)(completeTimeMs - alarm.getStartTimeMs())), null, 4, null));
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        objectArray2 = new String[]{"Set", "Cancelled"};
        this.addStackTraceViews(detailsPanel2, alarm.getCallstacks(), CollectionsKt.listOf((Object[])objectArray2));
    }

    private final void updateSelectedWakeLock(ScrollablePanel detailsPanel2, WakeLockEntry wakeLock) {
        BackgroundTaskInspectorProtocol.Event event2 = wakeLock.getAcquired();
        if (event2 == null) {
            return;
        }
        BackgroundTaskInspectorProtocol.Event acquired = event2;
        BackgroundTaskInspectorProtocol.WakeLockAcquired wakeLockAcquired = acquired.getBackgroundTaskEvent().getWakeLockAcquired();
        Object[] objectArray = new JPanel[]{EntryDetailsView.buildKeyValuePair$default(this, "Tag", wakeLockAcquired.getTag(), null, 4, null), EntryDetailsView.buildKeyValuePair$default(this, "Level", wakeLockAcquired.getLevel(), null, 4, null)};
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new JPanel[]{this.buildKeyValuePair("Time started", wakeLock.getStartTimeMs(), TimeProvider.INSTANCE)};
        List results2 = CollectionsKt.mutableListOf((Object[])objectArray2);
        BackgroundTaskInspectorProtocol.Event event3 = wakeLock.getReleased();
        if (event3 != null) {
            BackgroundTaskInspectorProtocol.Event released = event3;
            boolean bl = false;
            long completeTimeMs = released.getTimestamp();
            results2.add(this.buildKeyValuePair("Time completed", completeTimeMs, TimeProvider.INSTANCE));
            results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Elapsed time", StringUtil.formatDuration((long)(completeTimeMs - wakeLock.getStartTimeMs())), null, 4, null));
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        objectArray2 = new String[]{"Acquired", "Released"};
        this.addStackTraceViews(detailsPanel2, wakeLock.getCallstacks(), CollectionsKt.listOf((Object[])objectArray2));
    }

    private final void updateSelectedJob(ScrollablePanel detailsPanel2, JobEntry jobEntry) {
        Object[] objectArray;
        BackgroundTaskInspectorProtocol.JobInfo jobInfo = jobEntry.getJobInfo();
        if (jobInfo == null) {
            return;
        }
        BackgroundTaskInspectorProtocol.JobInfo job2 = jobInfo;
        String string = job2.getServiceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"job.serviceName");
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object)this.buildKeyValuePair("Service", string, new ClassNameProvider(this.ideServices, this.client.getScope(), this.client.getTracker())))));
        Object object = new JPanel[]{this.buildKeyValuePair("Constraints", job2, JobConstraintProvider.INSTANCE), EntryDetailsView.buildKeyValuePair$default(this, "Frequency", job2.getIsPeriodic() ? "Periodic" : "OneTime", null, 4, null), this.buildKeyValuePair("State", jobEntry, StateProvider.INSTANCE)};
        List executions = CollectionsKt.mutableListOf((Object[])object);
        object = jobEntry.getTargetWorkId();
        if (object != null) {
            Object id2 = object;
            boolean bl = false;
            objectArray = this.client.getEntry((String)id2);
            if (objectArray != null) {
                Object[] workEntry = objectArray;
                boolean bl2 = false;
                executions.add(this.buildKeyValuePair("Related Worker", workEntry, this.entryIdProvider));
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Execution", executions));
        objectArray = new JPanel[]{this.buildKeyValuePair("Time started", jobEntry.getStartTimeMs(), TimeProvider.INSTANCE)};
        List results2 = CollectionsKt.mutableListOf((Object[])objectArray);
        BackgroundTaskInspectorProtocol.Event event2 = jobEntry.getLatestEvent();
        if (event2 != null) {
            BackgroundTaskInspectorProtocol.Event latestEvent = event2;
            boolean bl = false;
            if (latestEvent.getBackgroundTaskEvent().hasJobStopped() || latestEvent.getBackgroundTaskEvent().hasJobFinished()) {
                long completeTimeMs = latestEvent.getTimestamp();
                results2.add(this.buildKeyValuePair("Time completed", completeTimeMs, TimeProvider.INSTANCE));
                results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Elapsed time", StringUtil.formatDuration((long)(completeTimeMs - jobEntry.getStartTimeMs())), null, 4, null));
                if (latestEvent.getBackgroundTaskEvent().hasJobFinished()) {
                    results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Needs reschedule", latestEvent.getBackgroundTaskEvent().getJobFinished().getNeedsReschedule(), null, 4, null));
                }
                if (latestEvent.getBackgroundTaskEvent().hasJobStopped()) {
                    results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Reschedule", latestEvent.getBackgroundTaskEvent().getJobStopped().getReschedule(), null, 4, null));
                }
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        objectArray = new String[]{"Scheduled", "Finished"};
        this.addStackTraceViews(detailsPanel2, jobEntry.getCallstacks(), CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedWork(ScrollablePanel detailsPanel2, WorkEntry workEntry) {
        Object jobEntry;
        WorkManagerInspectorProtocol.WorkInfo work = workEntry.getWorkInfo();
        IdListProvider idListProvider2 = new IdListProvider(this.client, work, (Function1<? super WorkEntry, Unit>)((Function1)new Function1<WorkEntry, Unit>(this){
            final /* synthetic */ EntryDetailsView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull WorkEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getSelectionModel().setSelectedEntry(it);
                EntryDetailsView.access$getClient$p(this.this$0).getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.DETAILS_CONTEXT);
            }
        }));
        Object[] objectArray = new JPanel[3];
        String string = work.getWorkerClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"work.workerClassName");
        objectArray[0] = this.buildKeyValuePair("Class", string, new ClassNameProvider(this.ideServices, this.client.getScope(), this.client.getTracker()));
        ProtocolStringList protocolStringList = work.getTagsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"work.tagsList");
        objectArray[1] = this.buildKeyValuePair("Tags", CollectionsKt.toList((Iterable)((Iterable)protocolStringList)), StringListProvider.INSTANCE);
        objectArray[2] = EntryDetailsView.buildKeyValuePair$default(this, "UUID", work.getId(), null, 4, null);
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new JPanel[4];
        WorkManagerInspectorProtocol.CallStack callStack = work.getCallStack();
        Intrinsics.checkNotNullExpressionValue((Object)callStack, (String)"work.callStack");
        objectArray2[0] = this.buildKeyValuePair("Enqueued by", callStack, new EnqueuedAtProvider(this.ideServices, this.client.getScope(), this.client.getTracker()));
        WorkManagerInspectorProtocol.Constraints constraints = work.getConstraints();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"work.constraints");
        objectArray2[1] = this.buildKeyValuePair("Constraints", constraints, WorkConstraintProvider.INSTANCE);
        objectArray2[2] = EntryDetailsView.buildKeyValuePair$default(this, "Frequency", work.getIsPeriodic() ? "Periodic" : "OneTime", null, 4, null);
        objectArray2[3] = this.buildKeyValuePair("State", workEntry, StateProvider.INSTANCE);
        List executions = CollectionsKt.mutableListOf((Object[])objectArray2);
        BackgroundTaskTreeModel backgroundTaskTreeModel = this.entriesView.getTableView().getTreeModel();
        String string2 = work.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"work.id");
        JobEntry jobEntry2 = backgroundTaskTreeModel.getJobUnderWork(string2);
        if (jobEntry2 != null) {
            jobEntry = jobEntry2;
            boolean bl = false;
            executions.add(this.buildKeyValuePair("Related Job", jobEntry, this.entryIdProvider));
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Execution", executions));
        if (workEntry.isValid()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$updateSelectedWork_u24lambda_u248;
            Object $this$updateSelectedWork_u24lambda_u247;
            ActionLink switchContentModeLabel2 = this.entriesView.getContentMode() == BackgroundTaskEntriesView.Mode.TABLE ? new ActionLink("Show in graph", (Function1)new Function1<ActionEvent, Unit>(this){
                final /* synthetic */ EntryDetailsView this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EntryDetailsView.access$getEntriesView$p(this.this$0).setContentMode(BackgroundTaskEntriesView.Mode.GRAPH);
                }
            }) : new ActionLink("Show in table", (Function1)new Function1<ActionEvent, Unit>(this){
                final /* synthetic */ EntryDetailsView this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EntryDetailsView.access$getEntriesView$p(this.this$0).setContentMode(BackgroundTaskEntriesView.Mode.TABLE);
                }
            });
            Object[] objectArray3 = new Object[4];
            jobEntry = switchContentModeLabel2;
            JobEntry bl = jobEntry;
            int n = 0;
            Object[] objectArray4 = objectArray3;
            String string3 = "WorkContinuation";
            EntryDetailsView entryDetailsView = this;
            ScrollablePanel scrollablePanel = detailsPanel2;
            boolean bl2 = false;
            this.extraBottomPaddingMap.put((Component)$this$updateSelectedWork_u24lambda_u247, 10);
            Object object = Unit.INSTANCE;
            objectArray4[n] = jobEntry;
            ProtocolStringList protocolStringList2 = work.getPrerequisitesList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"work.prerequisitesList");
            objectArray3[1] = this.buildKeyValuePair("Previous", CollectionsKt.toList((Iterable)((Iterable)protocolStringList2)), idListProvider2);
            ProtocolStringList protocolStringList3 = work.getDependentsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList3, (String)"work.dependentsList");
            $this$updateSelectedWork_u24lambda_u247 = jobEntry = this.buildKeyValuePair("Next", CollectionsKt.toList((Iterable)((Iterable)protocolStringList3)), idListProvider2);
            n = 2;
            objectArray4 = objectArray3;
            boolean $i$a$-apply-EntryDetailsView$updateSelectedWork$42 = false;
            this.extraBottomPaddingMap.put((Component)$this$updateSelectedWork_u24lambda_u248, 14);
            object = Unit.INSTANCE;
            objectArray4[n] = jobEntry;
            String string4 = work.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"work.id");
            jobEntry = this.client.getOrderedWorkChain(string4);
            String string5 = "Unique work chain";
            object = this;
            n = 3;
            objectArray4 = objectArray3;
            boolean $i$f$map = false;
            void $i$a$-apply-EntryDetailsView$updateSelectedWork$42 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WorkManagerInspectorProtocol.WorkInfo workInfo = (WorkManagerInspectorProtocol.WorkInfo)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.getId());
            }
            collection2 = (List)destination$iv$iv;
            objectArray4[n] = super.buildKeyValuePair(string5, collection2, idListProvider2);
            scrollablePanel.add((Component)entryDetailsView.buildCategoryPanel(string3, CollectionsKt.listOf((Object[])objectArray3)));
        }
        objectArray2 = new JPanel[]{this.buildKeyValuePair("Time started", work.getScheduleRequestedAt(), TimeProvider.INSTANCE), EntryDetailsView.buildKeyValuePair$default(this, "Retries", work.getRunAttemptCount(), null, 4, null), this.buildKeyValuePair("Output data", work, OutputDataProvider.INSTANCE)};
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", CollectionsKt.listOf((Object[])objectArray2)));
    }

    private final JPanel buildCategoryPanel(String name2, List<? extends JComponent> entryComponents) {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(6));
        TitledSeparator headingPanel = new TitledSeparator(name2);
        headingPanel.setMinimumSize(new Dimension(0, 34));
        panel2.add((Component)headingPanel);
        for (JComponent jComponent : entryComponents) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 18, ((Number)this.extraBottomPaddingMap.getOrDefault(jComponent, 0)).intValue(), 0));
            panel2.add(jComponent);
        }
        return panel2;
    }

    private final <T> JPanel buildKeyValuePair(String key, T value2, ComponentProvider<T> componentProvider) {
        JPanel jPanel;
        JPanel $this$buildKeyValuePair_u24lambda_u2410 = jPanel = new JPanel((LayoutManager)new TabularLayout("155px,*"));
        boolean bl = false;
        $this$buildKeyValuePair_u24lambda_u2410.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel panel2 = jPanel;
        JPanel keyPanel = new JPanel(new BorderLayout());
        keyPanel.add((Component)new JBLabel(key), "North");
        panel2.add((Component)keyPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        panel2.add((Component)componentProvider.convert(value2), new TabularLayout.Constraint(0, 1, 0, 4, null));
        return panel2;
    }

    static /* synthetic */ JPanel buildKeyValuePair$default(EntryDetailsView entryDetailsView, String string, Object object, ComponentProvider componentProvider, int n, Object object2) {
        if ((n & 4) != 0) {
            componentProvider = new ToStringProvider();
        }
        return entryDetailsView.buildKeyValuePair(string, object, componentProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStackTraceViews(ScrollablePanel $this$addStackTraceViews, List<BackgroundTaskCallStack> callStacks, List<String> labels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = CollectionsKt.zip((Iterable)labels, (Iterable)callStacks);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((BackgroundTaskCallStack)it.getSecond()).getStack()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)(new SimpleDateFormat("H:mm:ss.SSS", Locale.getDefault()).format(((BackgroundTaskCallStack)it.getSecond()).getTriggerTime()) + " " + it.getFirst()), (Object)((BackgroundTaskCallStack)it.getSecond()).getStack()));
        }
        List labelsToStackTraces = (List)destination$iv$iv;
        if (!((Collection)labelsToStackTraces).isEmpty()) {
            void $this$mapIndexedNotNullTo$iv$iv;
            Iterable $this$mapIndexedNotNull$iv = labelsToStackTraces;
            boolean $i$f$mapIndexedNotNull = false;
            destination$iv$iv = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                HideablePanel hideablePanel;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                int i = index$iv$iv;
                boolean bl3 = false;
                switch (i) {
                    case 0: 
                    case 1: {
                        HideablePanel hideablePanel2;
                        void pair2;
                        this.stackTraceViews.get(i).updateTrace((String)pair2.getSecond());
                        Intrinsics.checkNotNullExpressionValue((Object)new HideablePanel.Builder((String)pair2.getFirst(), this.stackTraceViews.get(i).getComponent()).setContentBorder((Border)new JBEmptyBorder(5, 0, 0, 0)).setPanelBorder((Border)new JBEmptyBorder(0, 0, 0, 0)).setTitleRightPadding(0).build(), (String)"Builder(pair.first, stac\u2026                 .build()");
                        hideablePanel = hideablePanel2;
                        break;
                    }
                    default: {
                        hideablePanel = null;
                    }
                }
                if (hideablePanel == null) continue;
                HideablePanel it$iv$iv = hideablePanel;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List stackTraceComponents = (List)destination$iv$iv2;
            JPanel containerPanel = new JPanel((LayoutManager)new VerticalLayout(6));
            Iterable $this$forEach$iv = stackTraceComponents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HideablePanel it2 = (HideablePanel)element$iv;
                boolean bl = false;
                containerPanel.add((Component)it2);
            }
            $this$addStackTraceViews.add((Component)this.buildCategoryPanel("Callstacks", CollectionsKt.listOf((Object)containerPanel)));
        }
    }

    public static final /* synthetic */ BackgroundTaskEntriesView access$getEntriesView$p(EntryDetailsView $this) {
        return $this.entriesView;
    }
}

