/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EventWrapper;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.protobuf.ProtocolStringList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\"\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00030\u00030\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u0016\u0010\u001f\u001a\n \u001d*\u0004\u0018\u00010 0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "id", "", "(Ljava/lang/String;)V", "_isValid", "", "callstacks", "", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "getCallstacks", "()Ljava/util/List;", "className", "getClassName", "()Ljava/lang/String;", "getId", "isValid", "()Z", "retries", "", "getRetries", "()I", "startTimeMs", "", "getStartTimeMs", "()J", "status", "getStatus", "tags", "kotlin.jvm.PlatformType", "getTags", "work", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo$Builder;", "consume", "", "eventWrapper", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EventWrapper;", "getWorkInfo", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo;", "app-inspection.inspectors.backgroundtask.model"})
@SourceDebugExtension(value={"SMAP\nWorkEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkEntry.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class WorkEntry
implements BackgroundTaskEntry {
    @NotNull
    private final String id;
    private boolean _isValid;
    @NotNull
    private final List<BackgroundTaskCallStack> callstacks;
    private WorkManagerInspectorProtocol.WorkInfo.Builder work;

    public WorkEntry(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
        this.callstacks = CollectionsKt.emptyList();
        this.work = WorkManagerInspectorProtocol.WorkInfo.newBuilder();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.work.getWorkerClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"work.workerClassName");
        return StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
    }

    @Override
    @NotNull
    public String getStatus() {
        return this.work.getState().name();
    }

    @Override
    public long getStartTimeMs() {
        return this.work.getScheduleRequestedAt();
    }

    @Override
    @NotNull
    public List<String> getTags() {
        ProtocolStringList protocolStringList = this.work.getTagsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"work.tagsList");
        return CollectionsKt.toList((Iterable)((Iterable)protocolStringList));
    }

    @Override
    @NotNull
    public List<BackgroundTaskCallStack> getCallstacks() {
        return this.callstacks;
    }

    @Override
    public int getRetries() {
        Integer n = this.work.getRunAttemptCount() - 1;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        return n2 != null ? n2 : 0;
    }

    @NotNull
    public final WorkManagerInspectorProtocol.WorkInfo getWorkInfo() {
        WorkManagerInspectorProtocol.WorkInfo workInfo = this.work.build();
        Intrinsics.checkNotNull((Object)workInfo);
        return workInfo;
    }

    @Override
    public void consume(@NotNull EventWrapper eventWrapper) {
        Intrinsics.checkNotNullParameter((Object)eventWrapper, (String)"eventWrapper");
        WorkManagerInspectorProtocol.Event event2 = eventWrapper.getWorkEvent();
        WorkManagerInspectorProtocol.Event.OneOfCase oneOfCase = event2.getOneOfCase();
        block0 : switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oneOfCase.ordinal()]) {
            case 1: {
                this.work = event2.getWorkAdded().getWork().toBuilder();
                this._isValid = true;
                break;
            }
            case 2: {
                WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase oneOfCase2 = event2.getWorkUpdated().getOneOfCase();
                Intrinsics.checkNotNull((Object)oneOfCase2);
                switch (WhenMappings.$EnumSwitchMapping$0[oneOfCase2.ordinal()]) {
                    case 1: {
                        this.work.setState(event2.getWorkUpdated().getState());
                        break block0;
                    }
                    case 2: {
                        this.work.setScheduleRequestedAt(event2.getWorkUpdated().getScheduleRequestedAt());
                        break block0;
                    }
                    case 3: {
                        this.work.setData(event2.getWorkUpdated().getData());
                        break block0;
                    }
                    case 4: {
                        this.work.setRunAttemptCount(event2.getWorkUpdated().getRunAttemptCount());
                        break block0;
                    }
                }
                throw new RuntimeException();
            }
            case 3: {
                this._isValid = false;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.values().length];
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.STATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.SCHEDULE_REQUESTED_AT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.RUN_ATTEMPT_COUNT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WorkManagerInspectorProtocol.Event.OneOfCase.values().length];
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

