/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.ui;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.appinspection.ide.model.AppInspectionBundle;
import com.android.tools.idea.appinspection.ide.ui.AppInspectionLaunchTask;
import com.android.tools.idea.appinspection.ide.ui.AppInspectionLaunchTaskContributor;
import com.android.tools.idea.appinspection.ide.ui.RecentProcess;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/appinspection/ide/ui/AppInspectionLaunchTaskContributor;", "Lcom/android/tools/idea/run/AndroidLaunchTaskContributor;", "()V", "getTask", "Lcom/android/tools/idea/appinspection/ide/ui/AppInspectionLaunchTask;", "applicationId", "", "configuration", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "device", "Lcom/android/ddmlib/IDevice;", "executor", "Lcom/intellij/execution/Executor;", "app-inspection.ide"})
public final class AppInspectionLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    @Override
    @NotNull
    public AppInspectionLaunchTask getTask(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration, @NotNull IDevice device2, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        return new AppInspectionLaunchTask(configuration, applicationId2){
            @NotNull
            private final Project project;
            final /* synthetic */ String $applicationId;
            {
                this.$applicationId = $applicationId;
                Project project = $configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
                this.project = project;
            }

            @NotNull
            public String getId() {
                return "App Inspection";
            }

            @NotNull
            public String getDescription() {
                return AppInspectionBundle.INSTANCE.message("launch.app.inspection.tool.window", new String[0]);
            }

            public int getDuration() {
                return 2;
            }

            public void run(@NotNull LaunchContext launchContext) {
                Intrinsics.checkNotNullParameter((Object)launchContext, (String)"launchContext");
                IDevice iDevice = launchContext.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"launchContext.device");
                this.storeRecentProcess(iDevice, launchContext.getEnv().getExecutionId());
                IDevice iDevice2 = launchContext.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)iDevice2, (String)"launchContext.device");
                this.displayStripeButton(iDevice2);
            }

            private final void displayStripeButton(IDevice device2) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this, device2){
                    final /* synthetic */ getTask.1 this$0;
                    final /* synthetic */ IDevice $device;
                    {
                        this.this$0 = $receiver;
                        this.$device = $device;
                    }

                    public final void run() {
                        ToolWindow window2 = ToolWindowManagerEx.Companion.getInstanceEx(getTask.1.access$getProject$p(this.this$0)).getToolWindow(this.this$0.getId());
                        if (window2 != null && this.$device.getVersion().isGreaterOrEqualThan(26)) {
                            window2.setShowStripeButton(true);
                        }
                    }
                });
            }

            private final void storeRecentProcess(IDevice device2, long executionId) {
                Disposable disposable2 = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable()");
                Disposable disposable3 = disposable2;
                Disposer.register((Disposable)((Disposable)this.project), (Disposable)disposable3);
                this.project.getMessageBus().connect(disposable3).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(executionId, disposable3, device2, this.$applicationId, this){
                    final /* synthetic */ long $executionId;
                    final /* synthetic */ Disposable $disposable;
                    final /* synthetic */ IDevice $device;
                    final /* synthetic */ String $applicationId;
                    final /* synthetic */ getTask.1 this$0;
                    {
                        this.$executionId = $executionId;
                        this.$disposable = $disposable;
                        this.$device = $device;
                        this.$applicationId = $applicationId;
                        this.this$0 = $receiver;
                    }

                    public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                        if (env.getExecutionId() != this.$executionId) {
                            return;
                        }
                        Disposer.dispose((Disposable)this.$disposable);
                    }

                    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                        if (env.getExecutionId() != this.$executionId) {
                            return;
                        }
                        RecentProcess recentProcess = new RecentProcess(this.$device, this.$applicationId);
                        RecentProcess.Companion.set(getTask.1.access$getProject$p(this.this$0), recentProcess);
                        handler2.addProcessListener((ProcessListener)new ProcessAdapter(recentProcess, this.this$0){
                            final /* synthetic */ RecentProcess $recentProcess;
                            final /* synthetic */ getTask.1 this$0;
                            {
                                this.$recentProcess = $recentProcess;
                                this.this$0 = $receiver;
                            }

                            public void processWillTerminate(@NotNull ProcessEvent event2, boolean willBeDestroyed) {
                                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                                if (this.$recentProcess == RecentProcess.Companion.get(getTask.1.access$getProject$p(this.this$0))) {
                                    RecentProcess.Companion.set(getTask.1.access$getProject$p(this.this$0), null);
                                }
                            }
                        });
                    }
                });
            }

            public static final /* synthetic */ Project access$getProject$p(getTask.1 $this) {
                return $this.project;
            }
        };
    }
}

