/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.ApkDiffEntry;
import com.android.tools.apk.analyzer.internal.ApkDiffParser;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import com.android.tools.apk.analyzer.internal.ApkFileByFileDiffParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkDiffPanel {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private ListenableFuture<DefaultMutableTreeNode> myFbfTreeStructureFuture;
    private JPanel myContainer;
    private JComponent myColumnTreePane;
    private JCheckBox myCalculateFileByFileCheckBox;
    private final VirtualFile myOldApk;
    private final VirtualFile myNewApk;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    private static final int TEXT_RENDERER_VERT_PADDING = 4;

    public ApkDiffPanel(VirtualFile oldApk, VirtualFile newApk) {
        this.myOldApk = oldApk;
        this.myNewApk = newApk;
        this.$$$setupUI$$$();
        this.myCalculateFileByFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ApkDiffPanel.this.myCalculateFileByFileCheckBox.isSelected()) {
                    ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(false);
                    ApkDiffPanel.this.constructFbfTree();
                } else {
                    ApkDiffPanel.this.constructDiffTree();
                }
            }
        });
        this.constructDiffTree();
    }

    private void constructFbfTree() {
        if (this.myFbfTreeStructureFuture == null) {
            this.myFbfTreeStructureFuture = ourExecutorService.submit(() -> {
                try (ArchiveContext archiveContext1 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myOldApk).toPath());){
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    block12: {
                        ArchiveContext archiveContext2 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewApk).toPath());
                        try {
                            defaultMutableTreeNode = ApkFileByFileDiffParser.createTreeNode((ArchiveContext)archiveContext1, (ArchiveContext)archiveContext2);
                            if (archiveContext2 == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (archiveContext2 != null) {
                                try {
                                    archiveContext2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        archiveContext2.close();
                    }
                    return defaultMutableTreeNode;
                }
            });
        }
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result2) {
                ApkDiffPanel.this.setRootNode(result2);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }
        };
        Futures.addCallback(this.myFbfTreeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutorService.getInstance());
    }

    private void constructDiffTree() {
        ListenableFuture treeStructureFuture = ourExecutorService.submit(() -> {
            try (ArchiveContext archiveContext1 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myOldApk).toPath());){
                DefaultMutableTreeNode defaultMutableTreeNode;
                block12: {
                    ArchiveContext archiveContext2 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewApk).toPath());
                    try {
                        defaultMutableTreeNode = ApkDiffParser.createTreeNode((ArchiveContext)archiveContext1, (ArchiveContext)archiveContext2);
                        if (archiveContext2 == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (archiveContext2 != null) {
                            try {
                                archiveContext2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    archiveContext2.close();
                }
                return defaultMutableTreeNode;
            }
        });
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result2) {
                ApkDiffPanel.this.setRootNode(result2);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }
        };
        Futures.addCallback((ListenableFuture)treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutorService.getInstance());
    }

    private void createUIComponents() {
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        Convertor<TreePath, String> convertor = new Convertor<TreePath, String>(){

            public String convert(TreePath path2) {
                ApkEntry e = ApkEntry.fromNode((Object)path2.getLastPathComponent());
                if (e == null) {
                    return null;
                }
                return e.getPath().toString();
            }
        };
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)this.myTree, true, convertor.asFunction());
        ColumnTreeBuilder builder2 = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Old Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getOldSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("New Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkDiffEntry::getNewSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Diff Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((Function<ApkEntry, Long>)((Function)ApkEntry::getSize))));
        this.myColumnTreePane = builder2.build();
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private void setRootNode(@NotNull DefaultMutableTreeNode root) {
        this.myTreeModel = new DefaultTreeModel(root);
        ApkEntry entry = ApkEntry.fromNode((Object)root);
        assert (entry != null);
        this.myTree.setPaintBusy(false);
        this.myTree.setRootVisible(true);
        this.myTree.expandPath(new TreePath(root));
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComponent jComponent = this.myColumnTreePane;
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(400, -1), new Dimension(400, 300), null));
        this.myCalculateFileByFileCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setText("Show File-By-File patch size (may take a long time)");
        jCheckBox.setToolTipText("This is a size estimation for the update that Play store sends to the device");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    static class NameRenderer
    extends ColoredTreeCellRenderer {
        NameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value2);
            ApkEntry root = ApkEntry.fromNode((Object)tree2.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(entry.getName());
        }
    }

    public static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private Function<ApkEntry, Long> mySizeMapper;

        public SizeRenderer(Function<ApkEntry, Long> sizeMapper) {
            this.mySizeMapper = sizeMapper;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value2);
            ApkEntry root = ApkEntry.fromNode((Object)tree2.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(HumanReadableUtil.getHumanizedSize((long)((Long)this.mySizeMapper.fun((Object)entry))));
        }
    }
}

