/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.ArtProfileKt;
import com.android.tools.profgen.DexDataKt;
import com.android.tools.profgen.ObfuscationMap;
import com.android.tools.profgen.ProfileDumperKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;

public class BaselineProfilePrettyPrinter {
    public static String prettyPrint(VirtualFile apkFile, Path p, byte[] content2) throws IOException {
        return BaselineProfilePrettyPrinter.prettyPrint(apkFile.contentsToByteArray(), p, content2);
    }

    public static String prettyPrint(byte[] apkContent, Path p, byte[] content2) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(content2);
        ArtProfile profile2 = ArtProfileKt.ArtProfile(stream);
        if (profile2 != null) {
            ObfuscationMap obfuscationMap = ObfuscationMap.Companion.getEmpty();
            StringBuilder sb = new StringBuilder();
            try {
                Apk apk = DexDataKt.Apk(apkContent, p.getFileName().toString());
                ProfileDumperKt.dumpProfile(sb, profile2, apk, obfuscationMap, false);
                return sb.toString();
            }
            catch (Throwable t) {
                throw new IOException("Error decoding baseline profile entry \"" + p + "\" from archive:\n" + t.getMessage());
            }
        }
        return "";
    }
}

