/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApkVirtualFile {
    private ApkVirtualFile() {
    }

    @Nullable
    public static VirtualFile create(@NotNull Path path2, @NotNull byte[] content2) {
        Path fileName = path2.getFileName();
        if (fileName == null) {
            return null;
        }
        final Path parent2 = path2.getParent();
        boolean isBinary = true;
        if (path2.toString().matches("/META-INF/.*\\.version")) {
            isBinary = false;
        }
        if (isBinary) {
            return new BinaryLightVirtualFile(fileName.toString(), content2){

                public VirtualFile getParent() {
                    return ApkVirtualFolder.getDirectory(parent2);
                }
            };
        }
        return ApkVirtualFile.createText(path2, new String(content2, StandardCharsets.UTF_8));
    }

    @Nullable
    public static VirtualFile createText(@NotNull Path path2, @NotNull String content2) {
        Path fileName = path2.getFileName();
        if (fileName == null) {
            return null;
        }
        final Path parent2 = path2.getParent();
        return new LightVirtualFile(fileName.toString(), content2){

            public VirtualFile getParent() {
                return ApkVirtualFolder.getDirectory(parent2);
            }
        };
    }
}

