/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveErrorEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.ApkArchive;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.apk.analyzer.internal.InstantAppBundleArchive;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.PercentRenderer;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkAnalyzerStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkViewPanel
implements TreeSelectionListener {
    private JPanel myContainer;
    private JComponent myColumnTreePane;
    private SimpleColoredComponent myNameComponent;
    private SimpleColoredComponent mySizeComponent;
    private AnimatedIcon myNameAsyncIcon;
    private AnimatedIcon mySizeAsyncIcon;
    private JButton myCompareWithButton;
    private Tree myTree;
    private Project myProject;
    private DefaultTreeModel myTreeModel;
    private Listener myListener;
    @NotNull
    private final ApkParser myApkParser;
    private boolean myArchiveDisposed = false;
    private static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    private static final int TEXT_RENDERER_VERT_PADDING = 4;

    public ApkViewPanel(@NotNull Project project, @NotNull ApkParser apkParser) {
        this.myApkParser = apkParser;
        this.myProject = project;
        this.$$$setupUI$$$();
        Futures.addCallback(apkParser.constructTreeStructure(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setRootNode(result2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        Futures.addCallback(apkParser.updateTreeWithDownloadSizes(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ArchiveTreeStructure.sort((ArchiveNode)result2, (o1, o2) -> Longs.compare((long)o2.getData().getDownloadFileSize(), (long)o1.getData().getDownloadFileSize()));
                ApkViewPanel.this.refreshTree();
            }
        }, (Executor)EdtExecutorService.getInstance());
        this.myContainer.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myCompareWithButton.addActionListener(e -> {
            if (this.myListener != null) {
                this.myListener.selectApkAndCompare();
            }
        });
        this.myNameAsyncIcon.setVisible(true);
        this.myNameComponent.append("Parsing Manifest");
        Path pathToAapt = ProjectSystemUtil.getProjectSystem(this.myProject).getPathToAapt();
        ListenableFuture applicationInfo = Futures.transformAsync(apkParser.constructTreeStructure(), input2 -> {
            assert (input2 != null);
            ArchiveEntry entry = Archives.getFirstManifestArchiveEntry((ArchiveNode)input2);
            return apkParser.getApplicationInfo(pathToAapt, entry);
        }, (Executor)PooledThreadExecutor.INSTANCE);
        Futures.addCallback((ListenableFuture)applicationInfo, (FutureCallback)new FutureCallBackAdapter<AndroidApplicationInfo>(){

            @Override
            public void onSuccess(AndroidApplicationInfo result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setAppInfo(result2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        this.mySizeAsyncIcon.setVisible(true);
        this.mySizeComponent.append("Estimating download size..");
        ListenableFuture<Long> uncompressedApkSize = apkParser.getUncompressedApkSize();
        ListenableFuture<Long> compressedFullApkSize = apkParser.getCompressedFullApkSize();
        Futures.addCallback((ListenableFuture)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize}), (FutureCallback)new FutureCallBackAdapter<List<Long>>(){

            @Override
            public void onSuccess(List<Long> result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                if (result2 != null) {
                    long uncompressed = result2.get(0);
                    Long compressed = result2.get(1);
                    ApkViewPanel.this.setApkSizes(uncompressed, compressed == null ? 0L : compressed);
                }
            }
        }, (Executor)EdtExecutorService.getInstance());
        Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize, applicationInfo}), (FutureCallback)new FutureCallBackAdapter<List<Object>>(){

            @Override
            public void onSuccess(@Nullable List<Object> result2) {
                if (result2 == null) {
                    return;
                }
                int size = result2.size();
                long uncompressed = size > 0 && result2.get(0) instanceof Long ? (Long)result2.get(0) : -1L;
                long compressed = size > 1 && result2.get(1) instanceof Long ? (Long)result2.get(1) : -1L;
                String applicationId2 = size > 2 && result2.get(2) instanceof AndroidApplicationInfo ? ((AndroidApplicationInfo)result2.get((int)2)).packageId : "unknown";
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APK_ANALYZER_STATS).setProjectId(AnonymizerUtil.anonymizeUtf8((String)applicationId2)).setRawProjectId(applicationId2).setApkAnalyzerStats(ApkAnalyzerStats.newBuilder().setCompressedSize(compressed).setUncompressedSize(uncompressed).build()));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void createUIComponents() {
        this.myNameAsyncIcon = new AsyncProcessIcon("aapt xmltree manifest");
        this.mySizeAsyncIcon = new AsyncProcessIcon("estimating apk size");
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)this.myTree, true, path2 -> {
            Object lastPathComponent = path2.getLastPathComponent();
            if (!(lastPathComponent instanceof ArchiveTreeNode)) {
                return null;
            }
            return ((ArchiveTreeNode)lastPathComponent).getData().getPath().toString();
        });
        PercentRenderer.PercentProvider percentProvider = (jTree, value2, row2) -> {
            if (!(value2 instanceof ArchiveTreeNode)) {
                return 0.0;
            }
            ArchiveTreeNode entry = (ArchiveTreeNode)value2;
            ArchiveTreeNode rootEntry = (ArchiveTreeNode)jTree.getModel().getRoot();
            if (entry.getData().getDownloadFileSize() < 0L) {
                return 0.0;
            }
            return (double)entry.getData().getDownloadFileSize() / (double)rootEntry.getData().getDownloadFileSize();
        };
        ColumnTreeBuilder builder2 = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Raw File Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Download Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("% of Total Download Size").setPreferredWidth(150).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new PercentRenderer(percentProvider)));
        this.myColumnTreePane = builder2.build();
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void setListener(@NotNull Listener listener2) {
        this.myListener = listener2;
    }

    public void clearArchive() {
        this.myArchiveDisposed = true;
        this.myApkParser.cancelAll();
        this.setRootNode(null);
        Logger.getInstance(ApkViewPanel.class).info("Cleared Archive on ApkViewPanel: " + this);
    }

    private void setRootNode(@Nullable ArchiveNode root) {
        this.myTreeModel = new DefaultTreeModel((TreeNode)root);
        if (root != null) {
            this.myTree.setPaintBusy(root.getData().getDownloadFileSize() < 0L);
        }
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private void refreshTree() {
        this.myTree.setPaintBusy(false);
        this.myTree.removeTreeSelectionListener((TreeSelectionListener)this);
        TreePath[] selected = this.myTree.getSelectionPaths();
        this.myTreeModel.reload();
        this.myTree.setSelectionPaths(selected);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private void setApkSizes(long uncompressed, long compressedFullApk) {
        this.mySizeComponent.clear();
        if (this.mySizeAsyncIcon != null) {
            this.mySizeAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.mySizeAsyncIcon);
            this.mySizeAsyncIcon = null;
        }
        this.mySizeComponent.setIcon(AllIcons.General.BalloonInformation);
        if (this.myApkParser.getArchive() instanceof ApkArchive) {
            this.mySizeComponent.append("APK size: ");
            this.mySizeComponent.append(HumanReadableUtil.getHumanizedSize((long)uncompressed), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.mySizeComponent.append(", Download Size: ");
            this.mySizeComponent.setToolTipText("1. The <b>APK size</b> reflects the actual size of the file, and is the minimum amount of space it will consume on the disk after installation.\n2. The <b>download size</b> is the estimated size of the file for new installations (Google Play serves a highly compressed version of the file).\nFor application updates, Google Play serves patches that are typically much smaller.\nThe installation size may be higher than the APK size depending on various other factors.");
        } else if (this.myApkParser.getArchive() instanceof InstantAppBundleArchive) {
            this.mySizeComponent.append("Zip file size: ");
            this.mySizeComponent.setToolTipText("The <b>zip file size</b> reflects the actual size of the zip file on disk.\n");
        } else {
            this.mySizeComponent.append("Raw File Size: ");
        }
        this.mySizeComponent.append(HumanReadableUtil.getHumanizedSize((long)compressedFullApk), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private void setAppInfo(@NotNull AndroidApplicationInfo appInfo) {
        this.myNameComponent.clear();
        if (this.myNameAsyncIcon != null) {
            this.myNameAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myNameAsyncIcon);
            this.myNameAsyncIcon = null;
        }
        this.myNameComponent.append(appInfo.packageId, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myNameComponent.append(" (Version Name: ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(appInfo.versionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(", Version Code: ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(String.valueOf(appInfo.versionCode), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.myListener != null) {
            ArchiveTreeNode[] components;
            TreePath[] paths = ((Tree)e.getSource()).getSelectionPaths();
            if (paths == null) {
                components = null;
            } else {
                components = new ArchiveTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    if (!(paths[i].getLastPathComponent() instanceof ArchiveTreeNode)) {
                        this.myListener.selectionChanged(null);
                        return;
                    }
                    components[i] = (ArchiveTreeNode)paths[i].getLastPathComponent();
                }
            }
            this.myListener.selectionChanged(components);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JComponent jComponent = this.myColumnTreePane;
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myNameComponent = simpleColoredComponent2 = new SimpleColoredComponent();
        Component component2 = jPanel2.add((Component)simpleColoredComponent2);
        AnimatedIcon animatedIcon = this.myNameAsyncIcon;
        Component component3 = jPanel2.add((Component)animatedIcon);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.mySizeComponent = simpleColoredComponent = new SimpleColoredComponent();
        Component component4 = jPanel3.add((Component)simpleColoredComponent);
        AnimatedIcon animatedIcon2 = this.mySizeAsyncIcon;
        Component component5 = jPanel3.add((Component)animatedIcon2);
        this.myCompareWithButton = jButton = new JButton();
        jButton.setText("Compare with previous APK...");
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    public static class NameRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch speedSearch2) {
            this.mySpeedSearch = speedSearch2;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof ArchiveNode)) {
                this.append(value2.toString());
                return;
            }
            ArchiveEntry entry = ((ArchiveNode)value2).getData();
            this.setIcon(NameRenderer.getIconFor(entry));
            String name2 = entry.getNodeDisplayString();
            SimpleTextAttributes attr = entry instanceof ArchiveErrorEntry ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)name2, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
        }

        @NotNull
        private static Icon getIconFor(@NotNull ArchiveEntry entry) {
            String fileName;
            if (entry instanceof ArchiveErrorEntry) {
                return StudioIcons.Common.WARNING;
            }
            Path path2 = entry.getPath();
            Path base = path2.getFileName();
            String string = fileName = base == null ? "" : base.toString();
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                if (fileName.equals("AndroidManifest.xml")) {
                    return StudioIcons.Shell.Filetree.MANIFEST_FILE;
                }
                if (fileName.endsWith(".dex")) {
                    return AllIcons.FileTypes.JavaClass;
                }
                if (fileName.equals("baseline.prof") || fileName.equals("baseline.profm")) {
                    return AllIcons.FileTypes.Hprof;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
                Icon ftIcon = fileType.getIcon();
                return ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
            }
            if ((fileName = StringUtil.trimEnd((String)fileName, (String)"/")).equals("res")) {
                return AllIcons.Modules.ResourcesRoot;
            }
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Package);
        }
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myUseDownloadSize;

        public SizeRenderer(boolean useDownloadSize) {
            this.myUseDownloadSize = useDownloadSize;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            long size;
            if (!(value2 instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data = ((ArchiveTreeNode)value2).getData();
            long l = size = this.myUseDownloadSize ? data.getDownloadFileSize() : data.getRawFileSize();
            if (size > 0L) {
                this.append(HumanReadableUtil.getHumanizedSize((long)size));
            }
        }
    }

    public static interface Listener {
        public void selectionChanged(@Nullable ArchiveTreeNode[] var1);

        public void selectApkAndCompare();
    }

    public static class FutureCallBackAdapter<V>
    implements FutureCallback<V> {
        public void onSuccess(V result2) {
        }

        public void onFailure(@NotNull Throwable t) {
        }
    }
}

