/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.idea.FileEditorUtil;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.ApkVirtualFile;
import com.android.tools.idea.apk.viewer.BaselineProfilePrettyPrinter;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinterImpl;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerUtil;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.FocusTraversalPolicy;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import kotlin.io.FilesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    private final Project myProject;
    private final VirtualFile myBaseFile;
    private final VirtualFile myRoot;
    private ApkViewPanel myApkViewPanel;
    private ArchiveContext myArchiveContext;
    private final JBSplitter mySplitter;
    private ApkFileEditorComponent myCurrentEditor;

    public ApkEditor(@NotNull Project project, final @NotNull VirtualFile baseFile, @NotNull VirtualFile root) {
        this.myProject = project;
        this.myBaseFile = baseFile;
        this.myRoot = root;
        FileEditorUtil.DISABLE_GENERATED_FILE_NOTIFICATION_KEY.set((UserDataHolder)this, (Object)true);
        this.mySplitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.mySplitter.setName("apkViewerContainer");
        this.mySplitter.setFocusCycleRoot(true);
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        MessageBusConnection connection2 = project.getMessageBus().connect((Disposable)this);
        connection2.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                String basePath = ApkEditor.this.myBaseFile.getPath();
                for (VFileEvent vFileEvent : events) {
                    if (!FileUtil.pathsEqual((String)basePath, (String)vFileEvent.getPath()) || !ApkEditor.this.myBaseFile.isValid()) continue;
                    ApkEditor.this.refreshApk(baseFile);
                }
            }
        });
        this.refreshApk(this.myBaseFile);
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ApkEditor.class);
    }

    private void refreshApk(final @NotNull VirtualFile apkVirtualFile) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Reading APK contents"){

            public void run(@NotNull ProgressIndicator indicator) {
                ApkEditor.this.disposeArchive();
                try {
                    Path copyOfApk = Files.createTempFile(apkVirtualFile.getNameWithoutExtension(), "." + apkVirtualFile.getExtension(), new FileAttribute[0]);
                    FileUtils.copyFile((Path)VfsUtilCore.virtualToIoFile((VirtualFile)apkVirtualFile).toPath(), (Path)copyOfApk);
                    ApkEditor.this.myArchiveContext = Archives.open((Path)copyOfApk, (ILogger)new LogWrapper(ApkEditor.getLog()));
                    ApkEditor.this.myApkViewPanel = (ApkViewPanel)ThreadingCheckerUtil.withChecksDisabledForSupplier(() -> new ApkViewPanel(ApkEditor.this.myProject, new ApkParser(ApkEditor.this.myArchiveContext, ApkSizeCalculator.getDefault())));
                    ApkEditor.this.myApkViewPanel.setListener(ApkEditor.this);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ApkEditor.this.mySplitter.setFirstComponent(ApkEditor.this.myApkViewPanel.getContainer());
                        ApkEditor.this.selectionChanged(null);
                    });
                }
                catch (IOException e) {
                    ApkEditor.getLog().error((Throwable)e);
                    ApkEditor.this.disposeArchive();
                    ApkEditor.this.mySplitter.setFirstComponent((JComponent)new JBLabel(e.toString()));
                }
            }
        });
    }

    @Override
    public void selectionChanged(@Nullable ArchiveTreeNode[] entries2) {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        this.myCurrentEditor = this.getEditor(entries2);
        this.mySplitter.setSecondComponent(this.myCurrentEditor.getComponent());
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(file2 -> ApkFileSystem.EXTENSIONS.contains(file2.getExtension()));
        VirtualFile file3 = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.myProject, null);
        if (file3 == null) {
            return;
        }
        VirtualFile oldApk = ApkFileSystem.getInstance().getRootByLocal(file3);
        assert (oldApk != null);
        DialogBuilder builder2 = new DialogBuilder(this.myProject);
        builder2.setTitle(oldApk.getName() + " (old) vs " + this.myRoot.getName() + " (new)");
        ApkDiffPanel panel2 = new ApkDiffPanel(oldApk, this.myRoot);
        builder2.setCenterPanel(panel2.getContainer());
        builder2.setPreferredFocusComponent(panel2.getPreferredFocusedComponent());
        builder2.show();
    }

    @NotNull
    public JComponent getComponent() {
        return this.mySplitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myApkViewPanel == null) {
            return null;
        }
        return this.myApkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        return this.myBaseFile.getName();
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myBaseFile;
    }

    public void dispose() {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        ApkEditor.getLog().info("Disposing ApkEditor with ApkViewPanel: " + this.myApkViewPanel);
        this.disposeArchive();
    }

    private void disposeArchive() {
        if (this.myApkViewPanel != null) {
            this.myApkViewPanel.clearArchive();
        }
        if (this.myArchiveContext != null) {
            try {
                this.myArchiveContext.close();
                Files.deleteIfExists(this.myArchiveContext.getArchive().getPath());
            }
            catch (IOException e) {
                ApkEditor.getLog().warn((Throwable)e);
            }
            this.myArchiveContext = null;
        }
    }

    @NotNull
    private ApkFileEditorComponent getEditor(@Nullable ArchiveTreeNode[] nodes2) {
        if (nodes2 == null || nodes2.length == 0) {
            return new EmptyPanel();
        }
        boolean allDex = true;
        for (ArchiveTreeNode path2 : nodes2) {
            if (path2.getData().getPath().getFileName().toString().endsWith("dex")) continue;
            allDex = false;
            break;
        }
        if (allDex) {
            Path[] paths = new Path[nodes2.length];
            for (int i = 0; i < nodes2.length; ++i) {
                paths[i] = nodes2[i].getData().getPath();
            }
            return new DexFileViewer(this.myProject, paths, this.myBaseFile.getParent());
        }
        ArchiveTreeNode n = nodes2[0];
        Path p = n.getData().getPath();
        Path fileName = p.getFileName();
        if ("resources.arsc".equals(fileName.toString())) {
            byte[] arscContent;
            try {
                arscContent = Files.readAllBytes(p);
            }
            catch (IOException e) {
                return new EmptyPanel();
            }
            return new ArscViewer(arscContent);
        }
        if (p.toString().endsWith("dex")) {
            return new DexFileViewer(this.myProject, new Path[]{p}, this.myBaseFile.getParent());
        }
        if (p.toString().endsWith("kotlin_builtins") || p.toString().endsWith("kotlin_metadata")) {
            return new EmptyPanel();
        }
        VirtualFile file2 = this.createVirtualFile(n.getData().getArchive(), p);
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file2);
        if (!providers.isPresent()) {
            return new EmptyPanel();
        }
        if (file2 != null) {
            final FileEditor editor = providers.get().createEditor(this.myProject, file2);
            return new ApkFileEditorComponent(){

                @Override
                @NotNull
                public JComponent getComponent() {
                    return editor.getComponent();
                }

                public void dispose() {
                    Disposer.dispose((Disposable)editor);
                }
            };
        }
        return new EmptyPanel();
    }

    @Nullable
    private VirtualFile createVirtualFile(@NotNull Archive archive, @NotNull Path p) {
        byte[] content2;
        Path name2 = p.getFileName();
        if (name2 == null) {
            return null;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            return null;
        }
        try {
            content2 = Files.readAllBytes(p);
        }
        catch (IOException e) {
            ApkEditor.getLog().warn(String.format("Error loading entry \"%s\" from archive", p), (Throwable)e);
            return null;
        }
        if (archive.isBinaryXml(p, content2)) {
            content2 = BinaryXmlParser.decodeXml((String)name2.toString(), (byte[])content2);
            return ApkVirtualFile.create(p, content2);
        }
        if (archive.isProtoXml(p, content2)) {
            try {
                ProtoXmlPrettyPrinterImpl prettyPrinter = new ProtoXmlPrettyPrinterImpl();
                String text2 = prettyPrinter.prettyPrint(content2);
                return ApkVirtualFile.createText(p, text2);
            }
            catch (IOException e) {
                ApkEditor.getLog().warn(String.format("Error decoding XML entry \"%s\" from archive", p), (Throwable)e);
                return ApkVirtualFile.create(p, content2);
            }
        }
        if (archive.isBaselineProfile(p, content2)) {
            String text3 = ApkEditor.getPrettyPrintedBaseline(this.myBaseFile, content2, p, FileUtilRt.LARGE_FOR_CONTENT_LOADING);
            if (text3 != null) {
                return ApkVirtualFile.createText(p, text3);
            }
            return ApkVirtualFile.create(p, content2);
        }
        VirtualFile file2 = JarFileSystem.getInstance().findLocalVirtualFileByPath(archive.getPath().toString());
        if (file2 != null) {
            return file2.findFileByRelativePath(p.toString());
        }
        return ApkVirtualFile.create(p, content2);
    }

    @Nullable
    public static String getPrettyPrintedBaseline(@NotNull VirtualFile basefile, byte[] content2, @NotNull Path path2, int maxChars) {
        String text2;
        try {
            text2 = BaselineProfilePrettyPrinter.prettyPrint(basefile, path2, content2);
        }
        catch (IOException e) {
            ApkEditor.getLog().warn(String.format("Error decoding baseline entry \"%s\" from archive", path2), (Throwable)e);
            return null;
        }
        if (text2.length() > maxChars) {
            StringBuilder truncated = new StringBuilder(100000);
            int length = text2.getBytes(Charsets.UTF_8).length;
            truncated.append("The contents of this baseline file is too large to show by default.\nYou can increase the maximum buffer size by setting the property\n    idea.max.content.load.filesize=").append(length).append("\n(or higher)\n\n");
            try {
                File file2 = File.createTempFile("baseline", ".txt");
                FilesKt.writeText((File)file2, (String)text2, (Charset)Charsets.UTF_8);
                truncated.append("Alternatively, the full contents have been written to the following\ntemp file:\n").append(file2.getPath()).append("\n\n");
            }
            catch (IOException file2) {
                // empty catch block
            }
            int truncateAt = Math.max(0, maxChars - 450);
            truncated.append(text2, 0, truncateAt).append("\n....truncated ").append(length - truncateAt).append(" characters.");
            return truncated.toString();
        }
        return text2;
    }

    @NotNull
    private Optional<FileEditorProvider> getFileEditorProviders(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isDirectory()) {
            return Optional.empty();
        }
        List providers = FileEditorProviderManager.getInstance().getProviderList(this.myProject, file2);
        return providers.stream().filter(fileEditorProvider -> !fileEditorProvider.getClass().getName().equals("com.android.tools.idea.editors.NinePatchEditorProvider")).findFirst();
    }
}

