/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.dex;

import com.android.tools.apk.analyzer.dex.DexFiles;
import com.android.tools.smali.baksmali.Baksmali;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.concurrency.JobSchedulerImpl;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DexFileDisassembler {
    public boolean disassemble(@NotNull File dexFile, @NotNull File outputFolder) throws ExecutionException, InterruptedException {
        ListeningExecutorService executor2 = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        ListenableFuture dexFileFuture = executor2.submit(() -> DexFiles.getDexFile((Path)dexFile.toPath()));
        DexBackedDexFile dexBackedDexFile = (DexBackedDexFile)dexFileFuture.get();
        return DexFileDisassembler.disassemble((DexFile)dexBackedDexFile, outputFolder);
    }

    private static boolean disassemble(@NotNull DexFile dexFile, @NotNull File outputFolderPath) {
        return Baksmali.disassembleDexFile((DexFile)dexFile, (File)outputFolderPath, (int)JobSchedulerImpl.getCPUCoresCount(), (BaksmaliOptions)new BaksmaliOptions());
    }
}

