/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging.editor;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.apk.debugging.ExternalSourceFolders;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkDebugProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class ChooseAndAttachJavaSourcesTask
implements Runnable {
    @NotNull
    private final String myClassFqn;
    @NotNull
    private final Module myModule;
    @NotNull
    private final EditorNotifications myEditorNotifications;
    @NotNull
    private final DumbService myDumbService;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;
    @NotNull
    private final FileOrFolderChooser myFileOrFolderChooser;

    ChooseAndAttachJavaSourcesTask(@NotNull String classFqn, @NotNull Module module2, @NotNull DexSourceFiles dexSourceFiles) {
        this(classFqn, module2, DumbService.getInstance((Project)module2.getProject()), EditorNotifications.getInstance((Project)module2.getProject()), dexSourceFiles, project -> {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor2.setTitle("Attach Sources");
            descriptor2.setDescription("Select directories in which Java sources are located");
            return FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)module2.getProject(), null);
        });
    }

    @VisibleForTesting
    ChooseAndAttachJavaSourcesTask(@NotNull String classFqn, @NotNull Module module2, @NotNull DumbService dumbService, @NotNull EditorNotifications editorNotifications, @NotNull DexSourceFiles dexSourceFiles, @NotNull FileOrFolderChooser fileOrFolderChooser) {
        this.myClassFqn = classFqn;
        this.myModule = module2;
        this.myDumbService = dumbService;
        this.myEditorNotifications = editorNotifications;
        this.myDexSourceFiles = dexSourceFiles;
        this.myFileOrFolderChooser = fileOrFolderChooser;
    }

    @Override
    public void run() {
        VirtualFile[] chosenFiles = this.myFileOrFolderChooser.choose(this.myModule.getProject());
        if (chosenFiles.length > 0) {
            ApkFacet facet2 = ApkFacet.getInstance(this.myModule);
            if (facet2 != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApkDebugProject.Builder project = ApkDebugProject.newBuilder();
                project.setPackageId(AnonymizerUtil.anonymizeUtf8((String)((ApkFacetConfiguration)facet2.getConfiguration()).APP_PACKAGE));
                AndroidStudioEvent.Builder event2 = AndroidStudioEvent.newBuilder();
                event2.setCategory(AndroidStudioEvent.EventCategory.APK_DEBUG).setKind(AndroidStudioEvent.EventKind.APK_DEBUG_ATTACH_JAVA_SOURCES).setApkDebugProject(project);
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event2, this.myModule.getProject()));
            }
            ModifiableRootModel moduleModel = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            ExternalSourceFolders sourceFolders2 = new ExternalSourceFolders(moduleModel);
            sourceFolders2.addSourceFolders(chosenFiles, () -> {
                if (facet2 != null) {
                    ChooseAndAttachJavaSourcesTask.storeJavaSourceFolderPaths(facet2, chosenFiles);
                }
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)moduleModel).commit());
                this.myDumbService.smartInvokeLater(() -> this.myDexSourceFiles.navigateToJavaFile(this.myClassFqn));
                this.myEditorNotifications.updateAllNotifications();
            });
        }
    }

    private static void storeJavaSourceFolderPaths(@NotNull ApkFacet facet2, @NotNull VirtualFile[] chosenFiles) {
        ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet2.getConfiguration();
        for (VirtualFile file2 : chosenFiles) {
            File path2 = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
            configuration.JAVA_SOURCE_FOLDER_PATHS.add(path2.getPath());
        }
    }
}

