/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adblib.ddmlibcompatibility;

import com.android.adblib.AdbChannelFactory;
import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbFailResponseException;
import com.android.adblib.AdbInputChannel;
import com.android.adblib.AdbOutputChannel;
import com.android.adblib.DeviceSelector;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adblib.AdbLibApplicationService;
import com.intellij.openapi.application.ApplicationManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0005H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a%\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0080\b\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010\u001e\u001a\b\u0010\u001f\u001a\u00020\u000fH\u0000\u001a\n\u0010 \u001a\u00020!*\u00020\"\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"defaultDdmTimeoutMillis", "", "getDefaultDdmTimeoutMillis", "()J", "deprecationMessage", "", "deviceServices", "Lcom/android/adblib/AdbDeviceServices;", "getDeviceServices", "()Lcom/android/adblib/AdbDeviceServices;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getIoDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "cancelCoroutine", "", "message", "createNewFileChannel", "Lcom/android/adblib/AdbOutputChannel;", "localFilename", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOpenFileChannel", "Lcom/android/adblib/AdbInputChannel;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mapToDdmlibException", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "throwIfDispatchThread", "toDeviceSelector", "Lcom/android/adblib/DeviceSelector;", "Lcom/android/ddmlib/IDevice;", "intellij.android.adb"})
public final class UtilsKt {
    @NotNull
    public static final String deprecationMessage = "This method was created during the migration from ddmlib to adblib.\n     It blocks the caller thread so it should always be invoked on a\n     @WorkerThread. It should also eventually be replaced by a call\n     to the corresponding suspending method of adblib, or to\n     a suspending method wrapped as a ListenableFuture.";

    public static final long getDefaultDdmTimeoutMillis() {
        return DdmPreferences.getTimeOut();
    }

    @NotNull
    public static final AdbDeviceServices getDeviceServices() {
        return AdbLibApplicationService.Companion.getInstance().getSession().getDeviceServices();
    }

    @NotNull
    public static final CoroutineDispatcher getIoDispatcher() {
        return AdbLibApplicationService.Companion.getInstance().getSession().getHost().getIoDispatcher();
    }

    @NotNull
    public static final DeviceSelector toDeviceSelector(@NotNull IDevice $this$toDeviceSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$toDeviceSelector, (String)"<this>");
        String string = $this$toDeviceSelector.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialNumber");
        return DeviceSelector.Companion.fromSerialNumber(string);
    }

    public static final void throwIfDispatchThread() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
    }

    public static final void cancelCoroutine(@Nullable String message2) {
        throw new CancellationException(message2);
    }

    public static /* synthetic */ void cancelCoroutine$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        UtilsKt.cancelCoroutine(string);
    }

    @Nullable
    public static final Object createNewFileChannel(@NotNull String localFilename, @NotNull Continuation<? super AdbOutputChannel> $completion) {
        AdbChannelFactory adbChannelFactory = AdbLibApplicationService.Companion.getInstance().getSession().getChannelFactory();
        Path path2 = Paths.get(localFilename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(localFilename)");
        return adbChannelFactory.createFile(path2, $completion);
    }

    @Nullable
    public static final Object createOpenFileChannel(@NotNull String localFilename, @NotNull Continuation<? super AdbInputChannel> $completion) {
        AdbChannelFactory adbChannelFactory = AdbLibApplicationService.Companion.getInstance().getSession().getChannelFactory();
        Path path2 = Paths.get(localFilename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(localFilename)");
        return adbChannelFactory.openFile(path2, $completion);
    }

    @Nullable
    public static final Object createOpenFileChannel(@NotNull Path path2, @NotNull Continuation<? super AdbInputChannel> $completion) {
        return AdbLibApplicationService.Companion.getInstance().getSession().getChannelFactory().openFile(path2, $completion);
    }

    public static final <R> R mapToDdmlibException(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$mapToDdmlibException = false;
        try {
            object = block.invoke();
        }
        catch (AdbFailResponseException e) {
            AdbCommandRejectedException adbCommandRejectedException = AdbCommandRejectedException.create((String)e.getFailMessage());
            Intrinsics.checkNotNullExpressionValue((Object)adbCommandRejectedException, (String)"create(e.failMessage)");
            throw (Throwable)adbCommandRejectedException;
        }
        return (R)object;
    }
}

