/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adblib.ddmlibcompatibility;

import com.android.adblib.ShellCollector;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.adblib.ddmlibcompatibility.UtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J'\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/adblib/ddmlibcompatibility/ShellCollectorToIShellOutputReceiver;", "Lcom/android/adblib/ShellCollector;", "", "receiver", "Lcom/android/ddmlib/IShellOutputReceiver;", "(Lcom/android/ddmlib/IShellOutputReceiver;)V", "buf", "Lcom/android/tools/idea/adblib/ddmlibcompatibility/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "getBuf", "()Lcom/android/tools/idea/adblib/ddmlibcompatibility/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "collect", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "stdout", "Ljava/nio/ByteBuffer;", "(Lkotlinx/coroutines/flow/FlowCollector;Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "end", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "ByteArrayFromByteBuffer", "intellij.android.adb"})
public final class ShellCollectorToIShellOutputReceiver
implements ShellCollector<Unit> {
    @NotNull
    private final IShellOutputReceiver receiver;
    @NotNull
    private final ByteArrayFromByteBuffer buf;

    public ShellCollectorToIShellOutputReceiver(@NotNull IShellOutputReceiver receiver2) {
        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
        this.receiver = receiver2;
        this.buf = new ByteArrayFromByteBuffer();
    }

    @NotNull
    public final ByteArrayFromByteBuffer getBuf() {
        return this.buf;
    }

    @Nullable
    public Object start(@NotNull FlowCollector<? super Unit> collector, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    public Object collect(@NotNull FlowCollector<? super Unit> collector, @NotNull ByteBuffer stdout, @NotNull Continuation<? super Unit> $completion) {
        if (this.receiver.isCancelled()) {
            UtilsKt.cancelCoroutine("IShellOutputReceiver was cancelled during shell command execution");
        }
        this.buf.convert(stdout);
        this.receiver.addOutput(this.buf.getBytes(), this.buf.getOffset(), this.buf.getCount());
        return Unit.INSTANCE;
    }

    @Nullable
    public Object end(@NotNull FlowCollector<? super Unit> collector, @NotNull Continuation<? super Unit> $completion) {
        this.receiver.flush();
        Object object = collector.emit((Object)Unit.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/adblib/ddmlibcompatibility/ShellCollectorToIShellOutputReceiver$ByteArrayFromByteBuffer;", "", "()V", "bytes", "", "getBytes", "()[B", "setBytes", "([B)V", "count", "", "getCount", "()I", "setCount", "(I)V", "offset", "getOffset", "setOffset", "convert", "", "buffer", "Ljava/nio/ByteBuffer;", "intellij.android.adb"})
    public static final class ByteArrayFromByteBuffer {
        @NotNull
        private byte[] bytes = new byte[0];
        private int offset;
        private int count;

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        public final void setBytes(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.bytes = byArray;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final void convert(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (buffer.hasArray()) {
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
                this.bytes = byArray;
                this.offset = buffer.position();
                this.count = buffer.remaining();
            } else {
                this.offset = 0;
                this.count = buffer.remaining();
                byte[] bytes2 = new byte[this.count];
                buffer.get(bytes2);
                this.bytes = bytes2;
            }
        }
    }
}

