/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adblib;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.tools.idea.adblib.AndroidAdbLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/adblib/AndroidAdbLoggerFactory;", "Lcom/android/adblib/AdbLoggerFactory;", "()V", "categoryLoggerCache", "Lcom/android/tools/idea/adblib/AndroidAdbLoggerFactory$LoggerCache;", "", "classLoggerCache", "Ljava/lang/Class;", "logger", "Lcom/android/adblib/AdbLogger;", "getLogger", "()Lcom/android/adblib/AdbLogger;", "createLogger", "cls", "category", "LoggerCache", "intellij.android.adb"})
public final class AndroidAdbLoggerFactory
implements AdbLoggerFactory {
    @NotNull
    private final LoggerCache<Class<?>> classLoggerCache = new LoggerCache(classLoggerCache.1.INSTANCE);
    @NotNull
    private final LoggerCache<String> categoryLoggerCache = new LoggerCache(categoryLoggerCache.1.INSTANCE);
    @NotNull
    private final AdbLogger logger = this.createLogger("adblib");

    @NotNull
    public AdbLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public AdbLogger createLogger(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        return this.classLoggerCache.computeIfAbsent(cls);
    }

    @NotNull
    public AdbLogger createLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return this.categoryLoggerCache.computeIfAbsent(category);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/adblib/AndroidAdbLoggerFactory$LoggerCache;", "TKey", "", "mappingFunction", "Ljava/util/function/Function;", "Lcom/android/adblib/AdbLogger;", "(Ljava/util/function/Function;)V", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "computeIfAbsent", "key", "(Ljava/lang/Object;)Lcom/android/adblib/AdbLogger;", "intellij.android.adb"})
    private static final class LoggerCache<TKey> {
        @NotNull
        private final Function<TKey, AdbLogger> mappingFunction;
        @NotNull
        private final ConcurrentHashMap<TKey, AdbLogger> loggers;

        public LoggerCache(@NotNull Function<TKey, AdbLogger> mappingFunction) {
            Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
            this.mappingFunction = mappingFunction;
            this.loggers = new ConcurrentHashMap();
        }

        @NotNull
        public final AdbLogger computeIfAbsent(TKey key) {
            AdbLogger adbLogger = this.loggers.computeIfAbsent(key, this.mappingFunction);
            Intrinsics.checkNotNullExpressionValue((Object)adbLogger, (String)"loggers.computeIfAbsent(key, mappingFunction)");
            return adbLogger;
        }
    }
}

