/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adblib;

import com.android.adblib.AdbChannelProvider;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.ddmlib.DdmPreferences;
import com.android.tools.idea.adblib.AndroidAdbChannelProvider;
import com.android.tools.idea.adblib.AndroidAdbSessionHost;
import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.Topic;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/adblib/AdbLibApplicationService;", "Lcom/intellij/openapi/Disposable;", "()V", "channelProvider", "Lcom/android/tools/idea/adblib/AndroidAdbChannelProvider;", "host", "Lcom/android/tools/idea/adblib/AndroidAdbSessionHost;", "session", "Lcom/android/adblib/AdbSession;", "getSession", "()Lcom/android/adblib/AdbSession;", "dispose", "", "registerProject", "", "project", "Lcom/intellij/openapi/project/Project;", "registerProject$intellij_android_adb", "Companion", "MyStartupActivity", "intellij.android.adb"})
public final class AdbLibApplicationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidAdbSessionHost host = new AndroidAdbSessionHost();
    @NotNull
    private final AndroidAdbChannelProvider channelProvider = new AndroidAdbChannelProvider(this.host);
    @NotNull
    private final AdbSession session;

    public AdbLibApplicationService() {
        AdbSessionHost adbSessionHost = this.host;
        AdbChannelProvider adbChannelProvider = this.channelProvider;
        Duration duration2 = Duration.ofMillis(DdmPreferences.getTimeOut());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(DdmPreferences.getTimeOut().toLong())");
        this.session = AdbSession.Companion.create(adbSessionHost, adbChannelProvider, duration2);
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        Topics.subscribe((Topic)topic, (Disposable)this, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                channelProvider.unregisterProject(project);
            }
        });
    }

    @NotNull
    public final AdbSession getSession() {
        return this.session;
    }

    public final boolean registerProject$intellij_android_adb(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.channelProvider.registerProject(project);
    }

    public void dispose() {
        this.session.close();
        this.host.close();
    }

    @NotNull
    public static final AdbLibApplicationService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/adblib/AdbLibApplicationService$Companion;", "", "()V", "instance", "Lcom/android/tools/idea/adblib/AdbLibApplicationService;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/adblib/AdbLibApplicationService;", "intellij.android.adb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdbLibApplicationService getInstance() {
            Object object = ApplicationManager.getApplication().getService(AdbLibApplicationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026ationService::class.java)");
            return (AdbLibApplicationService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/adblib/AdbLibApplicationService$MyStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.adb"})
    public static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstance().channelProvider.registerProject(project);
        }
    }
}

