/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbDevicePairingModelListener;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.WiFiPairingDialog;
import com.android.tools.idea.adb.wireless.WiFiPairingModel;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationService;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationServiceKt;
import com.android.tools.idea.adb.wireless.WiFiPairingView;
import com.android.tools.idea.adb.wireless.WiFiPairingViewImpl;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J!\u0010\u0016\u001a\u00020\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u0019\u00a2\u0006\u0002\b\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010)\u001a\u00020\u0014H\u0016J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0014H\u0016J\u0012\u00101\u001a\u00020\u00142\b\u00102\u001a\u0004\u0018\u000103H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl;", "Lcom/android/tools/idea/adb/wireless/WiFiPairingView;", "project", "Lcom/intellij/openapi/project/Project;", "notificationService", "Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;", "model", "Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;Ljavax/swing/event/HyperlinkListener;)V", "dlg", "Lcom/android/tools/idea/adb/wireless/WiFiPairingDialog;", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/adb/wireless/WiFiPairingView$Listener;", "Lkotlin/collections/ArrayList;", "getModel", "()Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;", "addListener", "", "listener", "buildErrorHtml", "Lcom/android/utils/HtmlBuilder;", "build", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "removeListener", "showDialog", "showMdnsCheckError", "showMdnsCheckSuccess", "showMdnsNotSupportedByAdbError", "showMdnsNotSupportedError", "message", "", "showQrCodePairingError", "mdnsService", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "error", "", "showQrCodePairingInProgress", "showQrCodePairingStarted", "showQrCodePairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showQrCodePairingWaitForDevice", "pairingResult", "Lcom/android/tools/idea/adb/wireless/PairingResult;", "startMdnsCheck", "updateQrCodeImage", "image", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "ModelListener", "intellij.android.adb"})
@SourceDebugExtension(value={"SMAP\nWiFiPairingViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WiFiPairingViewImpl.kt\ncom/android/tools/idea/adb/wireless/WiFiPairingViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class WiFiPairingViewImpl
implements WiFiPairingView {
    @NotNull
    private final WiFiPairingNotificationService notificationService;
    @NotNull
    private final WiFiPairingModel model;
    @NotNull
    private final WiFiPairingDialog dlg;
    @NotNull
    private final ArrayList<WiFiPairingView.Listener> listeners;

    public WiFiPairingViewImpl(@NotNull Project project, @NotNull WiFiPairingNotificationService notificationService2, @NotNull WiFiPairingModel model2, @NotNull HyperlinkListener hyperlinkListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notificationService2, (String)"notificationService");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)hyperlinkListener, (String)"hyperlinkListener");
        this.notificationService = notificationService2;
        this.model = model2;
        this.listeners = new ArrayList();
        this.getModel().addListener(new ModelListener());
        this.dlg = new WiFiPairingDialog(project, true, DialogWrapper.IdeModalityType.PROJECT, hyperlinkListener);
        this.dlg.setPairingCodePairInvoked((Function1<? super MdnsService, Unit>)((Function1)new Function1<MdnsService, Unit>(){

            public final void invoke(@NotNull MdnsService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
                    boolean bl = false;
                    it.onPairingCodePairAction(service);
                }
            }
        }));
        this.dlg.setQrCodeScanAgainInvoked((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
                    boolean bl = false;
                    it.onScanAnotherQrCodeDeviceAction();
                }
            }
        }));
        Disposer.register((Disposable)this.dlg.getDisposable(), (Disposable)new Disposable(){

            public final void dispose() {
                Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)listeners);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
                    boolean bl = false;
                    it.onClose();
                }
            }
        });
    }

    @Override
    @NotNull
    public WiFiPairingModel getModel() {
        return this.model;
    }

    @Override
    public void showDialog() {
        this.dlg.show();
    }

    @Override
    public void startMdnsCheck() {
        this.dlg.startLoading("Preparing Wi-Fi pairing...");
    }

    @Override
    public void showMdnsCheckSuccess() {
        this.updateQrCodeImage(this.getModel().getQrCodeImage());
        this.dlg.stopLoading();
    }

    @Override
    public void showMdnsNotSupportedError() {
        this.showMdnsNotSupportedError("This system does not meet the requirements to support Wi-Fi pairing.");
    }

    private final void showMdnsNotSupportedError(String message2) {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)new Function1<HtmlBuilder, Unit>(message2){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull HtmlBuilder $this$buildErrorHtml) {
                Intrinsics.checkNotNullParameter((Object)$this$buildErrorHtml, (String)"$this$buildErrorHtml");
                $this$buildErrorHtml.add(this.$message);
                $this$buildErrorHtml.newline();
                $this$buildErrorHtml.add("Please update to the latest version of \"platform-tools\" using the SDK manager.");
                $this$buildErrorHtml.newline();
                $this$buildErrorHtml.newline();
                $this$buildErrorHtml.addLink("Open SDK manager", "open-sdk-manager");
            }
        })));
    }

    @Override
    public void showMdnsNotSupportedByAdbError() {
        this.showMdnsNotSupportedError("The currently installed version of the \"Android Debug Bridge\" (adb) does not support Wi-Fi pairing.");
    }

    @Override
    public void showMdnsCheckError() {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)showMdnsCheckError.1.INSTANCE)));
    }

    private final HtmlBuilder buildErrorHtml(Function1<? super HtmlBuilder, Unit> build2) {
        HtmlBuilder htmlBuilder;
        HtmlBuilder $this$buildErrorHtml_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$buildErrorHtml_u24lambda_u240.beginDiv("text-align: center;");
        build2.invoke((Object)$this$buildErrorHtml_u24lambda_u240);
        $this$buildErrorHtml_u24lambda_u240.newline();
        $this$buildErrorHtml_u24lambda_u240.newline();
        $this$buildErrorHtml_u24lambda_u240.addLink("Learn more", "https://d.android.com/r/studio-ui/wifi-pairing");
        $this$buildErrorHtml_u24lambda_u240.endDiv();
        return htmlBuilder;
    }

    @Override
    public void showQrCodePairingStarted() {
        this.dlg.showQrCodePairingStarted();
    }

    @Override
    public void showQrCodePairingInProgress(@NotNull MdnsService mdnsService) {
        Intrinsics.checkNotNullParameter((Object)mdnsService, (String)"mdnsService");
        this.dlg.showQrCodePairingInProgress();
    }

    @Override
    public void showQrCodePairingWaitForDevice(@NotNull PairingResult pairingResult) {
        Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
        this.dlg.showQrCodePairingWaitForDevice();
    }

    @Override
    public void showQrCodePairingSuccess(@NotNull MdnsService mdnsService, @NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)mdnsService, (String)"mdnsService");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.dlg.showQrCodePairingSuccess(device2);
        WiFiPairingNotificationServiceKt.showPairingSuccessBalloon(this.notificationService, device2);
    }

    @Override
    public void showQrCodePairingError(@NotNull MdnsService mdnsService, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)mdnsService, (String)"mdnsService");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.dlg.showQrCodePairingError(error);
    }

    @Override
    public void addListener(@NotNull WiFiPairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull WiFiPairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    private final void updateQrCodeImage(QrCodeImage image) {
        block0: {
            QrCodeImage qrCodeImage = image;
            if (qrCodeImage == null) break block0;
            QrCodeImage it = qrCodeImage;
            boolean bl = false;
            this.dlg.setQrCodeImage(it);
        }
    }

    @UiThread
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl$ModelListener;", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingModelListener;", "(Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl;)V", "pairingCodeServicesDiscovered", "", "services", "", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "qrCodeGenerated", "newImage", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "qrCodeServicesDiscovered", "intellij.android.adb"})
    private final class ModelListener
    implements AdbDevicePairingModelListener {
        @Override
        public void qrCodeGenerated(@NotNull QrCodeImage newImage) {
            Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
            WiFiPairingViewImpl.this.updateQrCodeImage(newImage);
        }

        @Override
        public void qrCodeServicesDiscovered(@NotNull List<MdnsService> services) {
            Intrinsics.checkNotNullParameter(services, (String)"services");
        }

        @Override
        public void pairingCodeServicesDiscovered(@NotNull List<MdnsService> services) {
            Intrinsics.checkNotNullParameter(services, (String)"services");
            WiFiPairingViewImpl.this.dlg.showPairingCodeServices(services);
        }
    }
}

