/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.WiFiPairingDialog;
import com.android.tools.idea.adb.wireless.WiFiPairingPanel;
import com.android.tools.idea.ui.SimpleDialog;
import com.android.tools.idea.ui.SimpleDialogOptions;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-J\u0014\u0010.\u001a\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001300J\u000e\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0014J\u0006\u00105\u001a\u00020\u0014J\u000e\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006>"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "canBeParent", "", "ideModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "(Lcom/intellij/openapi/project/Project;ZLcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;Ljavax/swing/event/HyperlinkListener;)V", "dialog", "Lcom/android/tools/idea/ui/SimpleDialog;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "pairingCodePairInvoked", "Lkotlin/Function1;", "Lcom/android/tools/idea/adb/wireless/MdnsService;", "", "getPairingCodePairInvoked", "()Lkotlin/jvm/functions/Function1;", "setPairingCodePairInvoked", "(Lkotlin/jvm/functions/Function1;)V", "pairingPanel", "Lcom/android/tools/idea/adb/wireless/WiFiPairingPanel;", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "getPanelPreferredSize", "()Lcom/intellij/util/ui/JBDimension;", "qrCodeScanAgainInvoked", "Lkotlin/Function0;", "getQrCodeScanAgainInvoked", "()Lkotlin/jvm/functions/Function0;", "setQrCodeScanAgainInvoked", "(Lkotlin/jvm/functions/Function0;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "setQrCodeImage", "qrCodeImage", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "show", "showLoadingError", "html", "Lcom/android/utils/HtmlBuilder;", "showPairingCodeServices", "services", "", "showQrCodePairingError", "error", "", "showQrCodePairingInProgress", "showQrCodePairingStarted", "showQrCodePairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showQrCodePairingWaitForDevice", "startLoading", "text", "", "stopLoading", "intellij.android.adb"})
public final class WiFiPairingDialog {
    @NotNull
    private final SimpleDialog dialog;
    @NotNull
    private final WiFiPairingPanel pairingPanel;
    @NotNull
    private Function1<? super MdnsService, Unit> pairingCodePairInvoked;
    @NotNull
    private Function0<Unit> qrCodeScanAgainInvoked;

    public WiFiPairingDialog(@NotNull Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType, @NotNull HyperlinkListener hyperlinkListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        Intrinsics.checkNotNullParameter((Object)hyperlinkListener, (String)"hyperlinkListener");
        SimpleDialogOptions options2 = new SimpleDialogOptions(project, canBeParent, ideModalityType, "Pair devices over Wi-Fi", true, (Function0)new Function0<JComponent>(this){
            final /* synthetic */ WiFiPairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JComponent invoke() {
                return this.this$0.createCenterPanel();
            }
        }, null, false, null, null, "Close", null, 2880, null);
        this.dialog = new SimpleDialog(options2);
        this.pairingPanel = new WiFiPairingPanel(this.dialog.getDisposable(), hyperlinkListener);
        this.dialog.init();
        this.pairingCodePairInvoked = pairingCodePairInvoked.1.INSTANCE;
        this.qrCodeScanAgainInvoked = qrCodeScanAgainInvoked.1.INSTANCE;
    }

    @NotNull
    public final Function1<MdnsService, Unit> getPairingCodePairInvoked() {
        return this.pairingCodePairInvoked;
    }

    public final void setPairingCodePairInvoked(@NotNull Function1<? super MdnsService, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.pairingCodePairInvoked = function1;
    }

    @NotNull
    public final Function0<Unit> getQrCodeScanAgainInvoked() {
        return this.qrCodeScanAgainInvoked;
    }

    public final void setQrCodeScanAgainInvoked(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.qrCodeScanAgainInvoked = function0;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.dialog.getDisposable();
    }

    @NotNull
    public final JComponent createCenterPanel() {
        this.pairingPanel.getRootComponent().setPreferredSize((Dimension)this.getPanelPreferredSize());
        if (SystemInfo.isMac) {
            this.pairingPanel.getRootComponent().setMinimumSize((Dimension)this.getPanelPreferredSize());
        }
        this.pairingPanel.setPairingCodePairInvoked((Function1<? super MdnsService, Unit>)((Function1)new Function1<MdnsService, Unit>(this){
            final /* synthetic */ WiFiPairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MdnsService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                this.this$0.getPairingCodePairInvoked().invoke((Object)service);
            }
        }));
        this.pairingPanel.setQrCodeScanAgainInvoked((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WiFiPairingDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getQrCodeScanAgainInvoked().invoke();
            }
        }));
        return this.pairingPanel.getRootComponent();
    }

    public final void show() {
        this.dialog.show();
    }

    public final void startLoading(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.pairingPanel.setLoading(true);
        this.pairingPanel.setLoadingText(text2);
    }

    public final void showLoadingError(@NotNull HtmlBuilder html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.pairingPanel.setLoading(false);
        this.pairingPanel.setLoadingError(html);
    }

    public final void stopLoading() {
        this.pairingPanel.setLoading(false);
    }

    public final void showPairingCodeServices(@NotNull List<MdnsService> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.pairingPanel.getPairingCodePanel().showAvailableServices(services);
    }

    public final void setQrCodeImage(@NotNull QrCodeImage qrCodeImage) {
        Intrinsics.checkNotNullParameter((Object)qrCodeImage, (String)"qrCodeImage");
        this.pairingPanel.getQrCodePanel().setQrCode(qrCodeImage);
    }

    public final void showQrCodePairingStarted() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingStarted();
    }

    public final void showQrCodePairingInProgress() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingInProgress();
    }

    public final void showQrCodePairingWaitForDevice() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingWaitForDevice();
    }

    public final void showQrCodePairingSuccess(@NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.pairingPanel.getQrCodePanel().showQrCodePairingSuccess(device2);
    }

    public final void showQrCodePairingError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.pairingPanel.getQrCodePanel().showQrCodePairingError();
    }

    private final JBDimension getPanelPreferredSize() {
        return new JBDimension(600, 600);
    }
}

