/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.ui.JSingleDigitTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

@UiThread
public class PairingCodeInputPanel {
    public static final int PAIRING_CODE_DIGIT_COUNT = 6;
    @NotNull
    private JPanel myRootContainer;
    @NotNull
    private JBLabel myDeviceAddressLabel;
    @NotNull
    private JBLabel myPairingProgressLabel;
    @NotNull
    private AsyncProcessIcon myPairingProgressAsyncIcon;
    @NotNull
    private JBLabel myStatusIconLabel;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit1;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit2;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit3;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit4;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit5;
    @NotNull
    private JSingleDigitTextField myPairingCodeDigit6;
    @NotNull
    private final List<JSingleDigitTextField> myAllDigitTextFields;

    public PairingCodeInputPanel(@NotNull Disposable parentDisposable) {
        this.$$$setupUI$$$();
        this.myPairingProgressLabel.setText("");
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myStatusIconLabel.setVisible(false);
        this.myAllDigitTextFields = Arrays.asList(this.myPairingCodeDigit1, this.myPairingCodeDigit2, this.myPairingCodeDigit3, this.myPairingCodeDigit4, this.myPairingCodeDigit5, this.myPairingCodeDigit6);
        for (int i = 0; i < this.myAllDigitTextFields.size(); ++i) {
            this.myAllDigitTextFields.get(i).setName("PairingCode-Digit-" + i);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myPairingProgressAsyncIcon);
    }

    private void createUIComponents() {
        this.myPairingProgressAsyncIcon = new AsyncProcessIcon("pairing code pairing progress");
        this.myPairingCodeDigit1 = new JSingleDigitTextField();
        this.myPairingCodeDigit2 = new JSingleDigitTextField();
        this.myPairingCodeDigit3 = new JSingleDigitTextField();
        this.myPairingCodeDigit4 = new JSingleDigitTextField();
        this.myPairingCodeDigit5 = new JSingleDigitTextField();
        this.myPairingCodeDigit6 = new JSingleDigitTextField();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootContainer;
    }

    @NotNull
    public JSingleDigitTextField getLastPairingCodeDigitComponent() {
        return this.myAllDigitTextFields.get(this.myAllDigitTextFields.size() - 1);
    }

    @NotNull
    public JSingleDigitTextField getFirstPairingCodeDigitComponent() {
        return this.myAllDigitTextFields.get(0);
    }

    @NotNull
    public String getPairingCode() {
        StringBuilder sb = new StringBuilder();
        this.myAllDigitTextFields.forEach(textField2 -> {
            String text2 = textField2.getText();
            if (text2 == null || text2.isEmpty()) {
                text2 = "0";
            }
            sb.append(text2);
        });
        return sb.toString();
    }

    public void setDevice(@NotNull MdnsService service) {
        this.myDeviceAddressLabel.setText(service.getDisplayString());
    }

    public void showProgress(@NotNull String text2) {
        this.myStatusIconLabel.setVisible(false);
        this.myPairingProgressAsyncIcon.setVisible(true);
        this.myPairingProgressLabel.setText(text2);
    }

    public void showSuccess(@NotNull AdbOnlineDevice device2) {
        this.myStatusIconLabel.setIcon(StudioIcons.Common.SUCCESS);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText(String.format("%s connected", device2.getDisplayString()));
    }

    public void showPairingError() {
        this.myStatusIconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myStatusIconLabel.setVisible(true);
        this.myPairingProgressAsyncIcon.setVisible(false);
        this.myPairingProgressLabel.setText("There was an error pairing the device");
    }

    public void setDigitsEnabled(boolean enabled2) {
        this.myAllDigitTextFields.forEach(textField2 -> textField2.setEnabled(enabled2));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 20), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Enter the 6 digit code shown on the device at");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDeviceAddressLabel = jBLabel3 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel3.getFont());
        if (font != null) {
            jBLabel3.setFont(font);
        }
        jBLabel3.setText("[xxx.xxx.xxx.xxx]");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText(" to pair.");
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 30), null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel3, new GridConstraints(4, 1, 1, 1, 0, 2, 3, 3, null, null, null));
        JSingleDigitTextField jSingleDigitTextField = this.myPairingCodeDigit1;
        ((JTextField)((Object)jSingleDigitTextField)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)((Object)jSingleDigitTextField), gridBagConstraints);
        JSingleDigitTextField jSingleDigitTextField2 = this.myPairingCodeDigit2;
        ((JTextField)((Object)jSingleDigitTextField2)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField2)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)((Object)jSingleDigitTextField2), gridBagConstraints2);
        JSingleDigitTextField jSingleDigitTextField3 = this.myPairingCodeDigit3;
        ((JTextField)((Object)jSingleDigitTextField3)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField3)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)((Object)jSingleDigitTextField3), gridBagConstraints3);
        JSingleDigitTextField jSingleDigitTextField4 = this.myPairingCodeDigit4;
        ((JTextField)((Object)jSingleDigitTextField4)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField4)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)((Object)jSingleDigitTextField4), gridBagConstraints4);
        JSingleDigitTextField jSingleDigitTextField5 = this.myPairingCodeDigit5;
        ((JTextField)((Object)jSingleDigitTextField5)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField5)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)((Object)jSingleDigitTextField5), gridBagConstraints5);
        JSingleDigitTextField jSingleDigitTextField6 = this.myPairingCodeDigit6;
        ((JTextField)((Object)jSingleDigitTextField6)).setColumns(2);
        ((JTextField)((Object)jSingleDigitTextField6)).setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 5;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)((Object)jSingleDigitTextField6), gridBagConstraints6);
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPairingProgressLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("(some text)");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 4, 2, 0, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myPairingProgressAsyncIcon;
        jPanel5.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 3, null, null, null));
        this.myStatusIconLabel = jBLabel = new JBLabel();
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(2, 0), null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel.add((Component)spacer7, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

