/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PairingCodeDevicePanel;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

@UiThread
public class PairingCodeContentPanel {
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myEmptyPanel;
    @NotNull
    private JPanel myDevicesPanel;
    @NotNull
    private JPanel myDeviceList;
    @NotNull
    private JBScrollPane myDeviceListScrollPane;
    private JBLabel myDeviceLineupLabel;
    @NotNull
    List<PairingCodeDevicePanel> myPanels;

    public PairingCodeContentPanel() {
        this.$$$setupUI$$$();
        this.myPanels = new ArrayList<PairingCodeDevicePanel>();
        this.myDeviceList.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myEmptyPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDeviceListScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myDeviceList.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootComponent;
    }

    public void showDevices(@NotNull List<MdnsService> services, @NotNull Consumer<MdnsService> pairingCodePairInvoked2) {
        if (services.isEmpty()) {
            this.myEmptyPanel.setVisible(true);
            this.myDevicesPanel.setVisible(false);
            this.myDeviceList.removeAll();
            this.myDeviceList.revalidate();
            this.myDeviceList.repaint();
            this.myPanels.clear();
        } else {
            int i;
            this.myEmptyPanel.setVisible(false);
            this.myDevicesPanel.setVisible(true);
            boolean needRepaint = false;
            for (MdnsService service : services) {
                if (PairingCodeContentPanel.isPanelPresent(this.myPanels, service)) continue;
                PairingCodeDevicePanel devicePanel = new PairingCodeDevicePanel(service, () -> pairingCodePairInvoked2.accept(service));
                this.myDeviceList.add(devicePanel.getComponent());
                this.myPanels.add(devicePanel);
                needRepaint = true;
            }
            ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
            int index2 = 0;
            for (PairingCodeDevicePanel panel2 : this.myPanels) {
                if (PairingCodeContentPanel.isPanelDeleted(services, panel2)) {
                    indicesToRemove.add(index2);
                }
                ++index2;
            }
            for (i = indicesToRemove.size() - 1; i >= 0; --i) {
                int indexToRemove = (Integer)indicesToRemove.get(i);
                this.myPanels.remove(indexToRemove);
                this.myDeviceList.remove(indexToRemove);
                needRepaint = true;
            }
            if (needRepaint) {
                this.myDeviceList.revalidate();
                this.myDeviceList.repaint();
            }
            assert (this.myPanels.size() == this.myDeviceList.getComponentCount());
            assert (services.size() == this.myDeviceList.getComponentCount());
            for (i = 0; i < this.myPanels.size(); ++i) {
                assert (this.myPanels.get(i).getComponent() == this.myDeviceList.getComponent(i));
                assert (this.myPanels.get(i).getMdnsService().equals(services.get(i)));
            }
        }
    }

    private static boolean isPanelDeleted(@NotNull List<MdnsService> services, @NotNull PairingCodeDevicePanel panel2) {
        return services.stream().noneMatch(service -> service.equals(panel2.getMdnsService()));
    }

    private static boolean isPanelPresent(@NotNull List<PairingCodeDevicePanel> panels, @NotNull MdnsService device2) {
        return panels.stream().anyMatch(panel2 -> panel2.getMdnsService().equals(device2));
    }

    private void createUIComponents() {
        this.myDeviceListScrollPane = new JBScrollPane(0);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootComponent = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        this.myDevicesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = this.myDeviceListScrollPane;
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceList = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceLineupLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(0);
        jBLabel.setIconTextGap(0);
        jBLabel.setText("Searching for devices...");
        jBLabel.setVerticalTextPosition(3);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootComponent;
    }
}

