/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.tools.idea.adb.wireless.ServiceType;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/adb/wireless/MdnsService;", "", "serviceName", "", "serviceType", "Lcom/android/tools/idea/adb/wireless/ServiceType;", "ipAddress", "Ljava/net/InetAddress;", "port", "", "(Ljava/lang/String;Lcom/android/tools/idea/adb/wireless/ServiceType;Ljava/net/InetAddress;I)V", "displayString", "getDisplayString", "()Ljava/lang/String;", "getIpAddress", "()Ljava/net/InetAddress;", "getPort", "()I", "getServiceName", "getServiceType", "()Lcom/android/tools/idea/adb/wireless/ServiceType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.android.adb"})
public final class MdnsService {
    @NotNull
    private final String serviceName;
    @NotNull
    private final ServiceType serviceType;
    @NotNull
    private final InetAddress ipAddress;
    private final int port;

    public MdnsService(@NotNull String serviceName, @NotNull ServiceType serviceType, @NotNull InetAddress ipAddress2, int port) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)((Object)serviceType), (String)"serviceType");
        Intrinsics.checkNotNullParameter((Object)ipAddress2, (String)"ipAddress");
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.ipAddress = ipAddress2;
        this.port = port;
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public final ServiceType getServiceType() {
        return this.serviceType;
    }

    @NotNull
    public final InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getDisplayString() {
        return this.ipAddress.getHostAddress() + ":" + this.port;
    }

    @NotNull
    public final String component1() {
        return this.serviceName;
    }

    @NotNull
    public final ServiceType component2() {
        return this.serviceType;
    }

    @NotNull
    public final InetAddress component3() {
        return this.ipAddress;
    }

    public final int component4() {
        return this.port;
    }

    @NotNull
    public final MdnsService copy(@NotNull String serviceName, @NotNull ServiceType serviceType, @NotNull InetAddress ipAddress2, int port) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)((Object)serviceType), (String)"serviceType");
        Intrinsics.checkNotNullParameter((Object)ipAddress2, (String)"ipAddress");
        return new MdnsService(serviceName, serviceType, ipAddress2, port);
    }

    public static /* synthetic */ MdnsService copy$default(MdnsService mdnsService, String string, ServiceType serviceType, InetAddress inetAddress, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = mdnsService.serviceName;
        }
        if ((n2 & 2) != 0) {
            serviceType = mdnsService.serviceType;
        }
        if ((n2 & 4) != 0) {
            inetAddress = mdnsService.ipAddress;
        }
        if ((n2 & 8) != 0) {
            n = mdnsService.port;
        }
        return mdnsService.copy(string, serviceType, inetAddress, n);
    }

    @NotNull
    public String toString() {
        return "MdnsService(serviceName=" + this.serviceName + ", serviceType=" + this.serviceType + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ")";
    }

    public int hashCode() {
        int result2 = this.serviceName.hashCode();
        result2 = result2 * 31 + this.serviceType.hashCode();
        result2 = result2 * 31 + this.ipAddress.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.port);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MdnsService)) {
            return false;
        }
        MdnsService mdnsService = (MdnsService)other;
        if (!Intrinsics.areEqual((Object)this.serviceName, (Object)mdnsService.serviceName)) {
            return false;
        }
        if (this.serviceType != mdnsService.serviceType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ipAddress, (Object)mdnsService.ipAddress)) {
            return false;
        }
        return this.port == mdnsService.port;
    }
}

