/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/adb/wireless/ExternalCommand;", "", "executable", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getExecutable", "()Ljava/lang/String;", "execute", "", "args", "", "stdin", "Ljava/io/InputStream;", "stdout", "Ljava/io/OutputStream;", "stderr", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "PipeConnector", "intellij.android.adb"})
@SourceDebugExtension(value={"SMAP\nExternalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalCommand.kt\ncom/android/tools/idea/adb/wireless/ExternalCommand\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n10#2:83\n*S KotlinDebug\n*F\n+ 1 ExternalCommand.kt\ncom/android/tools/idea/adb/wireless/ExternalCommand\n*L\n30#1:83\n*E\n"})
public final class ExternalCommand {
    @NotNull
    private final String executable;
    @NotNull
    private final Logger LOG;

    public ExternalCommand(@NotNull String executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        this.executable = executable;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ExternalCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        this.LOG = logger2;
    }

    @NotNull
    public final String getExecutable() {
        return this.executable;
    }

    public final int execute(@NotNull List<String> args, @NotNull InputStream stdin, @NotNull OutputStream stdout, @NotNull OutputStream stderr, long timeout, @NotNull TimeUnit unit) throws IOException {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        List command = new ArrayList();
        File exe = new File(this.executable);
        String string = exe.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exe.absolutePath");
        command.add(string);
        command.addAll((Collection)args);
        this.LOG.info("Executing command: " + command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process process2 = pb.start();
        OutputStream outputStream = process2.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"process.outputStream");
        PipeConnector inToProcess = new PipeConnector(stdin, outputStream);
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        PipeConnector processToOut = new PipeConnector(inputStream, stdout);
        InputStream inputStream2 = process2.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
        PipeConnector processToErr = new PipeConnector(inputStream2, stderr);
        inToProcess.start();
        processToOut.start();
        processToErr.start();
        int code = 255;
        try {
            boolean finished2 = process2.waitFor(timeout, unit);
            if (!finished2) {
                this.LOG.warn("Command did not terminate within specified timeout");
                process2.destroyForcibly();
            } else {
                code = process2.exitValue();
                this.LOG.info("Command finished with exit value " + code);
            }
            processToOut.join();
            stdin.close();
            inToProcess.join();
        }
        catch (InterruptedException e) {
            this.LOG.warn("Command was interrupted", (Throwable)e);
        }
        return code;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/adb/wireless/ExternalCommand$PipeConnector;", "Ljava/lang/Thread;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "run", "", "intellij.android.adb"})
    @SourceDebugExtension(value={"SMAP\nExternalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalCommand.kt\ncom/android/tools/idea/adb/wireless/ExternalCommand$PipeConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    private static final class PipeConnector
    extends Thread {
        @NotNull
        private final InputStream input;
        @NotNull
        private final OutputStream output;

        public PipeConnector(@NotNull InputStream input2, @NotNull OutputStream output) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.input = input2;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[8192];
                int read2 = 0;
                while (true) {
                    int n;
                    int it = n = this.input.read(buffer);
                    boolean bl = false;
                    read2 = it;
                    if (n > 0) {
                        this.output.write(buffer, 0, read2);
                        this.output.flush();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

