/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.processnamemonitor;

import com.android.adblib.AdbLogger;
import com.android.processmonitor.agenttracker.AgentProcessTrackerConfig;
import com.android.processmonitor.common.ProcessEvent;
import com.android.processmonitor.monitor.ProcessNameMonitor;
import com.android.processmonitor.monitor.ProcessNameMonitorImpl;
import com.android.processmonitor.monitor.ProcessNames;
import com.android.processmonitor.monitor.ddmlib.AdbAdapter;
import com.android.processmonitor.monitor.ddmlib.AdbAdapterImpl;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.adblib.AndroidAdbLogger;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService;", "Lcom/android/processmonitor/monitor/ProcessNameMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "delegate", "Lcom/android/processmonitor/monitor/ProcessNameMonitorImpl;", "", "dispose", "", "getAgentPath", "Ljava/nio/file/Path;", "getProcessNames", "Lcom/android/processmonitor/monitor/ProcessNames;", "serialNumber", "", "pid", "", "start", "trackDeviceProcesses", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/processmonitor/common/ProcessEvent;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.adb"})
@SourceDebugExtension(value={"SMAP\nProcessNameMonitorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessNameMonitorService.kt\ncom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n29#2,3:79\n8#3:82\n*S KotlinDebug\n*F\n+ 1 ProcessNameMonitorService.kt\ncom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService\n*L\n46#1:79,3\n47#1:82\n*E\n"})
public final class ProcessNameMonitorService
implements ProcessNameMonitor,
Disposable {
    @NotNull
    private final ProcessNameMonitorImpl<? extends Object> delegate;

    /*
     * Unable to fully structure code
     */
    public ProcessNameMonitorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super();
        var2_2 = this;
        var12_3 = this;
        $i$a$-let-ProcessNameMonitorService$delegate$1 = false;
        parentScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        adbSession = AdbLibService.Companion.getSession(project);
        $this$service$iv = (ComponentManager)project;
        $i$f$service = false;
        serviceClass$iv = DeviceProvisionerService.class;
        var9_13 = $this$service$iv.getService(serviceClass$iv);
        if (var9_13 == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        deviceProvisioner = ((DeviceProvisionerService)var9_13).getDeviceProvisioner();
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v0 = Logger.getInstance(ProcessNameMonitorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(T::class.java)");
        adbLogger = new AndroidAdbLogger(v0);
        v1 = AdbService.getInstance().getDebugBridge(project);
        Intrinsics.checkNotNullExpressionValue(v1, (String)"getInstance().getDebugBridge(project)");
        adbAdapter = new AdbAdapterImpl(v1);
        var9_13 = (Boolean)StudioFlags.PROCESS_NAME_TRACKER_AGENT_ENABLE.get();
        if (Intrinsics.areEqual((Object)var9_13, (Object)true)) {
            v2 = this.getAgentPath();
            v3 = StudioFlags.PROCESS_NAME_TRACKER_AGENT_INTERVAL_MS.get();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"PROCESS_NAME_TRACKER_AGENT_INTERVAL_MS.get()");
            v4 = new AgentProcessTrackerConfig(v2, ((Number)v3).intValue());
        } else if (Intrinsics.areEqual((Object)var9_13, (Object)false)) {
            v4 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        trackerAgentConfig = v4;
        v5 = StudioFlags.PROCESS_NAME_MONITOR_MAX_RETENTION.get();
        Intrinsics.checkNotNullExpressionValue(v5, (String)"PROCESS_NAME_MONITOR_MAX_RETENTION.get()");
        config = new ProcessNameMonitor.Config(((Number)v5).intValue(), trackerAgentConfig);
        v6 = StudioFlags.PROCESS_NAME_MONITOR_ADBLIB_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue(v6, (String)"PROCESS_NAME_MONITOR_ADBLIB_ENABLED.get()");
        if (!((Boolean)v6).booleanValue()) ** GOTO lbl-1000
        v7 = StudioFlags.ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER.get();
        Intrinsics.checkNotNullExpressionValue(v7, (String)"ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER.get()");
        if (((Boolean)v7).booleanValue()) {
            v8 = true;
        } else lbl-1000:
        // 2 sources

        {
            v8 = var11_15 = false;
        }
        if (var11_15) {
            v9 = ProcessNameMonitorImpl.Companion.forAdblib(parentScope, adbSession, deviceProvisioner, config, (AdbLogger)adbLogger);
        } else if (!var11_15) {
            v9 = ProcessNameMonitorImpl.Companion.forDdmlib(parentScope, adbSession, (AdbAdapter)adbAdapter, config, (AdbLogger)adbLogger);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        var12_3.delegate = v9;
    }

    public void start() {
        this.delegate.start();
    }

    @Nullable
    public ProcessNames getProcessNames(@NotNull String serialNumber, int pid) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        return this.delegate.getProcessNames(serialNumber, pid);
    }

    @Nullable
    public Object trackDeviceProcesses(@NotNull String serialNumber, @NotNull Continuation<? super Flow<? extends ProcessEvent>> $completion) {
        return this.delegate.trackDeviceProcesses(serialNumber, $completion);
    }

    public void dispose() {
        this.delegate.close();
    }

    private final Path getAgentPath() {
        Path path2;
        boolean bl = StudioPathManager.isRunningFromSources();
        if (bl) {
            Path path3 = Paths.get(StudioPathManager.getBinariesRoot(), new String[0]).resolve("tools/base/process-monitor/process-tracker-agent");
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(StudioPathManager.ge\u2026resolve(AGENT_SOURCE_DEV)");
        } else if (!bl) {
            Path path4 = PluginPathManager.getPluginHome((String)"android").toPath().resolve("resources/process-tracker-agent");
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getPluginHome(\"android\")\u2026olve(AGENT_RESOURCE_PROD)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path2;
    }
}

