/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/adb/PackageNameProvider;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getPackageName", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "project", "Lcom/intellij/openapi/project/Project;", "deviceSerialNumber", "processName", "intellij.android.adb"})
public final class PackageNameProvider {
    @NotNull
    public static final PackageNameProvider INSTANCE = new PackageNameProvider();
    @NotNull
    private static final Logger logger;
    private static final ExecutorService taskExecutor;

    private PackageNameProvider() {
    }

    @NotNull
    public final ListenableFuture<String> getPackageName(@NotNull Project project, @NotNull String deviceSerialNumber, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        File file2 = AdbFileProvider.Companion.fromProject(project).get();
        if (file2 == null) {
            throw new IllegalStateException("adb not found");
        }
        File adb = file2;
        ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(adb);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"getInstance().getDebugBridge(adb)");
        ExecutorService executorService = taskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
        return FutureUtils.transform(listenableFuture, (Executor)executorService, (Function1)((Function1)new Function1<AndroidDebugBridge, String>(processName, deviceSerialNumber){
            final /* synthetic */ String $processName;
            final /* synthetic */ String $deviceSerialNumber;
            {
                this.$processName = $processName;
                this.$deviceSerialNumber = $deviceSerialNumber;
                super(1);
            }

            @NotNull
            public final String invoke(AndroidDebugBridge androidDebugBridge) {
                String string;
                Object object;
                block4: {
                    IDevice[] iDeviceArray = androidDebugBridge.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"androidDebugBridge.devices");
                    Object[] objectArray = iDeviceArray;
                    String string2 = this.$deviceSerialNumber;
                    for (Object object2 : objectArray) {
                        IDevice it = (IDevice)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)string2, (Object)it.getSerialNumber())) continue;
                        object = object2;
                        break block4;
                    }
                    object = null;
                }
                IDevice device2 = (IDevice)object;
                if (device2 == null) {
                    PackageNameProvider.access$getLogger$p().info("Can't find device from serial number.");
                    return this.$processName;
                }
                Client client2 = device2.getClient(this.$processName);
                String packageName2 = client2.getClientData().getPackageName();
                if (packageName2 == null) {
                    PackageNameProvider.access$getLogger$p().info("Can't find package name.");
                    string = this.$processName;
                } else {
                    string = packageName2;
                }
                return string;
            }
        }));
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger2 = Logger.getInstance(PackageNameProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(PackageNameProvider::class.java)");
        logger = logger2;
        taskExecutor = PooledThreadExecutor.INSTANCE;
    }
}

