/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service
public final class AdbOptionsService {
    public static final int USER_MANAGED_ADB_PORT_DEFAULT = 5038;
    static final int USER_MANAGED_ADB_PORT_MIN_VALUE = 5038;
    static final int USER_MANAGED_ADB_PORT_MAX_VALUE = 65535;
    private static final String USE_LIBUSB = "adb.use.libusb";
    private static final String USE_MDNS_OPENSCREEN = "adb.use.mdns.openscreen";
    private static final String USE_USER_MANAGED_ADB = "AdbOptionsService.use.user.managed.adb";
    private static final String USER_MANAGED_ADB_PORT = "AdbOptionsService.user.managed.adb.port";
    private static final boolean LIBUSB_DEFAULT = false;
    private static final boolean USE_MDNS_OPENSCREEN_DEFAULT = true;
    private static final boolean USE_USER_MANAGED_ADB_DEFAULT = false;
    private final Object LOCK = new Object();
    @NotNull
    private final List<AdbOptionsListener> myListeners = new SmartList();

    public static AdbOptionsService getInstance() {
        return (AdbOptionsService)ApplicationManager.getApplication().getService(AdbOptionsService.class);
    }

    public boolean shouldUseLibusb() {
        return PropertiesComponent.getInstance().getBoolean(USE_LIBUSB, false);
    }

    public boolean shouldUseMdnsOpenScreen() {
        return PropertiesComponent.getInstance().getBoolean(USE_MDNS_OPENSCREEN, true);
    }

    boolean shouldUseUserManagedAdb() {
        return PropertiesComponent.getInstance().getBoolean(USE_USER_MANAGED_ADB, false);
    }

    int getUserManagedAdbPort() {
        return PropertiesComponent.getInstance().getInt(USER_MANAGED_ADB_PORT, 5038);
    }

    @NotNull
    public AdbOptionsUpdater getOptionsUpdater() {
        return new AdbOptionsUpdater(this);
    }

    private void commitOptions(@NotNull AdbOptionsUpdater options2) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(USE_LIBUSB, options2.useLibusb());
        props.setValue(USE_MDNS_OPENSCREEN, options2.useMdnsOpenScreen(), true);
        props.setValue(USE_USER_MANAGED_ADB, options2.useUserManagedAdb());
        props.setValue(USER_MANAGED_ADB_PORT, options2.getUserManagedAdbPort(), 5038);
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        ImmutableList listeners;
        Iterator iterator2 = this.LOCK;
        synchronized (iterator2) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        for (AdbOptionsListener listener2 : listeners) {
            listener2.optionsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    public static class AdbOptionsUpdater {
        @NotNull
        private final AdbOptionsService myService;
        private boolean myUseLibusb;
        private boolean myUseMdnsOpenScreen;
        private boolean myUseUserManagedAdb;
        private int myUserManagedAdbPort;

        private AdbOptionsUpdater(@NotNull AdbOptionsService service) {
            this.myService = service;
            this.myUseLibusb = service.shouldUseLibusb();
            this.myUseMdnsOpenScreen = service.shouldUseMdnsOpenScreen();
            this.myUseUserManagedAdb = service.shouldUseUserManagedAdb();
            this.myUserManagedAdbPort = service.getUserManagedAdbPort();
        }

        public boolean useLibusb() {
            return this.myUseLibusb;
        }

        public AdbOptionsUpdater setUseLibusb(boolean useLibusb) {
            this.myUseLibusb = useLibusb;
            return this;
        }

        public boolean useMdnsOpenScreen() {
            return this.myUseMdnsOpenScreen;
        }

        public AdbOptionsUpdater setUseMdnsOpenScreen(boolean useMdnsOpenScreen) {
            this.myUseMdnsOpenScreen = useMdnsOpenScreen;
            return this;
        }

        public boolean useUserManagedAdb() {
            return this.myUseUserManagedAdb;
        }

        public AdbOptionsUpdater setUseUserManagedAdb(boolean useUserManagedAdb) {
            this.myUseUserManagedAdb = useUserManagedAdb;
            return this;
        }

        public int getUserManagedAdbPort() {
            return this.myUserManagedAdbPort;
        }

        public AdbOptionsUpdater setUserManagedAdbPort(int userManagedAdbPort) {
            this.myUserManagedAdbPort = userManagedAdbPort;
            return this;
        }

        public void commit() {
            this.myService.commitOptions(this);
        }
    }

    public static interface AdbOptionsListener {
        public void optionsChanged();
    }
}

