/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.actions.SendFeedbackDescriptionProvider;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.URLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SendFeedbackAction.class);
    private static final String UNKNOWN_VERSION = "Unknown";

    public void actionPerformed(@NotNull AnActionEvent e) {
        SendFeedbackAction.submit(e.getProject());
    }

    public static void submit(@Nullable Project project) {
        SendFeedbackAction.submit(project, "");
    }

    public static void submit(final @Nullable Project project, final @Nullable String extraDescriptionDetails) {
        new Task.Modal(project, "Collecting Data", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Collecting feedback information");
                indicator.setIndeterminate(true);
                ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
                String feedbackUrl = (Boolean)StudioFlags.ENABLE_NEW_COLLECT_LOGS_DIALOG.get() != false ? SendFeedbackAction.getNewFeedbackUrl() : applicationInfo.getFeedbackUrl();
                String version2 = SendFeedbackAction.getVersion(applicationInfo);
                feedbackUrl = feedbackUrl.replace("$STUDIO_VERSION", version2);
                String description2 = SendFeedbackAction.getDescription(project);
                com.intellij.ide.actions.SendFeedbackAction.submit((Project)project, (String)feedbackUrl, (String)(description2 + extraDescriptionDetails));
            }
        }.setCancelText("Cancel").queue();
    }

    private static String getVersion(ApplicationInfoEx applicationInfo) {
        String major = applicationInfo.getMajorVersion();
        if (major == null) {
            return UNKNOWN_VERSION;
        }
        String minor = applicationInfo.getMinorVersion();
        if (minor == null) {
            return UNKNOWN_VERSION;
        }
        String micro = applicationInfo.getMicroVersion();
        if (micro == null) {
            return UNKNOWN_VERSION;
        }
        String patch = applicationInfo.getPatchVersion();
        if (patch == null) {
            return UNKNOWN_VERSION;
        }
        return String.join((CharSequence)".", major, minor, micro, patch);
    }

    @Slow
    public static String getDescription(@Nullable Project project) {
        return SendFeedbackAction.safeCall(() -> {
            StringBuilder sb = new StringBuilder(com.intellij.ide.actions.SendFeedbackAction.getDescription(null));
            sb.append("\n\n");
            sb.append(String.format("AS: %1$s\n", ApplicationInfoEx.getInstanceEx().getFullVersion()));
            sb.append(String.format("Kotlin plugin: %1$s\n", SendFeedbackAction.safeCall(SendFeedbackAction::getKotlinPluginDetails)));
            for (SendFeedbackDescriptionProvider provider2 : SendFeedbackDescriptionProvider.getProviders()) {
                provider2.getDescription(project).forEach(str -> sb.append(str + "\n"));
            }
            return sb.toString();
        });
    }

    public static String safeCall(@NotNull Supplier<String> runnable2) {
        try {
            return runnable2.get();
        }
        catch (Throwable e) {
            LOG.info("Unable to prepopulate additional version information - proceeding with sending feedback anyway. ", e);
            return "(unable to retrieve additional version information)";
        }
    }

    private static String getKotlinPluginDetails() {
        PluginId kotlinPluginId = PluginId.findId((String)"org.jetbrains.kotlin");
        IdeaPluginDescriptor kotlinPlugin = PluginManagerCore.getPlugin((PluginId)kotlinPluginId);
        if (kotlinPlugin != null) {
            return kotlinPlugin.getVersion();
        }
        return "(kotlin plugin not found)";
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows);
        }
    }

    private static String getNewFeedbackUrl() {
        String instructions = "####################################################\n\nPlease provide all of the following information, otherwise we may not be able to route your bug report.\n\n####################################################\n\n\n1. Describe the bug or issue that you're seeing.\n\n\n\n2. Attach log files from Android Studio\n  2A. In the IDE, select the Help..Collect Logs and Diagnostic Data menu option.\n  2B. Create a diagnostic report and save it to your local computer.\n  2C. Attach the report to this bug using the Add attachments button.\n\n3. If you know what they are, write the steps to reproduce:\n\n   3A.\n   3B.\n   3C.\n\nIn addition to logs, please attach a screenshot or recording that illustrates the problem.\n\nFor more information on how to get your bug routed quickly, see https://developer.android.com/studio/report-bugs.html\n";
        ApplicationInfoEx app = ApplicationInfoEx.getInstanceEx();
        String buildNumber = app.getBuild().asString();
        Date date = app.getBuildDate().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String strDate = dateFormat.format(date);
        return "https://issuetracker.google.com/issues/new?component=192708&template=840533&foundIn=$STUDIO_VERSION&format=MARKDOWN&description=%60%60%60%0A" + URLUtil.encodeURIComponent((String)instructions) + "%0ABuild%3A%20" + buildNumber + "%2C%20" + strDate + "$DESCR%60%60%60";
    }
}

