/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.NonNls;

public class AndroidInitialConfigurator {
    @NonNls
    private static final ExtensionPointName<Runnable> EP_NAME = ExtensionPointName.create((String)"com.intellij.androidStudioInitializer");

    public AndroidInitialConfigurator() {
        AndroidInitialConfigurator.setupSystemProperties();
        AndroidInitialConfigurator.activateAndroidStudioInitializerExtensions();
    }

    private static void setupSystemProperties() {
        Object updateUrl = System.getenv("AS_UPDATE_URL");
        if (updateUrl != null) {
            if (!((String)updateUrl).endsWith("/")) {
                updateUrl = (String)updateUrl + "/";
            }
            System.setProperty("idea.updates.url", (String)updateUrl + "updates.xml");
            System.setProperty("idea.patches.url", (String)updateUrl);
        }
    }

    private static void activateAndroidStudioInitializerExtensions() {
        for (Runnable r : EP_NAME.getExtensionList()) {
            r.run();
        }
    }
}

