/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.ViewNodeType;
import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.android.tools.componenttree.treetable.TreeTableModelImpl;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0015\u0016B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/componenttree/treetable/ViewTreeCellRenderer;", "T", "Ljavax/swing/tree/TreeCellRenderer;", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "(Lcom/android/tools/componenttree/api/ViewNodeType;)V", "renderer", "Lcom/android/tools/componenttree/treetable/ViewTreeCellRenderer$ColoredViewRenderer;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "ColoredViewRenderer", "Companion", "intellij.android.layout-ui"})
public final class ViewTreeCellRenderer<T>
implements TreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewNodeType<T> type;
    @NotNull
    private final ColoredViewRenderer renderer;

    public ViewTreeCellRenderer(@NotNull ViewNodeType<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.renderer = new ColoredViewRenderer();
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.renderer.reset();
        Object t = this.type.getClazz().cast(value2);
        if (t == null) {
            return (Component)((Object)this.renderer);
        }
        Object node = t;
        this.renderer.setCurrentTree(tree2 instanceof TreeTableTree ? (TreeTableTree)tree2 : null);
        TreeTableTree treeTableTree = this.renderer.getCurrentTree();
        TreeTable treeTable2 = treeTableTree != null ? treeTableTree.getTreeTable() : null;
        this.renderer.setCurrentTable(treeTable2 instanceof TreeTableImpl ? (TreeTableImpl)treeTable2 : null);
        this.renderer.setCurrentRow(row2);
        Object object = this.renderer.getCurrentTable();
        this.renderer.setCurrentDepth(object != null && (object = ((TreeTableImpl)object).getTableModel()) != null ? ((TreeTableModelImpl)object).computeDepth(value2) : 1);
        this.renderer.setSelectedValue(selected);
        this.renderer.setFocusedValue(hasFocus && selected);
        this.renderer.setId(ViewTreeCellRenderer.Companion.stripId(this.type.idOf(node)));
        this.renderer.setTagName(StringsKt.substringAfterLast$default((String)this.type.tagNameOf(node), (char)'.', null, (int)2, null));
        this.renderer.setTextValue(this.type.textValueOf(node));
        this.renderer.setTreeIcon(this.type.iconOf(node));
        this.renderer.setEnabledValue(this.type.isEnabled(node));
        this.renderer.setDeEmphasized(this.type.isDeEmphasized(node));
        this.renderer.generate();
        return (Component)((Object)this.renderer);
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010A\u001a\u00020BH\u0007J*\u0010C\u001a\u00020\u001c2\b\u0010D\u001a\u0004\u0018\u00010(2\u0006\u0010E\u001a\u0002012\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0007H\u0002J\u0006\u0010H\u001a\u00020BJ\u0010\u0010H\u001a\u00020B2\u0006\u0010G\u001a\u00020\u0007H\u0002J\n\u0010I\u001a\u0004\u0018\u00010(H\u0002J\u0010\u0010J\u001a\u00020B2\u0006\u0010K\u001a\u00020LH\u0014J\u0006\u0010M\u001a\u00020BJ\b\u0010N\u001a\u00020\u001cH\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\n \u0005*\u0004\u0018\u00010101X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010*\"\u0004\b7\u0010,R\u001c\u00108\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010*\"\u0004\b:\u0010,R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006O"}, d2={"Lcom/android/tools/componenttree/treetable/ViewTreeCellRenderer$ColoredViewRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "()V", "baseFontMetrics", "Ljava/awt/FontMetrics;", "kotlin.jvm.PlatformType", "currentDepth", "", "getCurrentDepth", "()I", "setCurrentDepth", "(I)V", "currentRow", "getCurrentRow", "setCurrentRow", "currentTable", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "getCurrentTable", "()Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "setCurrentTable", "(Lcom/android/tools/componenttree/treetable/TreeTableImpl;)V", "currentTree", "Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;", "getCurrentTree", "()Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;", "setCurrentTree", "(Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;)V", "deEmphasized", "", "getDeEmphasized", "()Z", "setDeEmphasized", "(Z)V", "enabledValue", "getEnabledValue", "setEnabledValue", "focusedValue", "getFocusedValue", "setFocusedValue", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "selectedValue", "getSelectedValue", "setSelectedValue", "small", "Lcom/intellij/ui/SimpleTextAttributes;", "smallFontMetrics", "smallStrikeout", "strikeout", "tagName", "getTagName", "setTagName", "textValue", "getTextValue", "setTextValue", "treeIcon", "Ljavax/swing/Icon;", "getTreeIcon", "()Ljavax/swing/Icon;", "setTreeIcon", "(Ljavax/swing/Icon;)V", "adjustForPainting", "", "append", "text", "attributes", "metrics", "maxWidth", "generate", "generateTooltip", "paintComponent", "g", "Ljava/awt/Graphics;", "reset", "shouldPaintBackground", "intellij.android.layout-ui"})
    @SourceDebugExtension(value={"SMAP\nViewTreeCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewTreeCellRenderer.kt\ncom/android/tools/componenttree/treetable/ViewTreeCellRenderer$ColoredViewRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
    public static final class ColoredViewRenderer
    extends SimpleColoredRenderer {
        @Nullable
        private TreeTableTree currentTree;
        @Nullable
        private TreeTableImpl currentTable;
        private int currentDepth = 1;
        private int currentRow = -1;
        private boolean selectedValue;
        private boolean focusedValue;
        @Nullable
        private String id;
        @NotNull
        private String tagName = "";
        @Nullable
        private String textValue;
        @Nullable
        private Icon treeIcon;
        private boolean enabledValue = true;
        private boolean deEmphasized;
        private final FontMetrics baseFontMetrics = this.getFontMetrics(StartupUiUtil.getLabelFont());
        private final FontMetrics smallFontMetrics = this.getFontMetrics(StartupUiUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        private final SimpleTextAttributes strikeout = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(4, null, null, null);
        @NotNull
        private final SimpleTextAttributes small = new SimpleTextAttributes(128, null);
        @NotNull
        private final SimpleTextAttributes smallStrikeout = new SimpleTextAttributes(132, null);

        public ColoredViewRenderer() {
            this.setFont(StartupUiUtil.getLabelFont());
            this.setIpad((Insets)new JBInsets(0, 0, 0, 0));
        }

        @Nullable
        public final TreeTableTree getCurrentTree() {
            return this.currentTree;
        }

        public final void setCurrentTree(@Nullable TreeTableTree treeTableTree) {
            this.currentTree = treeTableTree;
        }

        @Nullable
        public final TreeTableImpl getCurrentTable() {
            return this.currentTable;
        }

        public final void setCurrentTable(@Nullable TreeTableImpl treeTableImpl) {
            this.currentTable = treeTableImpl;
        }

        public final int getCurrentDepth() {
            return this.currentDepth;
        }

        public final void setCurrentDepth(int n) {
            this.currentDepth = n;
        }

        public final int getCurrentRow() {
            return this.currentRow;
        }

        public final void setCurrentRow(int n) {
            this.currentRow = n;
        }

        public final boolean getSelectedValue() {
            return this.selectedValue;
        }

        public final void setSelectedValue(boolean bl) {
            this.selectedValue = bl;
        }

        public final boolean getFocusedValue() {
            return this.focusedValue;
        }

        public final void setFocusedValue(boolean bl) {
            this.focusedValue = bl;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final void setId(@Nullable String string) {
            this.id = string;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final void setTagName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.tagName = string;
        }

        @Nullable
        public final String getTextValue() {
            return this.textValue;
        }

        public final void setTextValue(@Nullable String string) {
            this.textValue = string;
        }

        @Nullable
        public final Icon getTreeIcon() {
            return this.treeIcon;
        }

        public final void setTreeIcon(@Nullable Icon icon2) {
            this.treeIcon = icon2;
        }

        public final boolean getEnabledValue() {
            return this.enabledValue;
        }

        public final void setEnabledValue(boolean bl) {
            this.enabledValue = bl;
        }

        public final boolean getDeEmphasized() {
            return this.deEmphasized;
        }

        public final void setDeEmphasized(boolean bl) {
            this.deEmphasized = bl;
        }

        protected boolean shouldPaintBackground() {
            return false;
        }

        public final void reset() {
            this.clear();
            this.currentTree = null;
            this.currentRow = -1;
            this.id = null;
            this.tagName = "";
            this.textValue = null;
        }

        public final void generate() {
            this.generate(0);
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.currentTree != null) {
                this.adjustForPainting();
            }
            super.paintComponent(g);
        }

        private final void generate(int maxWidth) {
            block2: {
                this.clear();
                this.setIcon(this.treeIcon);
                this.setToolTipText(this.generateTooltip());
                SimpleTextAttributes attributes = null;
                attributes = !this.enabledValue ? this.strikeout : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                String string = this.id;
                if (string == null) {
                    string = this.tagName;
                }
                String primary = string;
                SimpleTextAttributes simpleTextAttributes = attributes;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes");
                FontMetrics fontMetrics = this.baseFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"baseFontMetrics");
                if (!this.append(primary, simpleTextAttributes, fontMetrics, maxWidth)) {
                    return;
                }
                SimpleTextAttributes simpleTextAttributes2 = attributes = !this.enabledValue ? this.smallStrikeout : (this.selectedValue ? this.small : SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                String string2 = this.textValue;
                if (string2 == null || (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = " " + it;
                SimpleTextAttributes simpleTextAttributes3 = attributes;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"attributes");
                FontMetrics fontMetrics2 = this.smallFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"smallFontMetrics");
                this.append(string3, simpleTextAttributes3, fontMetrics2, maxWidth);
            }
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public final void adjustForPainting() {
            Icon icon2;
            int maxWidth;
            TreeTableImpl treeTableImpl = this.currentTable;
            int n = maxWidth = treeTableImpl != null ? treeTableImpl.computeMaxRenderWidth(this.currentDepth) : 0;
            if (this.getPreferredSize().width > maxWidth) {
                boolean bl;
                TreeTableImpl treeTableImpl2 = this.currentTable;
                if (treeTableImpl2 != null) {
                    Integer n2 = treeTableImpl2.getExpandedRow();
                    int n3 = this.currentRow;
                    bl = n2 != null && n2 == n3;
                } else {
                    bl = false;
                }
                if (!bl) {
                    this.generate(maxWidth);
                }
            }
            this.setForeground(UIUtil.getTreeForeground((boolean)this.selectedValue, (boolean)this.focusedValue));
            this.setBackground(UIUtil.getTreeBackground((boolean)this.selectedValue, (boolean)this.focusedValue));
            ColoredViewRenderer coloredViewRenderer = this;
            Icon icon3 = this.treeIcon;
            if (icon3 != null) {
                void it;
                Icon icon4 = icon3;
                ColoredViewRenderer coloredViewRenderer2 = coloredViewRenderer;
                boolean bl = false;
                icon2 = this.focusedValue && !ExperimentalUI.isNewUI() ? ColoredIconGenerator.generateWhiteIcon((Icon)it) : icon4;
                coloredViewRenderer = coloredViewRenderer2;
            } else {
                icon2 = null;
            }
            coloredViewRenderer.setIcon(icon2);
            if (!(this.selectedValue || !this.deEmphasized && this.enabledValue)) {
                Color color = this.getForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground");
                this.setForeground(ColoredIconGenerator.INSTANCE.deEmphasize(color));
                Icon icon5 = this.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"icon");
                this.setIcon(ColoredIconGenerator.INSTANCE.generateDeEmphasizedIcon(icon5));
            }
            this.setTransparentIconBackground(true);
        }

        private final boolean append(String text2, SimpleTextAttributes attributes, FontMetrics metrics, int maxWidth) {
            String string = text2;
            if (string == null) {
                return true;
            }
            String actual = string;
            boolean unchanged = true;
            if (maxWidth > 0) {
                int availableSpace = maxWidth - this.getPreferredSize().width;
                if (metrics.stringWidth(actual) > availableSpace) {
                    actual = AdtUiUtils.shrinkToFit$default((String)text2, (FontMetrics)metrics, (float)availableSpace, null, (int)8, null);
                    if (((CharSequence)actual).length() == 0 && ((CharSequence)text2).length() > 0 && this.getFragmentTag(0) == null) {
                        char c = StringsKt.first((CharSequence)text2);
                        String string2 = "...";
                        actual = c + string2;
                    }
                    unchanged = !Intrinsics.areEqual((Object)actual, (Object)text2);
                }
            }
            this.append(actual, attributes);
            return unchanged;
        }

        private final String generateTooltip() {
            CharSequence charSequence = this.id;
            return charSequence == null || charSequence.length() == 0 || ((CharSequence)this.tagName).length() == 0 ? null : StringsKt.trimIndent((String)("\n        <html>\n          " + this.tagName + "<br/>\n          " + (String)((charSequence = (CharSequence)this.textValue) == null || charSequence.length() == 0 ? this.id : this.id + ": " + this.textValue) + "\n        </html>\n        "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/componenttree/treetable/ViewTreeCellRenderer$Companion;", "", "()V", "computeSearchString", "", "T", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "node", "(Lcom/android/tools/componenttree/api/ViewNodeType;Ljava/lang/Object;)Ljava/lang/String;", "stripId", "id", "intellij.android.layout-ui"})
    @SourceDebugExtension(value={"SMAP\nViewTreeCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewTreeCellRenderer.kt\ncom/android/tools/componenttree/treetable/ViewTreeCellRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> String computeSearchString(@NotNull ViewNodeType<T> type, T node) {
            Object str;
            block3: {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                String id2 = type.idOf(node);
                String textValue = type.textValueOf(node);
                str = null;
                Object object = this.stripId(id2);
                if (object == null) {
                    object = str = "";
                }
                if (id2 == null || textValue == null) {
                    if (id2 != null) {
                        str = str + " - ";
                    }
                    str = str + StringsKt.substringAfterLast$default((String)type.tagNameOf(node), (char)'.', null, (int)2, null);
                }
                String string = textValue;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                str = str + " " + it;
            }
            return str;
        }

        private final String stripId(String id2) {
            String string = id2;
            return string != null ? StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

