/*
 * Decompiled with CFR 0.152.
 */
package com.android.sync.analyzer;

import com.android.build.attribution.analytics.BuildAttributionAnalyticsManagerKt;
import com.android.build.output.DownloadsInfoPresentableBuildEvent;
import com.android.sync.analyzer.SyncAnalyzerDataManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.SyncAnalyzerManager;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerManagerImpl;", "Lcom/android/tools/idea/gradle/project/sync/SyncAnalyzerManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onSyncFinished", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onSyncStarted", "updateSyncStatsData", "syncStats", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Builder;", "setUpDownloadsInfoNodeOnBuildOutput", "dataHolder", "Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "intellij.android.build-attribution"})
public final class SyncAnalyzerManagerImpl
implements SyncAnalyzerManager {
    @NotNull
    private final Project project;

    public SyncAnalyzerManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void updateSyncStatsData(@Nullable ExternalSystemTaskId id2, @NotNull GradleSyncStats.Builder syncStats) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)syncStats, (String)"syncStats");
            if (id2 == null) {
                return;
            }
            SyncAnalyzerDataManager.DataHolder dataHolder = ((SyncAnalyzerDataManager)this.project.getService(SyncAnalyzerDataManager.class)).getDataForTaskIfExists(id2);
            if (dataHolder == null) break block1;
            SyncAnalyzerDataManager.DataHolder downloadsData = dataHolder;
            boolean bl = false;
            syncStats.setDownloadsData(BuildAttributionAnalyticsManagerKt.transformDownloadsAnalyzerData(downloadsData.getDownloadsStatsAccumulator().getRepositoryResults()));
        }
    }

    @Override
    public void onSyncStarted(@Nullable ExternalSystemTaskId id2) {
        if (id2 == null) {
            return;
        }
        SyncAnalyzerDataManager.DataHolder data = ((SyncAnalyzerDataManager)this.project.getService(SyncAnalyzerDataManager.class)).getOrCreateDataForTask(id2);
        this.setUpDownloadsInfoNodeOnBuildOutput(this.project, id2, data);
    }

    @Override
    public void onSyncFinished(@Nullable ExternalSystemTaskId id2) {
        if (id2 == null) {
            return;
        }
        ((SyncAnalyzerDataManager)this.project.getService(SyncAnalyzerDataManager.class)).clearDataForTask(id2);
    }

    private final void setUpDownloadsInfoNodeOnBuildOutput(Project $this$setUpDownloadsInfoNodeOnBuildOutput, ExternalSystemTaskId id2, SyncAnalyzerDataManager.DataHolder dataHolder) {
        if (!((Boolean)StudioFlags.BUILD_OUTPUT_DOWNLOADS_INFORMATION.get()).booleanValue()) {
            return;
        }
        if (dataHolder.getDownloadsInfoDataModel() == null) {
            return;
        }
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion($this$setUpDownloadsInfoNodeOnBuildOutput);
        DownloadsInfoPresentableBuildEvent rootDownloadEvent = new DownloadsInfoPresentableBuildEvent(id2, dataHolder.getBuildDisposable(), dataHolder.getBuildStartTimestampMs(), gradleVersion2, dataHolder.getDownloadsInfoDataModel());
        SyncViewManager viewManager = (SyncViewManager)$this$setUpDownloadsInfoNodeOnBuildOutput.getService(SyncViewManager.class);
        viewManager.onEvent((Object)id2, (BuildEvent)rootDownloadEvent);
    }
}

